/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.jetbrains.nodejs.run.profile.heap.io.IntegerRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TickIndexer {
    private final List<Integer> myFloorTickIdx;
    private final List<Integer> myCeilingTickIdx;
    private final long myIndexInterval;
    private int myNextIdx;
    private int myTickIdx;
    private long myLastTick;

    public TickIndexer(long indexInterval) {
        this.myIndexInterval = indexInterval;
        this.myFloorTickIdx = new ArrayList<Integer>();
        this.myCeilingTickIdx = new ArrayList<Integer>();
        this.myNextIdx = 1;
        this.myTickIdx = 0;
        this.myLastTick = 0L;
    }

    private TickIndexer(List<Integer> floorTickIdx, List<Integer> ceilingTickIdx, int tickIdx, long lastTick, long indexInterval) {
        this.myFloorTickIdx = floorTickIdx;
        this.myCeilingTickIdx = ceilingTickIdx;
        this.myTickIdx = tickIdx;
        this.myLastTick = lastTick;
        this.myIndexInterval = indexInterval;
    }

    public void nextTick(long tick) {
        assert (this.myIndexInterval > 0L);
        if (tick < this.myLastTick) {
            ++this.myTickIdx;
            return;
        }
        if (tick >= (long)this.myNextIdx * this.myIndexInterval) {
            int toIdx = (int)Math.floor((double)tick / (double)this.myIndexInterval);
            int floor = this.myTickIdx == 0 ? 0 : this.myTickIdx - 1;
            for (int i = this.myNextIdx; i <= toIdx; ++i) {
                this.myFloorTickIdx.add(floor);
                this.myCeilingTickIdx.add(this.myTickIdx);
            }
            this.myNextIdx = toIdx + 1;
        }
        this.myLastTick = tick;
        ++this.myTickIdx;
    }

    public int getNumTicks() {
        return this.myTickIdx;
    }

    public long getLastTick() {
        return this.myLastTick;
    }

    public boolean isEmpty() {
        return this.myFloorTickIdx.isEmpty() || this.myCeilingTickIdx.isEmpty();
    }

    public Integer getFloorIndexFor(long ts) {
        assert (ts >= 0L);
        if (this.myFloorTickIdx.isEmpty()) {
            return 0;
        }
        int floor = (int)Math.floor((double)ts / (double)this.myIndexInterval);
        return floor > this.myFloorTickIdx.size() ? this.myFloorTickIdx.get(this.myFloorTickIdx.size() - 1) : (floor == 0 ? Integer.valueOf(0) : this.myFloorTickIdx.get(floor - 1));
    }

    public Integer getCeilIndexFor(long ts) {
        assert (ts >= 0L);
        if (this.myCeilingTickIdx.isEmpty()) {
            return this.myTickIdx - 1;
        }
        int ceil = (int)Math.ceil((double)ts / (double)this.myIndexInterval);
        if (this.myCeilingTickIdx.isEmpty()) {
            return -1;
        }
        return ceil > this.myCeilingTickIdx.size() ? this.myCeilingTickIdx.get(this.myCeilingTickIdx.size() - 1) : (ceil == 0 ? Integer.valueOf(0) : this.myCeilingTickIdx.get(ceil - 1));
    }

    public static class MySerializer
    implements RawSerializer<TickIndexer> {
        @Override
        public long getRecordSize() {
            return -1L;
        }

        @Override
        public void write(@NotNull DataOutput os, @NotNull TickIndexer tickIndexer) throws IOException {
            if (os == null) {
                MySerializer.$$$reportNull$$$0(0);
            }
            if (tickIndexer == null) {
                MySerializer.$$$reportNull$$$0(1);
            }
            os.writeLong(tickIndexer.getLastTick());
            os.writeInt(tickIndexer.getNumTicks());
            os.writeLong(tickIndexer.myIndexInterval);
            this.writeList(os, tickIndexer.myFloorTickIdx);
            this.writeList(os, tickIndexer.myCeilingTickIdx);
        }

        private void writeList(@NotNull DataOutput os, @NotNull List<Integer> list) throws IOException {
            if (os == null) {
                MySerializer.$$$reportNull$$$0(2);
            }
            if (list == null) {
                MySerializer.$$$reportNull$$$0(3);
            }
            os.writeInt(list.size());
            IntegerRawSerializer serializer = new IntegerRawSerializer();
            for (Integer integer : list) {
                serializer.write(os, integer);
            }
        }

        private List<Integer> readList(@NotNull DataInput is) throws IOException {
            if (is == null) {
                MySerializer.$$$reportNull$$$0(4);
            }
            int size = is.readInt();
            ArrayList<Integer> list = new ArrayList<Integer>(size);
            IntegerRawSerializer serializer = new IntegerRawSerializer();
            for (int i = 0; i < size; ++i) {
                list.add(serializer.read(is));
            }
            return list;
        }

        @Override
        public TickIndexer read(@NotNull DataInput is) throws IOException {
            if (is == null) {
                MySerializer.$$$reportNull$$$0(5);
            }
            long lastTick = is.readLong();
            int numTicks = is.readInt();
            long indexInterval = is.readLong();
            return new TickIndexer(this.readList(is), this.readList(is), numTicks, lastTick, indexInterval);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tickIndexer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "is";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TickIndexer$MySerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeList";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

