# This script will be called from the 'Setup' utility
#

use Carp;

sub spcomplain
{
    my ($mod, $err) = @_;

    print qq|
You do not have the correct binary of the $mod module
installed in either your PilotManager distribution or your
perl installation.  SyncPlan will not be able to run until
this is fixed.

Please read README.porting for information about how to
download and install this module.

Error details:
-----------------------------------------------------------------------------
$err-----------------------------------------------------------------------------

|;
    croak("FAIL");
}

eval "use IO::Socket";
&spcomplain("IO::Socket", $@) if ($@);

eval "use IO::Select";
&spcomplain("IO::Select", $@) if ($@);

eval "use Digest::MD5";
&spcomplain("Digest::MD5", $@) if ($@);

print qq|
All required modules are installed properly on your system,
so SyncPlan will run.

|;

