/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;

public class JsonStreamWriter {
    private final StringBuilder m_buffer = new StringBuilder();
    private final OutputStreamWriter m_writer;
    private final Deque<Boolean> m_firstNameValuePair = new LinkedList<Boolean>();
    private boolean m_pretty;
    private String m_indent = "";
    private DateFormat m_format = new SimpleDateFormat("\"yyyy-MM-dd'T'HH:mm:ss.S\"");
    private static final String INDENT = "  ";

    public JsonStreamWriter(OutputStream outputStream, Charset charset) {
        this.m_writer = new OutputStreamWriter(outputStream, charset);
        this.m_firstNameValuePair.push(Boolean.TRUE);
    }

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean bl) {
        this.m_pretty = bl;
    }

    public void flush() throws IOException {
        this.m_writer.flush();
    }

    public void writeStartObject(String string) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        if (string != null) {
            this.writeName(string);
            this.writeNewLineIndent();
        }
        this.m_writer.write("{");
        this.increaseIndent();
    }

    public void writeStartList(String string) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        this.writeName(string);
        this.writeNewLineIndent();
        this.m_writer.write("[");
        this.increaseIndent();
    }

    public void writeEndObject() throws IOException {
        this.decreaseIndent();
        this.m_writer.write("}");
    }

    public void writeEndList() throws IOException {
        this.decreaseIndent();
        this.m_writer.write("]");
    }

    public void writeNameValuePair(String string, String string2) throws IOException {
        this.internalWriteNameValuePair(string, this.escapeString(string2));
    }

    public void writeNameValuePair(String string, int n) throws IOException {
        this.internalWriteNameValuePair(string, Integer.toString(n));
    }

    public void writeNameValuePair(String string, long l) throws IOException {
        this.internalWriteNameValuePair(string, Long.toString(l));
    }

    public void writeNameValuePair(String string, double d) throws IOException {
        this.internalWriteNameValuePair(string, Double.toString(d));
    }

    public void writeNameValuePair(String string, boolean bl) throws IOException {
        this.internalWriteNameValuePair(string, bl ? "true" : "false");
    }

    public void writeNameValuePair(String string, Date date) throws IOException {
        this.internalWriteNameValuePair(string, this.m_format.format(date));
    }

    private void internalWriteNameValuePair(String string, String string2) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        this.writeName(string);
        if (this.m_pretty) {
            this.m_writer.write(32);
        }
        this.m_writer.write(string2);
    }

    private String escapeString(String string) {
        this.m_buffer.setLength(0);
        this.m_buffer.append('\"');
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    this.m_buffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.m_buffer.append("\\\\");
                    continue block10;
                }
                case '/': {
                    this.m_buffer.append("\\/");
                    continue block10;
                }
                case '\b': {
                    this.m_buffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    this.m_buffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    this.m_buffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    this.m_buffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    this.m_buffer.append("\\t");
                    continue block10;
                }
                default: {
                    if (c <= '\u001f') continue block10;
                    this.m_buffer.append(c);
                }
            }
        }
        this.m_buffer.append('\"');
        return this.m_buffer.toString();
    }

    private void writeComma() throws IOException {
        if (this.m_firstNameValuePair.peek().booleanValue()) {
            this.m_firstNameValuePair.pop();
            this.m_firstNameValuePair.push(Boolean.FALSE);
        } else {
            this.m_writer.write(44);
        }
    }

    private void writeNewLineIndent() throws IOException {
        if (this.m_pretty && !this.m_indent.isEmpty()) {
            this.m_writer.write(10);
            this.m_writer.write(this.m_indent);
        }
    }

    private void writeName(String string) throws IOException {
        this.m_writer.write(34);
        this.m_writer.write(string);
        this.m_writer.write(34);
        this.m_writer.write(":");
    }

    private void increaseIndent() {
        this.m_firstNameValuePair.push(Boolean.TRUE);
        if (this.m_pretty) {
            this.m_indent = this.m_indent + INDENT;
        }
    }

    private void decreaseIndent() throws IOException {
        if (this.m_pretty) {
            this.m_writer.write(10);
            this.m_indent = this.m_indent.substring(0, this.m_indent.length() - INDENT.length());
            this.m_writer.write(this.m_indent);
        }
        this.m_firstNameValuePair.pop();
    }
}

