/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class RolloverIcon
implements Icon {
    public static Color COLOR_COLLAPSED_FILL_ROLLOVER = new Color(199, 235, 250);
    public static Color COLOR_COLLAPSED_FILL = Color.WHITE;
    public static Color COLOR_COLLAPSED_ROLLOVER = new Color(28, 196, 247);
    public static Color COLOR_COLLAPSED = new Color(165, 165, 165);
    public static Color COLOR_EXPANDED_FILL_ROLLOVER = new Color(130, 223, 251);
    public static Color COLOR_EXPANDED_FILL = new Color(89, 89, 89);
    public static Color COLOR_EXPANDED_ROLLOVER = new Color(28, 196, 247);
    public static Color COLOR_EXPANDED = new Color(35, 35, 35);
    public static final int ICON_EXPANDED = 0;
    public static final int ICON_COLLAPSED = 1;
    private Icon _normalIcon;
    private Icon _rolloverIcon;
    private IconRolloverSupport _rolloverSupport;

    public RolloverIcon(IconRolloverSupport rolloverSupport, int iconType) {
        this._rolloverSupport = rolloverSupport;
        switch (iconType) {
            case 0: {
                this._normalIcon = new DefaultExpandedIcon(rolloverSupport);
                break;
            }
            case 1: {
                this._normalIcon = new DefaultCollapsedIcon(rolloverSupport);
            }
        }
        this._rolloverIcon = null;
    }

    public RolloverIcon(IconRolloverSupport rolloverSupport, Icon normalIcon) {
        this._rolloverSupport = rolloverSupport;
        this._normalIcon = normalIcon;
        this._rolloverIcon = null;
    }

    public RolloverIcon(IconRolloverSupport rolloverSupport, Icon normalIcon, Icon rolloverIcon) {
        this._rolloverSupport = rolloverSupport;
        this._normalIcon = normalIcon;
        this._rolloverIcon = rolloverIcon;
    }

    public void paintIcon(Component c, Graphics g2, int x, int y) {
        boolean rollover;
        Graphics2D g22 = (Graphics2D)g2;
        Composite orgComposite = g22.getComposite();
        if (this._rolloverSupport.isIconFade()) {
            g22.setComposite(AlphaComposite.getInstance(3, this._rolloverSupport.getIconAlpha()));
        }
        boolean bl = rollover = this._rolloverIcon != null && this._rolloverIcon != this._normalIcon && this._rolloverSupport.isIconRollover(x, y, this.getIconWidth(), this.getIconHeight());
        if (rollover) {
            this._rolloverIcon.paintIcon(c, g22, x, y);
        } else {
            this._normalIcon.paintIcon(c, g22, x, y);
        }
        g22.setComposite(orgComposite);
    }

    public int getIconWidth() {
        return this._normalIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this._normalIcon.getIconHeight();
    }

    public static class DefaultExpandedIcon
    implements Icon {
        private IconRolloverSupport _rolloverSupport;

        public DefaultExpandedIcon(IconRolloverSupport rolloverSupport) {
            this._rolloverSupport = rolloverSupport;
        }

        public void paintIcon(Component c, Graphics g2, int x, int y) {
            Graphics2D g22 = (Graphics2D)g2;
            Color orgColor = g22.getColor();
            Object o = JideSwingUtilities.setupShapeAntialiasing(g2);
            GeneralPath path = new GeneralPath();
            if (c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                path.moveTo(x, y);
                path.lineTo(x, y + 5);
                path.lineTo(x + 5, y + 5);
            } else {
                path.moveTo(x + 5, y);
                path.lineTo(x + 5, y + 5);
                path.lineTo(x, y + 5);
            }
            path.closePath();
            boolean rollover = this._rolloverSupport.isIconRollover(x, y, this.getIconWidth(), this.getIconHeight());
            g22.setColor(rollover ? COLOR_EXPANDED_FILL_ROLLOVER : COLOR_EXPANDED_FILL);
            g22.fill(path);
            g22.setColor(rollover ? COLOR_EXPANDED_ROLLOVER : COLOR_EXPANDED);
            g22.draw(path);
            g22.setColor(orgColor);
            JideSwingUtilities.restoreShapeAntialiasing(g2, o);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }
    }

    public static class DefaultCollapsedIcon
    implements Icon {
        private IconRolloverSupport _rolloverSupport;

        public DefaultCollapsedIcon(IconRolloverSupport rolloverSupport) {
            this._rolloverSupport = rolloverSupport;
        }

        public void paintIcon(Component c, Graphics g2, int x, int y) {
            Graphics2D g22 = (Graphics2D)g2;
            Color orgColor = g22.getColor();
            Object o = JideSwingUtilities.setupShapeAntialiasing(g2);
            GeneralPath path = new GeneralPath();
            if (c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                path.moveTo(x + 4, y);
                path.lineTo(x, y + 4);
                path.lineTo(x + 4, y + 8);
            } else {
                path.moveTo(x, y);
                path.lineTo(x + 4, y + 4);
                path.lineTo(x, y + 8);
            }
            path.closePath();
            boolean rollover = this._rolloverSupport.isIconRollover(x, y, this.getIconWidth(), this.getIconHeight());
            g22.setColor(rollover ? COLOR_COLLAPSED_FILL_ROLLOVER : COLOR_COLLAPSED_FILL);
            g22.fill(path);
            g22.setColor(rollover ? COLOR_COLLAPSED_ROLLOVER : COLOR_COLLAPSED);
            g22.draw(path);
            g22.setColor(orgColor);
            JideSwingUtilities.restoreShapeAntialiasing(g2, o);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    public static interface IconRolloverSupport {
        public boolean isIconRollover(int var1, int var2, int var3, int var4);

        public boolean isIconFade();

        public float getIconAlpha();
    }
}

