/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class MarqueePane
extends JScrollPane {
    private int _scrollDelay = 100;
    private int _stayDelay = 2000;
    private int _scrollAmount = 2;
    private int _scrollDirection = 0;
    private int _stayPosition = -1;
    private Timer _scrollTimer = null;
    private int _scrollTimes;
    private boolean _reachStayPosition = false;
    public static final int SCROLL_DIRECTION_LEFT = 0;
    public static final int SCROLL_DIRECTION_RIGHT = 1;
    public static final int SCROLL_DIRECTION_UP = 2;
    public static final int SCROLL_DIRECTION_DOWN = 3;

    public MarqueePane(Component view) {
        super(view);
        this.startAutoScrolling();
    }

    public MarqueePane() {
        this.startAutoScrolling();
    }

    public void updateUI() {
        super.updateUI();
        this.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.setWheelScrollingEnabled(false);
    }

    public int getScrollDelay() {
        return this._scrollDelay;
    }

    public void setScrollDelay(int scrollDelay) {
        this._scrollDelay = scrollDelay;
    }

    public int getScrollAmount() {
        return this._scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this._scrollAmount = scrollAmount;
    }

    public int getScrollDirection() {
        return this._scrollDirection;
    }

    public void setScrollDirection(int scrollDirection) {
        this._scrollDirection = scrollDirection;
    }

    public int getStayDelay() {
        return this._stayDelay;
    }

    public void setStayDelay(int stayDelay) {
        this._stayDelay = stayDelay;
    }

    public void stopAutoScrolling() {
        if (this._scrollTimer != null) {
            if (this._scrollTimer.isRunning()) {
                this._scrollTimer.stop();
            }
            this._scrollTimer = null;
        }
    }

    public void startAutoScrolling() {
        this.stopAutoScrolling();
        this._scrollTimer = new Timer(this.getScrollDelay(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoundedRangeModel rangeModel = MarqueePane.this.getScrollDirection() == 0 || MarqueePane.this.getScrollDirection() == 1 ? MarqueePane.this.getHorizontalScrollBar().getModel() : MarqueePane.this.getVerticalScrollBar().getModel();
                int value = rangeModel.getValue();
                if (MarqueePane.this.getScrollDirection() == 0 || MarqueePane.this.getScrollDirection() == 2) {
                    if (value + rangeModel.getExtent() == rangeModel.getMaximum()) {
                        rangeModel.setValue(rangeModel.getMinimum());
                        MarqueePane.this._scrollTimes = 0;
                    } else if (value + MarqueePane.this.getScrollAmount() + rangeModel.getExtent() > rangeModel.getMaximum()) {
                        rangeModel.setValue(rangeModel.getMaximum() - rangeModel.getExtent());
                    } else {
                        rangeModel.setValue(value + MarqueePane.this.getScrollAmount());
                        MarqueePane.this._scrollTimes++;
                    }
                    MarqueePane.this._reachStayPosition = rangeModel.getValue() == rangeModel.getMinimum();
                } else {
                    if (value == rangeModel.getMinimum()) {
                        int maximum = rangeModel.getMaximum();
                        int extent = rangeModel.getExtent();
                        rangeModel.setValue(rangeModel.getMaximum() - rangeModel.getExtent());
                        if (maximum != rangeModel.getMaximum() || extent != rangeModel.getExtent()) {
                            rangeModel.setValue(rangeModel.getMaximum() - rangeModel.getExtent());
                        }
                        MarqueePane.this._scrollTimes = 0;
                    } else if (value - MarqueePane.this.getScrollAmount() < rangeModel.getMinimum()) {
                        rangeModel.setValue(rangeModel.getMinimum());
                    } else {
                        rangeModel.setValue(value - MarqueePane.this.getScrollAmount());
                        MarqueePane.this._scrollTimes++;
                    }
                    MarqueePane.this._reachStayPosition = rangeModel.getValue() == rangeModel.getMinimum() || rangeModel.getValue() == rangeModel.getMaximum();
                }
                if (!MarqueePane.this._reachStayPosition && MarqueePane.this.getStayPosition() >= 0 && MarqueePane.this._scrollTimes % MarqueePane.this.getStayPosition() == 0) {
                    MarqueePane.this._reachStayPosition = true;
                }
                if (MarqueePane.this._scrollTimer != null) {
                    MarqueePane.this._scrollTimer.setDelay(MarqueePane.this._reachStayPosition ? MarqueePane.this.getStayDelay() : MarqueePane.this.getScrollDelay());
                }
            }
        });
        this._scrollTimer.start();
    }

    public int getStayPosition() {
        return this._stayPosition;
    }

    public void setStayPosition(int stayPosition) {
        this._stayPosition = stayPosition;
    }
}

