/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateCursor;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSeance;
import org.jetbrains.dekaf.jdbc.JdbcRowFetcher;
import org.jetbrains.dekaf.jdbc.JdbcRowFetchers;
import org.jetbrains.dekaf.jdbc.JdbcRowsCollector;
import org.jetbrains.dekaf.jdbc.JdbcRowsCollectors;
import org.jetbrains.dekaf.jdbc.JdbcUtil;
import org.jetbrains.dekaf.jdbc.JdbcValueGetter;
import org.jetbrains.dekaf.jdbc.JdbcValueGetters;

public class JdbcIntermediateCursor<R>
implements IntegralIntermediateCursor<R> {
    @NotNull
    private final JdbcIntermediateSeance mySeance;
    @NotNull
    private final ResultSet myResultSet;
    @NotNull
    protected final ResultLayout<R> myResultLayout;
    private final boolean myIsDefault;
    private boolean myOpened;
    private boolean myHasRows;
    private int myCollectLimit = Integer.MAX_VALUE;
    private JdbcRowsCollector<R> myRowsCollector;
    private static final JdbcRowFetcher<Void> NOTHING_FETCHER = new JdbcRowFetcher<Void>(){

        @Override
        Void fetchRow(@NotNull ResultSet rset) {
            return null;
        }
    };

    protected JdbcIntermediateCursor(@NotNull JdbcIntermediateSeance seance, @NotNull ResultSet resultSet, @NotNull ResultLayout<R> resultLayout, boolean isDefault, @Nullable Boolean hasRows) {
        this.mySeance = seance;
        this.myResultSet = resultSet;
        this.myResultLayout = resultLayout;
        this.myIsDefault = isDefault;
        try {
            this.myOpened = !JdbcUtil.isClosed(this.myResultSet);
        }
        catch (SQLException sqle) {
            throw seance.mySession.recognizeException(sqle, seance.myStatementText);
        }
        if (this.myOpened) {
            if (hasRows == null) {
                try {
                    this.myHasRows = resultSet.next();
                }
                catch (SQLException sqle) {
                    throw seance.mySession.recognizeException(sqle, seance.myStatementText);
                }
            } else {
                this.myHasRows = hasRows;
            }
        } else {
            this.myHasRows = false;
        }
        if (this.myHasRows) {
            try {
                this.myRowsCollector = JdbcIntermediateCursor.createRowsCollector(resultLayout, this.myResultSet, seance.myStatementText);
            }
            catch (SQLException sqle) {
                throw seance.mySession.recognizeException(sqle, seance.myStatementText);
            }
        }
        if (resultLayout.kind == ResultLayout.Kind.EXISTENCE || resultLayout.kind == ResultLayout.Kind.SINGLE_ROW) {
            this.myCollectLimit = 1;
        } else {
            int seancePackLimit = this.mySeance.myPackLimit;
            if (seancePackLimit > 0) {
                this.myCollectLimit = seancePackLimit;
            }
        }
    }

    private static <R> JdbcRowsCollector<R> createRowsCollector(ResultLayout<R> resultLayout, ResultSet resultSet, String statementText) throws SQLException {
        JdbcRowsCollector collector;
        JdbcRowFetcher fetcher;
        int jdbcType;
        int i;
        JdbcValueGetter[] getters;
        int n;
        RowLayout<?> rowLayout = resultLayout.row;
        switch (rowLayout.kind) {
            case EXISTENCE: {
                n = 0;
                break;
            }
            case ONE_VALUE: {
                n = 1;
                break;
            }
            default: {
                n = rowLayout.components.length;
            }
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int m = metaData.getColumnCount();
        if (n > 0 && rowLayout.kind != RowLayout.Kind.TUPLE && rowLayout.kind != RowLayout.Kind.STRUCT) {
            getters = new JdbcValueGetter[n];
            if (n > m && rowLayout.kind == RowLayout.Kind.ARRAY) {
                throw new DBPreparingException(String.format("Query returns too few columns: %d when expected %d (row type is %s).", m, n, resultLayout.row.rowClass), statementText);
            }
            for (i = 0; i < Math.min(m, n); ++i) {
                jdbcType = metaData.getColumnType(i + 1);
                getters[i] = JdbcValueGetters.of(jdbcType, rowLayout.components[i].clazz);
            }
        } else if (n == 0 && rowLayout.commonComponentClass == Object.class) {
            getters = new JdbcValueGetter[m];
            for (i = 0; i < m; ++i) {
                jdbcType = metaData.getColumnType(i + 1);
                getters[i] = JdbcValueGetters.of(jdbcType, Object.class);
            }
        } else {
            getters = null;
        }
        switch (rowLayout.kind) {
            case EXISTENCE: {
                fetcher = NOTHING_FETCHER;
                break;
            }
            case ONE_VALUE: {
                assert (getters != null && getters.length > 0);
                fetcher = JdbcRowFetchers.createOneValueFetcher(1, getters[0]);
                break;
            }
            case ARRAY: {
                if (rowLayout.commonComponentClass == Integer.TYPE) {
                    fetcher = JdbcRowFetchers.createIntArrayFetcher(1);
                    break;
                }
                if (rowLayout.commonComponentClass == Long.TYPE) {
                    fetcher = JdbcRowFetchers.createLongArrayFetcher(1);
                    break;
                }
                fetcher = JdbcRowFetchers.createArrayFetcher(1, rowLayout.commonComponentClass, getters);
                break;
            }
            case TUPLE: {
                fetcher = JdbcRowFetchers.createTupleFetcher(rowLayout.components);
                break;
            }
            case STRUCT: {
                fetcher = JdbcRowFetchers.createStructFetcher(rowLayout.rowClass, rowLayout.components);
                break;
            }
            default: {
                throw new DBPreparingException(String.format("Unknown how to handle the row layout %s", rowLayout.kind.toString()), statementText);
            }
        }
        switch (resultLayout.kind) {
            case EXISTENCE: {
                collector = JdbcRowsCollectors.createExistenceCollector();
                break;
            }
            case SINGLE_ROW: {
                collector = JdbcRowsCollectors.createSingleRowCollector(fetcher);
                break;
            }
            case ARRAY: {
                collector = JdbcRowsCollectors.createArrayCollector(fetcher);
                break;
            }
            case ARRAY_OF_PRIMITIVES: {
                Class componentClass = resultLayout.row.commonComponentClass;
                if (componentClass == Integer.TYPE) {
                    collector = JdbcRowsCollectors.createArrayOfIntsCollector(resultLayout.initialCapacity);
                    break;
                }
                if (componentClass == Long.TYPE) {
                    collector = JdbcRowsCollectors.createArrayOfLongsCollector(resultLayout.initialCapacity);
                    break;
                }
                throw new DBPreparingException("Primitive array of " + componentClass.getName() + " is not supported", statementText);
            }
            case LIST: {
                collector = JdbcRowsCollectors.createListCollector(fetcher);
                break;
            }
            case MAP: {
                if (resultLayout.sorted) {
                    collector = JdbcRowsCollectors.createHashMapCollector(getters[0], getters[1]);
                    break;
                }
                JdbcValueGetter keyGetter = getters[0];
                collector = JdbcRowsCollectors.createSortedMapCollector(keyGetter, getters[1]);
                break;
            }
            default: {
                throw new DBPreparingException(String.format("Unknown how to handle the result layout %s", resultLayout.kind.toString()), statementText);
            }
        }
        return collector;
    }

    @Override
    public boolean hasRows() {
        return this.myHasRows;
    }

    @Override
    @NotNull
    public String[] getColumnNames() {
        if (!this.myOpened) {
            throw new IllegalStateException("The cursor is not opened or is yet closed.");
        }
        try {
            ResultSetMetaData md = this.myResultSet.getMetaData();
            int n = md.getColumnCount();
            String[] names = new String[n];
            for (int j = 0; j < n; ++j) {
                names[j] = JdbcUtil.getColumnName(md, j + 1);
            }
            return names;
        }
        catch (SQLException sqle) {
            throw this.mySeance.mySession.recognizeException(sqle, this.mySeance.myStatementText);
        }
    }

    @Override
    public synchronized void setCollectLimit(int limit) {
        this.myCollectLimit = limit;
    }

    @Override
    public R fetch() {
        R result;
        if (!this.myHasRows) {
            if (this.myResultLayout.kind == ResultLayout.Kind.EXISTENCE) {
                return (R)Boolean.FALSE;
            }
            return null;
        }
        if (!this.myOpened) {
            throw new IllegalStateException("The cursor is not opened or is yet closed.");
        }
        try {
            result = this.myRowsCollector.collectRows(this.myResultSet, this.myCollectLimit);
        }
        catch (SQLException sqle) {
            this.close();
            throw this.mySeance.mySession.recognizeException(sqle, this.mySeance.myStatementText);
        }
        this.myHasRows = this.myRowsCollector.hasMoreRows;
        if (!this.myHasRows) {
            this.close();
        }
        return result;
    }

    boolean isOpened() {
        return this.myOpened;
    }

    @Override
    public synchronized void close() {
        try {
            JdbcUtil.close(this.myResultSet);
        }
        finally {
            this.myHasRows = false;
            this.myOpened = false;
        }
    }
}

