/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportErrorHandler {
    private final BlockingQueue<List<ErrorRecord>> myQueue;
    private final Thread myThread;
    private final HandleErrorTask myErrorTask;
    private int myErrorsCount;

    ImportErrorHandler(@NotNull Project project, @NotNull ImportInfo info) {
        if (project == null) {
            ImportErrorHandler.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ImportErrorHandler.$$$reportNull$$$0(1);
        }
        this.myQueue = new LinkedTransferQueue<List<ErrorRecord>>();
        this.myErrorTask = this.createErrorTask(project, info);
        this.myThread = this.shouldWriteErrorRecords() ? new Thread((Runnable)this.myErrorTask, "Import error handler") : null;
    }

    void start() {
        if (this.shouldWriteErrorRecords()) {
            this.myThread.start();
        }
    }

    void stop() {
        if (this.shouldWriteErrorRecords()) {
            this.onStop();
        }
    }

    void handle(@NotNull List<ErrorRecord> record) {
        if (record == null) {
            ImportErrorHandler.$$$reportNull$$$0(2);
        }
        this.myErrorsCount += record.size();
        if (!this.shouldWriteErrorRecords() || this.myErrorTask.isStopped() || record.isEmpty()) {
            return;
        }
        this.myQueue.add(record);
    }

    int getErrorsCount() {
        return this.myErrorsCount;
    }

    boolean shouldWriteErrorRecords() {
        return this.myErrorTask != null;
    }

    private void onStop() {
        this.myQueue.add(HandleErrorTask.POISON);
    }

    @Nullable
    private HandleErrorTask createErrorTask(@NotNull Project project, @NotNull ImportInfo info) {
        HandleErrorTask.ErrorTaskInfo errorTaskInfo;
        String errorRecordsWriter;
        if (project == null) {
            ImportErrorHandler.$$$reportNull$$$0(3);
        }
        if (info == null) {
            ImportErrorHandler.$$$reportNull$$$0(4);
        }
        return (errorRecordsWriter = (errorTaskInfo = info.getErrorTaskInfo()).getErrorRecordsPath()) == null ? null : new HandleErrorTask(project, this.myQueue, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dbimport/ImportErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

