/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.DBFacadeProvider;
import com.intellij.database.dialects.generic.introspector.GenericIntrospectorHelper;
import com.intellij.database.dialects.generic.introspector.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.introspection.DBIntrospectionException;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;

public class GenericIntrospector
implements DBIntrospector {
    private String database;
    private final Dbms myDbms;
    private DatabaseConnection myConnection;
    private ProgressIndicator myIndicator;
    private ModelFactory myModelFactory;
    private PairConsumer<String, Throwable> myErrorSink;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private GenericIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;
    @Nullable
    private SourceLoader mySrcLoader;
    private boolean myWithSources;

    public GenericIntrospector(@NotNull Dbms dbms) {
        if (dbms == null) {
            GenericIntrospector.$$$reportNull$$$0(0);
        }
        this.myIndicator = DumbProgressIndicator.INSTANCE;
        this.mySrcLoader = null;
        this.myWithSources = false;
        this.myDbms = dbms;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.myModelFactory = modelFactory;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        BasicModModel theModel = model != null && model.getDbms() == this.myDbms ? model : this.myModelFactory.createModel(this.myDbms);
        this.myHelper = new GenericIntrospectorHelper(theModel, this.myDbms);
    }

    @Override
    @Nullable
    public String getCurrentDatabase() {
        return this.myInfo.databaseName;
    }

    @Override
    public void attachToDB(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            GenericIntrospector.$$$reportNull$$$0(1);
        }
        if (this.myConnection != null) {
            this.detachFromDB();
        }
        this.myConnection = connection2;
        if (this.myDbms != connection2.getDbms()) {
            throw new AssertionError((Object)(this.myDbms.getDisplayName() + " does not match " + connection2.getDbms().getDisplayName() + ")"));
        }
        DBFacade db = null;
        try {
            db = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection2);
            this.myInfo = db.getConnectionInfo();
        }
        finally {
            if (db != null) {
                db.disconnect();
            }
        }
        if (this.myDbms == Dbms.DB2) {
            this.myInfo = new ConnectionInfo(this.myInfo.rdbmsName, this.myInfo.databaseName, this.myInfo.schemaName == null ? null : this.myInfo.schemaName.trim(), this.myInfo.userName, this.myInfo.serverVersion, this.myInfo.driverVersion);
        }
        this.ensureHaveSourceLoader();
    }

    public void ensureHaveSourceLoader() {
        if (this.myWithSources == (this.mySrcLoader != null)) {
            return;
        }
        if (this.myWithSources) {
            for (SourceLoaderProvider provider : (SourceLoaderProvider[])SourceLoaderProvider.EP_NAME.getExtensions()) {
                this.mySrcLoader = provider.create(this.myConnection);
                if (this.mySrcLoader == null) {
                    continue;
                }
                break;
            }
        } else {
            this.mySrcLoader = null;
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements) {
        if (elements == null) {
            GenericIntrospector.$$$reportNull$$$0(2);
        }
        Map<BasicElement, Boolean> map = Collections.emptyMap();
        if (map == null) {
            GenericIntrospector.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    public void detachFromDB() {
        this.myConnection = null;
        this.myInfo = null;
        this.mySrcLoader = null;
    }

    @Override
    public void setOptions(@NotNull DBIntrospectionOptions options) {
        if (options == null) {
            GenericIntrospector.$$$reportNull$$$0(4);
        }
        this.myWithSources = options.getSources() != DBIntrospectionOptions.SourceLoading.NO_SOURCES;
        this.ensureHaveSourceLoader();
    }

    @Override
    @NotNull
    public DBIntrospectionOptions getOptions() {
        DBIntrospectionOptions dBIntrospectionOptions = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        if (dBIntrospectionOptions == null) {
            GenericIntrospector.$$$reportNull$$$0(5);
        }
        return dBIntrospectionOptions;
    }

    @Override
    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myHelper.getModel();
        if (basicModModel == null) {
            GenericIntrospector.$$$reportNull$$$0(6);
        }
        return basicModModel;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator indicator) {
        this.myIndicator = indicator != null ? indicator : DumbProgressIndicator.INSTANCE;
    }

    @Override
    @Nullable
    public ProgressIndicator getProgressIndicator() {
        return this.myIndicator;
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        if (namespaces == null) {
            GenericIntrospector.$$$reportNull$$$0(7);
        }
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (namespaces == null) {
                GenericIntrospector.$$$reportNull$$$0(72);
            }
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            if (namespaces.length == 0) {
                this.introspectDatabaseList(meta);
            }
            this.introspectSchemas(meta, this.schemas(namespaces));
        });
    }

    @Override
    public void introspectNamespaces() {
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            this.introspectDatabaseList(meta);
        });
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        if (databases == null) {
            GenericIntrospector.$$$reportNull$$$0(8);
        }
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (databases == null) {
                GenericIntrospector.$$$reportNull$$$0(71);
            }
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.of((Object[])databases).filter(BasicModDatabase.class));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModSchema> schemas2) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(9);
        }
        if (schemas2 == null) {
            GenericIntrospector.$$$reportNull$$$0(10);
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to retrieve table types", (Object)e);
            this.myTableTypes = null;
        }
        this.myTableKinds = ArrayUtil.isEmpty((Object[])this.myTableTypes) ? null : JBIterable.of((Object[])this.myTableTypes).transform(x -> JdbcTableType.findByName(x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (BasicModSchema schema : schemas2) {
            byCatalog.putValue((Object)this.myHelper.getDatabase(schema), (Object)schema);
        }
        String catalog = null;
        try {
            catalog = meta.getConnection().getJdbcConnection().getCatalog();
            this.introspectSchemasByCatalogs(meta, (MultiMap<BasicModNamespace, BasicModSchema>)byCatalog);
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to get current catalog", (Object)e);
        }
        finally {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection().getJdbcConnection(), (String)catalog);
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> byCatalog) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(11);
        }
        if (byCatalog == null) {
            GenericIntrospector.$$$reportNull$$$0(12);
        }
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(70);
            }
            this.introspectTablesInSchema(meta, (BasicModSchema)s);
            this.introspectRoutinesInSchema(meta, (BasicModSchema)s);
            this.introspectTypesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(69);
            }
            this.introspectColumnsInSchema(meta, (BasicModSchema)s);
            this.introspectPrototypesInSchema(meta, (BasicModSchema)s);
            this.introspectTypeAttributesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            ModNamingFamily<BasicModNamedElement> tables;
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(65);
            }
            if ((tables = GenericIntrospectorLegacyModelUtils.familyOf(s, ObjectKind.TABLE)) != null) {
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(68);
                    }
                    this.introspectTableKeys(meta, (BasicModTableOrView)t, false);
                });
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(67);
                    }
                    this.introspectTableForeignKeys(meta, (BasicModTableOrView)t);
                });
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(66);
                    }
                    this.introspectTableIndices(meta, (BasicModTableOrView)t);
                });
                tables.forEach(t -> GenericIntrospector.cleanupFamily((ModFamily)t.familyOf(ObjectKind.KEY)));
            }
        });
        if (this.mySrcLoader != null) {
            this.getModel().writeSources(() -> {
                if (meta == null) {
                    GenericIntrospector.$$$reportNull$$$0(63);
                }
                if (byCatalog == null) {
                    GenericIntrospector.$$$reportNull$$$0(64);
                }
                GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
                    this.myIndicator.checkCanceled();
                    this.myIndicator.setText("Sources in " + MetaDataUtil.qName(s));
                    this.mySrcLoader.loadSources((Iterable<BasicModSourceAware>)((JBTreeTraverser)DasUtil.dasTraverser().withRoot(s)).filter(BasicModSourceAware.class), this.myConnection);
                });
            });
        }
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<Iterable<BasicModSchema>> process2) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(13);
        }
        if (grouped == null) {
            GenericIntrospector.$$$reportNull$$$0(14);
        }
        if (process2 == null) {
            GenericIntrospector.$$$reportNull$$$0(15);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection().getJdbcConnection(), entry.getKey() == null ? null : ((BasicModNamespace)entry.getKey()).getName());
            process2.accept((Iterable<BasicModSchema>)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<BasicModSchema> process2) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(16);
        }
        if (grouped == null) {
            GenericIntrospector.$$$reportNull$$$0(17);
        }
        if (process2 == null) {
            GenericIntrospector.$$$reportNull$$$0(18);
        }
        GenericIntrospector.forEachCatalog(meta, grouped, ss -> {
            if (process2 == null) {
                GenericIntrospector.$$$reportNull$$$0(62);
            }
            ss.forEach(process2);
        });
    }

    private void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(19);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(20);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<? extends BasicModTableOrView>> families = this.getTableFamilies(schema);
        families.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.asSchema(schema), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createTable(schema, table);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve tables in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        families.forEach(GenericIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<ModFamily<? extends BasicModTableOrView>> getTableFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(21);
        }
        JBIterable kinds = JBIterable.from(ModelConsts.TABLE_OR_VIEW_KINDS).append((Object)ObjectKind.SEQUENCE).append((Object)ObjectKind.SYNONYM);
        if (this.myTableKinds != null) {
            kinds = kinds.filter(this.myTableKinds::contains);
        }
        JBIterable jBIterable = kinds.transform(k -> {
            if (schema == null) {
                GenericIntrospector.$$$reportNull$$$0(61);
            }
            return GenericIntrospectorLegacyModelUtils.familyOf(schema, k);
        }).filter(Conditions.notNull());
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    private void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table, boolean cleanup) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(23);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(24);
        }
        Family keys = table.familyOf(ObjectKind.KEY);
        if (table.getKind() != ObjectKind.TABLE || keys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Keys in " + MetaDataUtil.qName(table));
        keys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        if (cleanup) {
            GenericIntrospector.cleanupFamily((ModFamily)keys);
        }
    }

    private void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(25);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(26);
        }
        Family fKeys = table.familyOf(ObjectKind.FOREIGN_KEY);
        if (table.getKind() != ObjectKind.TABLE || fKeys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Foreign keys in " + MetaDataUtil.qName(table));
        fKeys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)fKeys);
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(27);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(28);
        }
        Family indices = table.familyOf(ObjectKind.INDEX);
        if (table.getKind() != ObjectKind.TABLE || indices == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Indices in " + MetaDataUtil.qName(table));
        indices.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)indices);
    }

    private void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(29);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(30);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table columns in " + MetaDataUtil.qName(schema));
        JBIterable tables = this.getTableFamilies(schema).flatten(s -> s).filter(BasicModTableOrView.class);
        HashMap name2Table = ContainerUtil.newHashMap();
        for (Object table : tables) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)table, ObjectKind.COLUMN));
            name2Table.put(table.getName(), table);
        }
        try {
            Object table;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.asSchema(schema), null, name2Table.keySet());
            table = null;
            try {
                for (DatabaseMetaDataWrapper.Table table2 : JBIterable.once(columnIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createColumns((BasicModTableOrView)name2Table.get(table2.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                table = throwable;
                throw throwable;
            }
            finally {
                if (columnIt != null) {
                    if (table != null) {
                        try {
                            columnIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)table).addSuppressed(throwable);
                        }
                    } else {
                        columnIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object table : tables) {
            GenericIntrospector.cleanupFamily((ModFamily)table.familyOf(ObjectKind.COLUMN));
        }
    }

    private void introspectTypeAttributesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(31);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(32);
        }
        this.myIndicator.checkCanceled();
        ModNamingFamily<Object> types = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.OBJECT_TYPE);
        if (types == null || types.isEmpty()) {
            return;
        }
        this.myIndicator.setText("Type attributes in " + MetaDataUtil.qName(schema));
        HashMap name2Type = ContainerUtil.newHashMap();
        for (Object type : types) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)type, ObjectKind.OBJECT_ATTRIBUTE));
            name2Type.put(type.getName(), type);
        }
        try {
            Object type;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt = meta.userDefinedTypeAttributes(this.asSchema(schema), null, name2Type.keySet());
            type = null;
            try {
                for (DatabaseMetaDataWrapper.UserDefinedType type2 : JBIterable.once(attrIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createUserDefinedTypeAttributes((BasicModElement)name2Type.get(type2.name), (Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>)attrIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                type = throwable;
                throw throwable;
            }
            finally {
                if (attrIt != null) {
                    if (type != null) {
                        try {
                            attrIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)type).addSuppressed(throwable);
                        }
                    } else {
                        attrIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object type : types) {
            GenericIntrospector.cleanupFamily((ModFamily)type.familyOf(ObjectKind.OBJECT_ATTRIBUTE));
        }
    }

    @NotNull
    private DatabaseMetaDataWrapper.Schema asSchema(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(33);
        }
        DatabaseMetaDataWrapper.Schema s = this.myHelper.asSchema(schema);
        if (s.database == null) {
            s.database = this.database;
        }
        DatabaseMetaDataWrapper.Schema schema2 = s;
        if (schema2 == null) {
            GenericIntrospector.$$$reportNull$$$0(34);
        }
        return schema2;
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(35);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(36);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Prototypes in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        JBIterable routines = routineFamilies.flatten(r -> r).filter(BasicModRoutine.class);
        GenericIntrospectorHelper.RoutineMap map = this.myHelper.createRoutineMap();
        for (Object routine : routines) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)routine, ObjectKind.ARGUMENT));
            map.put((BasicModRoutine)routine);
        }
        try {
            Object routine;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.asSchema(schema), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map::guessType));
            routine = null;
            try {
                for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(argumentIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createArguments(map.get(routine2), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                routine = throwable;
                throw throwable;
            }
            finally {
                if (argumentIt != null) {
                    if (routine != null) {
                        try {
                            argumentIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)routine).addSuppressed(throwable);
                        }
                    } else {
                        argumentIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object routine : routines) {
            GenericIntrospector.cleanupFamily(routine.familyOf(ObjectKind.ARGUMENT));
        }
        routineFamilies.forEach(ModFamily::sort);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(37);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(38);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Routine list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        routineFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.asSchema(schema), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine : JBIterable.once(routineIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createRoutine(schema, routine);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve routines in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        routineFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectAdditionalTypes(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(39);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(40);
        }
        ObjectKind target = null;
        String scName = schema.getName();
        if (this.myHelper.getDbms().isSybase() && "dbo".equalsIgnoreCase(scName)) {
            target = ObjectKind.ALIAS_TYPE;
        }
        if (target != null) {
            try (ClosableIt<? extends DatabaseMetaDataWrapper.Type> typesIt = meta.types();){
                for (DatabaseMetaDataWrapper.Type type : JBIterable.once(typesIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createType(schema, type, target);
                }
            }
            catch (SQLException e) {
                this.myErrorSink.consume((Object)("Failed to retrieve types in " + MetaDataUtil.qName(schema)), (Object)e);
            }
        }
    }

    private void introspectTypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(41);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(42);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Types list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> userDefinedTypeFamilies = this.getUserDefinedTypeFamilies(schema);
        userDefinedTypeFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.UserDefinedType> userDefinedTypesIt = meta.userDefinedTypes(this.asSchema(schema), null);){
            for (DatabaseMetaDataWrapper.UserDefinedType userDefinedType : JBIterable.once(userDefinedTypesIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createUserDefinedType(schema, userDefinedType);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve user types in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        this.introspectAdditionalTypes(meta, schema);
        userDefinedTypeFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectDatabaseList(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(43);
        }
        if (this.getModel().getRoot().familyOf(ObjectKind.DATABASE) != null) {
            this.introspectDatabaseListImpl(meta);
        } else if (this.getModel().getRoot().familyOf(ObjectKind.SCHEMA) != null) {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
        } else {
            throw new GenericIntrospectionException("Model does not contain database/schema namespace", null);
        }
    }

    private void introspectDatabaseListImpl(@NotNull DatabaseMetaDataWrapper meta) {
        boolean haveDb;
        ModNamingFamily databases;
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(44);
        }
        if ((databases = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.DATABASE)) == null) {
            return;
        }
        databases.markChildrenAsSyncPending();
        try (ClosableIt<String> dbIt = meta.databases();){
            haveDb = this.fillDatabases((Iterator<String>)((Object)dbIt));
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve databases", e);
        }
        if (haveDb) {
            GenericIntrospector.cleanupFamily(databases);
            this.updateDatabaseFlags(databases);
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.from(databases).filter(BasicModDatabase.class).filter(db -> db.isCurrent()));
        } else {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
            this.updateDatabaseFlags(databases);
        }
    }

    private void introspectSchemaList(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModDatabase> databases) {
        Throwable throwable;
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(45);
        }
        if (databases == null) {
            GenericIntrospector.$$$reportNull$$$0(46);
        }
        for (BasicModDatabase db : databases) {
            db.getSchemas().markChildrenAsSyncPending();
        }
        JBIterable dbs2 = databases.transform(DasUtil.TO_NAME);
        if (databases.isEmpty() && this.myHelper.isSchemaDbMode()) {
            try {
                throwable = null;
                try (ClosableIt<String> dbIt = meta.databases();){
                    dbs2 = JBIterable.from((Iterable)ContainerUtil.collect(dbIt));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve schemas", e);
            }
        }
        try {
            throwable = null;
            try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas((JBIterable<String>)dbs2);){
                this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve schemas", e);
        }
        for (BasicModDatabase db : databases) {
            GenericIntrospector.cleanupFamily((ModFamily)((Object)db.getSchemas()));
        }
    }

    @Nullable
    private <T extends BasicNamespace> T getCurrentOrSole(@NotNull Iterable<? extends T> namespaces) {
        JBIterable nsp;
        BasicNamespace current;
        if (namespaces == null) {
            GenericIntrospector.$$$reportNull$$$0(47);
        }
        if ((current = (BasicNamespace)(nsp = JBIterable.from(namespaces)).filter(this::isCurrent).first()) != null) {
            return (T)current;
        }
        if (nsp.size() == 1) {
            return (T)((BasicNamespace)nsp.first());
        }
        return null;
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        LinkedHashSet schemaFamilies = ContainerUtil.newLinkedHashSet();
        ModNamingFamily root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.SCHEMA);
        if (root2 != null) {
            root2.markChildrenAsSyncPending();
            schemaFamilies.add(root2);
        }
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            if (root2 == null) {
                ModNamingFamily schemas3;
                BasicModDatabase database = this.myHelper.createDatabase(schema.database);
                ModNamingFamily modNamingFamily = schemas3 = database == null ? null : GenericIntrospectorLegacyModelUtils.familyOf(database, ObjectKind.SCHEMA);
                if (schemas3 != null && schemaFamilies.add(schemas3)) {
                    schemas3.markChildrenAsSyncPending();
                }
            } else if (this.database == null) {
                this.database = schema.database;
            }
            this.myHelper.createSchema(schema);
        }
        schemaFamilies.forEach(schemas2 -> {
            GenericIntrospector.cleanupFamily(schemas2);
            this.updateSchemaFlags((ModNamingFamily<? extends BasicModSchema>)schemas2);
        });
    }

    private void updateSchemaFlags(ModNamingFamily<? extends BasicModSchema> schemas2) {
        boolean hasVisibleSc = !schemas2.jbi().filter(BasicMateNamespace::isVisible).isEmpty();
        BasicModSchema curSc = this.getCurrentOrSole(schemas2);
        if (curSc != null) {
            schemas2.forEach(s -> s.setCurrent(false));
            if (!hasVisibleSc) {
                curSc.setVisible(true);
            }
            curSc.setCurrent(true);
        } else if (ApplicationManager.getApplication().isUnitTestMode() && schemas2.stream().noneMatch(BasicMateNamespace::isVisible)) {
            schemas2.forEach(sc -> sc.setVisible(true));
        }
    }

    private boolean fillDatabases(Iterator<String> dbIt) {
        boolean empty = true;
        for (String db : JBIterable.once(dbIt)) {
            empty = false;
            this.myHelper.createDatabase(db);
        }
        return !empty;
    }

    private void updateDatabaseFlags(ModNamingFamily<?> root2) {
        JBIterable databases = JBIterable.from(root2).filter(BasicModMateDatabase.class);
        boolean hasVisibleDb = !databases.filter(BasicNamespace::isVisible).isEmpty();
        BasicModMateDatabase curDb = (BasicModMateDatabase)this.getCurrentOrSole((Iterable)databases);
        for (BasicModMateDatabase database : databases) {
            database.setCurrent(false);
        }
        if (curDb != null) {
            if (!hasVisibleDb) {
                curDb.setVisible(true);
            }
            curDb.setCurrent(true);
        }
    }

    private boolean isCurrent(@Nullable BasicNamespace nsp) {
        if (nsp instanceof BasicDatabase) {
            return this.isCurrent((BasicDatabase)nsp);
        }
        if (nsp instanceof BasicSchema) {
            return this.isCurrent((BasicSchema)nsp);
        }
        return false;
    }

    private boolean isCurrent(@Nullable BasicDatabase db) {
        if (db == null || this.myInfo == null) {
            return false;
        }
        return db.getName().equals(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable BasicSchema sc) {
        if (sc == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc.getName().equals(this.myInfo.databaseName) : sc.getName().equals(this.myInfo.schemaName) || this.myInfo.schemaName == null && sc.getName().equals(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta() {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        if (this.myConnection == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            DatabaseMetaData metaData = this.myConnection.getMetaData();
            if (metaData == null) {
                throw new GenericIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null);
            }
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(this.myConnection, metaData).withErrorSink(this.myErrorSink);
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e);
        }
        if (databaseMetaDataWrapper == null) {
            GenericIntrospector.$$$reportNull$$$0(48);
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    public JBIterable<BasicModSchema> schemas(BasicNamespace ... namespaces) {
        JBTreeTraverser traverser2 = this.getModel().traverser();
        if (namespaces != null && namespaces.length != 0) {
            traverser2 = (JBTreeTraverser)traverser2.withRoots((Iterable)JBIterable.of((Object[])namespaces));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)traverser2.expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(BasicModSchema.class);
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(49);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ModFamily<?>> getRoutineFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(50);
        }
        JBIterable routineFamilies = JBIterable.of((Object)schema.familyOf(ObjectKind.ROUTINE));
        ModFamily packages = schema.familyOf(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of((Object)packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(p2 -> p2).transform(f -> f.familyOf(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(51);
        }
        return jBIterable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public JBIterable<ModFamily<?>> getUserDefinedTypeFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(52);
        }
        @NotNull JBIterable transform = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.ALIAS_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE}).transform(schema::familyOf);
        JBIterable jBIterable = transform.filter(Conditions.notNull());
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(53);
        }
        return jBIterable;
    }

    private static void markChildrenAsSyncPending(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.markChildrenAsSyncPending();
    }

    private static void cleanupFamily(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.removeSyncPendingChildren();
        f.sort();
    }

    @Override
    public void introspectSessionState() {
        this.getModel().modify(BasicModRoot.class, root2 -> root2.setServerVersion(this.myConnection.getVersion()));
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            GenericIntrospector.$$$reportNull$$$0(54);
        }
        if (objectKind == null) {
            GenericIntrospector.$$$reportNull$$$0(55);
        }
        if (objectNames == null) {
            GenericIntrospector.$$$reportNull$$$0(56);
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements) {
        if (elements == null) {
            GenericIntrospector.$$$reportNull$$$0(57);
        }
        Map<BasicElement, String[]> map = Collections.emptyMap();
        if (map == null) {
            GenericIntrospector.$$$reportNull$$$0(58);
        }
        return map;
    }

    @Override
    public void introspectServerObjects() {
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        PairConsumer<String, Throwable> pairConsumer = this.myErrorSink;
        if (pairConsumer == null) {
            GenericIntrospector.$$$reportNull$$$0(59);
        }
        return pairConsumer;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> consumer2) {
        if (consumer2 == null) {
            GenericIntrospector.$$$reportNull$$$0(60);
        }
        this.myErrorSink = consumer2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 34: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 34: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 34: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/GenericIntrospector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: 
            case 47: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 8: 
            case 46: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 12: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byCatalog";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 15: 
            case 18: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 20: 
            case 21: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 52: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectKind";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectNames";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/GenericIntrospector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveInvalid";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFamilies";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "asSchema";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createMeta";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineFamilies";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedTypeFamilies";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "introspectNativeDefinitions";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attachToDB";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "retrieveInvalid";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 34: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 59: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "introspectAuto";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseSchemas";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemas";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasByCatalogs";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forEachCatalog";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "forEachSchemaInCatalog";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "introspectTablesInSchema";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTableFamilies";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableKeys";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableForeignKeys";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableIndices";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "introspectColumnsInSchema";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypeAttributesInSchema";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "asSchema";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "introspectPrototypesInSchema";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "introspectRoutinesInSchema";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "introspectAdditionalTypes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypesInSchema";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseListImpl";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemaList";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOrSole";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineFamilies";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedTypeFamilies";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "introspectFragment";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "introspectNativeDefinitions";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setErrorSink";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTableFamilies$14";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachSchemaInCatalog$13";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$12";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$10";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$8";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$5";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$4";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectDatabaseSchemas$2";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectAuto$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 34: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionException {
        GenericIntrospectionException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }

    public static interface SourceLoader {
        public void loadSources(@NotNull Iterable<BasicModSourceAware> var1, @NotNull DatabaseConnection var2);
    }

    public static interface SourceLoaderProvider {
        public static final ExtensionPointName<SourceLoaderProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.genericSourceLoaderProvider");

        @Nullable
        public SourceLoader create(@NotNull DatabaseConnection var1);
    }

    public static class Factory
    implements DBIntrospector.Factory {
        private static final Map<Dbms, PerObjectVersion> VERSIONS = FactoryMap.create(key2 -> PerObjectVersion.DEFAULT.INSTANCE);
        private final Dbms myDbms;

        public Factory(@NotNull Dbms dbms) {
            if (dbms == null) {
                Factory.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            if (dbms == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (modelFactory == null) {
                Factory.$$$reportNull$$$0(3);
            }
            GenericIntrospector introspector = new GenericIntrospector(dbms);
            introspector.setModelFactory(modelFactory);
            GenericIntrospector genericIntrospector = introspector;
            if (genericIntrospector == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return genericIntrospector;
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            if (version == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            if (kind == null) {
                Factory.$$$reportNull$$$0(6);
            }
            return VERSIONS.get(this.myDbms).get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@NotNull BasicElement e) {
            if (e == null) {
                Factory.$$$reportNull$$$0(7);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/GenericIntrospector$Factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/GenericIntrospector$Factory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIntrospector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createIntrospector";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getVersion";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isOutdatedCheckSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

