/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.intellij.database.dialects.postgresbase.PgBaseObjectBuilder;
import com.intellij.database.dialects.redshift.RedshiftObjectBuilder;
import com.intellij.database.dialects.redshift.model.RsModExternalSchema;
import com.intellij.database.dialects.redshift.model.RsModExternalTable;
import com.intellij.database.dialects.redshift.model.RsModExternalTableColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.redshift.RsTypes;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlCreateSchemaStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.stubs.SqlColumnDefinitionElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/redshift/RedshiftObjectBuilder;", "Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildExternalSchema", "Lcom/intellij/database/dialects/redshift/model/RsModExternalSchema;", "buildExternalTable", "Lcom/intellij/database/dialects/redshift/model/RsModExternalTable;", "findOptions", "", "", "element", "Lcom/intellij/psi/PsiElement;", "findTerminator", "setColumnsOrder", "table", "by", "intellij.database.dialects"})
public final class RedshiftObjectBuilder
extends PgBaseObjectBuilder {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof RsModExternalSchema) {
            this.buildExternalSchema((RsModExternalSchema)obj2, source);
        } else if (basicModElement instanceof RsModExternalTable) {
            this.buildExternalTable((RsModExternalTable)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    private final void buildExternalTable(RsModExternalTable obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            RedshiftObjectBuilder this_$iv;
            String serializationLib = null;
            String inputFormat = null;
            String outputFormat = null;
            String location = null;
            RsExternalTableStorageType storageType = RsExternalTableStorageType.UNKNOWN;
            List<String> serdeProperties = new ArrayList();
            List<String> properties = CollectionsKt.emptyList();
            RedshiftObjectBuilder redshiftObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String terminator;
                List<String> $receiver;
                List<String> list;
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDE)) {
                    serializationLib = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_FIELDS)) {
                    List<String> list2 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list2)) {
                        list2 = null;
                    }
                    if (list2 != null) {
                        $receiver = list = list2;
                        terminator = this.findTerminator(it);
                        if (terminator != null) {
                            $receiver.add("'field.delim'='" + terminator + '\'');
                            $receiver.add("'serialization.format'='" + terminator + '\'');
                        }
                        serializationLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LINES)) {
                    List<String> list3 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list3)) {
                        list3 = null;
                    }
                    if (list3 != null) {
                        $receiver = list = list3;
                        terminator = this.findTerminator(it);
                        if (terminator == null) continue;
                        $receiver.add("'line.delim'='" + terminator + '\'');
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LOCATION)) {
                    location = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_INPUTFORMAT)) {
                    inputFormat = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_OUTPUTFORMAT)) {
                    outputFormat = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARQUET)) {
                    storageType = RsExternalTableStorageType.PARQUET;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_RCFILE)) {
                    storageType = RsExternalTableStorageType.RCFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SEQUENCEFILE)) {
                    storageType = RsExternalTableStorageType.SEQUENCEFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TEXTFILE)) {
                    storageType = RsExternalTableStorageType.TEXTFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_ORC)) {
                    storageType = RsExternalTableStorageType.ORC;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_AVRO)) {
                    storageType = RsExternalTableStorageType.AVRO;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDEPROPERTIES)) {
                    serdeProperties = this.findOptions(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TABLE)) {
                    IElementType iElementType2 = RsTypes.RS_PROPERTIES;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_PROPERTIES");
                    PsiElement props = this.findSibling(it, iElementType2);
                    if (props == null) continue;
                    properties = this.findOptions(props);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARTITIONED)) continue;
                IElementType iElementType3 = RsTypes.RS_BY;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"RsTypes.RS_BY");
                PsiElement by = this.findSibling(it, iElementType3);
                if (by == null) continue;
                this.setColumnsOrder(obj2, by);
            }
            obj2.setSerializationLib(serializationLib);
            obj2.setInputFormat(inputFormat);
            obj2.setOutputFormat(outputFormat);
            obj2.setLocation(location);
            obj2.setStorageType(storageType);
            obj2.setSerdeProperties(serdeProperties);
            obj2.setProps(properties);
        }
    }

    private final void buildExternalSchema(RsModExternalSchema obj2, DasObject source) {
        if (source instanceof SqlCreateSchemaStatementImpl) {
            PsiElement first$iv$iv;
            RedshiftObjectBuilder this_$iv;
            String database = null;
            String iamRole = null;
            String uri = null;
            String port = null;
            String region = null;
            int schemaKind = 1;
            RedshiftObjectBuilder redshiftObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_DATABASE)) {
                    database = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_IAM_ROLE)) {
                    iamRole = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_URI)) {
                    uri = this.findString(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PORT)) {
                    Float f = this.findNumberInSiblings(it);
                    port = f != null ? String.valueOf((int)f.floatValue()) : null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_REGION)) {
                    region = this.findString(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_HIVE)) continue;
                IElementType iElementType2 = RsTypes.RS_METASTORE;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_METASTORE");
                if (this.findSibling(it, iElementType2) == null) continue;
                schemaKind = 2;
            }
            obj2.setDatabaseName(database);
            obj2.setIamRole(iamRole);
            obj2.setUri(uri);
            obj2.setPort(port);
            obj2.setRegion(region);
            obj2.setSchemaKind(schemaKind);
            obj2.setVisible(true);
        }
    }

    private final String findTerminator(PsiElement element2) {
        IElementType iElementType = RsTypes.RS_TERMINATED;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"RsTypes.RS_TERMINATED");
        PsiElement psiElement = this.findSibling(element2, iElementType);
        if (psiElement == null) {
            return null;
        }
        PsiElement terminated = psiElement;
        IElementType iElementType2 = RsTypes.RS_BY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_BY");
        PsiElement psiElement2 = this.findSibling(terminated, iElementType2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement by = psiElement2;
        return this.findString(by);
    }

    private final void setColumnsOrder(RsModExternalTable table, PsiElement by) {
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
        PsiElement psiElement = this.findSibling(by, (IElementType)sqlColumnDefinitionElementType);
        if (!(psiElement instanceof SqlColumnDefinition)) {
            psiElement = null;
        }
        SqlColumnDefinition def = (SqlColumnDefinition)psiElement;
        int order = 1;
        while (def != null) {
            RsModExternalTableColumn column2;
            String name;
            SqlNameElement sqlNameElement = def.getNameElement();
            String string = name = sqlNameElement != null ? sqlNameElement.getName() : null;
            if (name != null && (column2 = (RsModExternalTableColumn)table.getColumns().find((Predicate)new Predicate<RsModExternalTableColumn>(name){
                final /* synthetic */ String $name;

                public final boolean test(RsModExternalTableColumn it) {
                    RsModExternalTableColumn rsModExternalTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)rsModExternalTableColumn.getName(), (Object)this.$name);
                }
                {
                    this.$name = string;
                }
            })) != null) {
                column2.setPartitionKeyOrder(order++);
            }
            PsiElement psiElement2 = def.getNextSibling();
            SqlColumnDefinitionElementType sqlColumnDefinitionElementType2 = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType2), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
            PsiElement psiElement3 = this.findSibling(psiElement2, (IElementType)sqlColumnDefinitionElementType2);
            if (!(psiElement3 instanceof SqlColumnDefinition)) {
                psiElement3 = null;
            }
            def = (SqlColumnDefinition)psiElement3;
        }
    }

    private final List<String> findOptions(PsiElement element2) {
        return this.findOptions(element2, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ RedshiftObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_STRING_LITERAL");
                return RedshiftObjectBuilder.access$findSibling(this.this$0, current, (IElementType)sqlCompositeElementType);
            }
            {
                this.this$0 = redshiftObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(RedshiftObjectBuilder $this, @Nullable PsiElement element2, @NotNull IElementType type) {
        return $this.findSibling(element2, type);
    }
}

