/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetPattern;
import com.intellij.sql.formatter.model.EndIncElementPattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.SeparatorPattern;
import com.intellij.sql.formatter.model.SingleElementPattern;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock$WordAndListSection$WhenMappings;
import com.intellij.sql.formatter.model.SqlQueryBlock$sam$com_intellij_openapi_util_Condition$0;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 -2\u00020\u0001:\u0018,-./0123456789:;<=>?@ABCB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0002J\u0016\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001cH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020\u0010H\u0002J\b\u0010&\u001a\u00020\u0010H\u0014J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "commonFirstWordRightAlign", "Lcom/intellij/formatting/Alignment;", "getCommonFirstWordRightAlign", "()Lcom/intellij/formatting/Alignment;", "setCommonFirstWordRightAlign", "(Lcom/intellij/formatting/Alignment;)V", "isAllowedToCollapse", "", "isInsert", "isSubQuery", "isUnion", "checkIsSubquery", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "detectWhetherIntoSeparated", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugName", "", "getNewLineIdent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "handleWhetherIsInsert", "handleWhetherIsSubquery", "tuneNestedNodesAfterAnalysis", "userWrapSetting", "", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "CTE", "Companion", "DeleteSection", "FromSection", "GroupOrderSection", "InsertSection", "JoinPhrase", "LimitSection", "PrimaryTableElement", "QuerySection", "SecondaryTableElement", "SelectElement", "SelectElementEssence", "SelectSection", "SetAssignment", "SetSection", "SqlCortegeLikeParenthesizedListBlock", "UnionSection", "UnknownSection", "UpdateSection", "ValuesSection", "WhereSection", "WithSection", "WordAndListSection", "intellij.database.sql.impl"})
public final class SqlQueryBlock
extends SqlNodeBlock {
    private boolean isSubQuery;
    private boolean isInsert;
    private boolean isUnion;
    private boolean isAllowedToCollapse;
    @Nullable
    private Alignment commonFirstWordRightAlign;
    private static final Set<IElementType> nodesToFlatten;
    private static final Set<IElementType> sectionMakers;
    private static final Set<IElementType> tableJoinWords;
    private static final Set<IElementType> unionGluedWords;
    private static final Map<IElementType, FlowPattern> commonPatterns;
    private static final Map<IElementType, FlowPattern> insertIntoTogetherPatterns;
    private static final Map<IElementType, FlowPattern> insertIntoSeparatedPatterns;
    public static final Companion Companion;

    @Nullable
    public final Alignment getCommonFirstWordRightAlign() {
        return this.commonFirstWordRightAlign;
    }

    public final void setCommonFirstWordRightAlign(@Nullable Alignment alignment) {
        this.commonFirstWordRightAlign = alignment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType type = iElementType;
        if (nodesToFlatten.contains(type)) return true;
        if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION)) return false;
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_COMMA");
        if (!SqlUtilFun.hasChildNode(node, (IElementType)sqlTokenType)) return false;
        return true;
    }

    @Override
    @Nullable
    protected Map<IElementType, FlowPattern> flowPatterns() {
        Map<IElementType, FlowPattern> map;
        this.handleWhetherIsSubquery();
        this.handleWhetherIsInsert();
        boolean bl = this.isInsert;
        if (!bl) {
            map = commonPatterns;
        } else if (bl) {
            boolean separate;
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    boolean bl2 = true;
                    break;
                }
                case 2: {
                    boolean bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = separate = this.detectWhetherIntoSeparated();
                }
            }
            map = separate ? insertIntoSeparatedPatterns : insertIntoTogetherPatterns;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map;
    }

    private final void handleWhetherIsSubquery() {
        boolean bl;
        this.isSubQuery = this.checkIsSubquery();
        switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 0: {
                if (!this.contains('\n')) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 2: {
                bl = this.isSubQuery;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.isAllowedToCollapse = bl;
    }

    private final void handleWhetherIsInsert() {
        IElementType iElementType = SqlUtilFun.firstLeaf(this.getBlockNode()).getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"blockNode.firstLeaf().elementType");
        IElementType firstType = iElementType;
        this.isInsert = Intrinsics.areEqual((Object)firstType, (Object)SqlCommonKeywords.SQL_INSERT) || Intrinsics.areEqual((Object)firstType, (Object)SqlCommonKeywords.SQL_REPLACE);
    }

    private final boolean detectWhetherIntoSeparated() {
        Object v3;
        ASTNode insertNode;
        block4: {
            Object v1;
            JBIterable<ASTNode> children2;
            block3: {
                children2 = SqlUtilFun.children(this.getBlockNode());
                Iterable $receiver$iv = (Iterable)children2;
                for (Object element$iv : $receiver$iv) {
                    ASTNode it;
                    ASTNode aSTNode = it = (ASTNode)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                    if (!(aSTNode.getElementType() == SqlCommonKeywords.SQL_INSERT)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            insertNode = v1;
            Iterable $receiver$iv = (Iterable)children2;
            for (Object element$iv : $receiver$iv) {
                ASTNode it;
                ASTNode aSTNode = it = (ASTNode)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                if (!(aSTNode.getElementType() == SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION || it.getElementType() == SqlCommonKeywords.SQL_INTO)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        ASTNode intoNode = v3;
        if (insertNode == null || intoNode == null) {
            return false;
        }
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = insertNode.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"insertNode.textRange");
        return sqlFormattingContext.textContains(textRange.getEndOffset(), intoNode.getStartOffset(), '\n');
    }

    private final boolean checkIsSubquery() {
        for (SqlBlock p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (p2 instanceof SqlQueryBlock) {
                return true;
            }
            if (!(p2 instanceof SqlCodeFlowBlock) || p2 instanceof SqlBatchBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public int userWrapSetting() {
        int n;
        switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                if (this.isSubQuery) {
                    n = 2;
                    break;
                }
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        super.tuneNestedNodesAfterAnalysis();
        if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0) {
            for (SqlBlock b2 : this.getNestedBlocks()) {
                boolean toExpand;
                if (b2 instanceof UnionSection) {
                    this.isUnion = true;
                }
                if (!(b2 instanceof WordAndListSection) || !(toExpand = ((WordAndListSection)b2).userWrapSetting() == 1 && (((WordAndListSection)b2).getCountOfElements() > ((WordAndListSection)b2).userNumberOfElementsToKeepCollapsed() || ((WordAndListSection)b2).userElementsLineSetting() == 101)) || b2.getShape().compareTo((Enum)this.getShape()) >= 0) continue;
                b2.setShape(this.getShape());
            }
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
        for (SqlBlock b2 : this.nestedBlocksIter().skip(1)) {
            b2.setMyWrap(w);
        }
        switch (this.getContext().getSql().QUERY_SECTION_1ST_WORD_ALIGN) {
            case 2: {
                Indent i2 = Indent.getNormalIndent((boolean)true);
                for (SqlBlock b3 : this.getNestedBlocks()) {
                    if (!(b3 instanceof QuerySection) || !((QuerySection)b3).whetherSectionToIndent()) continue;
                    b3.setMyIndent(i2);
                }
                break;
            }
            case 8: {
                QuerySection it;
                int thePrefixLength = 6;
                Iterable $receiver$iv = this.getNestedBlocks();
                Iterator $receiver$iv$iv = $receiver$iv;
                JBIterable jBIterable = JBIterable.from((Iterable)((Object)$receiver$iv$iv));
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable2 = jBIterable.filter(QuerySection.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                $receiver$iv = (Iterable)jBIterable2;
                for (Object element$iv : $receiver$iv) {
                    it = (QuerySection)element$iv;
                    if (it.getFirstWordLength$intellij_database_sql_impl() <= thePrefixLength) continue;
                    thePrefixLength = it.getFirstWordLength$intellij_database_sql_impl();
                }
                $receiver$iv = this.getNestedBlocks();
                $receiver$iv$iv = $receiver$iv;
                JBIterable jBIterable3 = JBIterable.from((Iterable)((Object)$receiver$iv$iv));
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"JBIterable.from(this)");
                JBIterable jBIterable4 = jBIterable3.filter(QuerySection.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"this.jbi.filter(B::class.java)");
                $receiver$iv = (Iterable)jBIterable4;
                for (Object element$iv : $receiver$iv) {
                    it = (QuerySection)element$iv;
                    if (it.getFirstWordLength$intellij_database_sql_impl() >= thePrefixLength) continue;
                    it.setMyIndent(Indent.getSpaceIndent((int)(thePrefixLength - it.getFirstWordLength$intellij_database_sql_impl())));
                }
                break;
            }
        }
        switch (this.getContext().getSql().QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: {
                Alignment a = SqlFormattingModelFunKt.makeLeftAlignment();
                for (SqlBlock b3 : this.getNestedBlocks()) {
                    b3.setMyAlign(a);
                }
                break;
            }
            case 2: {
                Alignment a1 = SqlFormattingModelFunKt.makeLeftAlignment();
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignment();
                for (SqlBlock b4 : this.getNestedBlocks()) {
                    b4.setMyAlign(b4 instanceof QuerySection && ((QuerySection)b4).whetherSectionToIndent() ? a2 : a1);
                }
                break;
            }
            case 8: {
                this.commonFirstWordRightAlign = SqlFormattingModelFunKt.makeRightAlignment();
                for (SqlBlock b5 : this.getNestedBlocks()) {
                    SqlLeafBlock sqlLeafBlock = b5.getFirstLeafBlock();
                    if (sqlLeafBlock == null) continue;
                    sqlLeafBlock.setMyAlign(this.commonFirstWordRightAlign);
                }
                break;
            }
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (block1 instanceof InsertSection && block2 instanceof InsertSection) {
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
        return spacing;
    }

    @Override
    @Nullable
    public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        SqlBlock block1 = blocks.getBlock1();
        return block1 instanceof QuerySection && block1.incomplete() ? block1.getNewLineIdent(new AdjacentBlocks((SqlBlock)CollectionsKt.lastOrNull(((QuerySection)block1).getSubBlocks()), null)) : SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, false, 6, null);
    }

    @Override
    @NotNull
    public String getDebugName() {
        return super.getDebugName() + (this.isSubQuery ? "(sub)" : "");
    }

    static {
        Companion = new Companion(null);
        nodesToFlatten = SetsKt.setOf((Object[])new SqlCompositeElementType[]{SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, SqlCompositeElementTypes.SQL_SET_CLAUSE, SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_CLAUSE, SqlCompositeElementTypes.SQL_TABLE_EXPRESSION, SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, SqlCompositeElementTypes.SQL_REFERENCE_LIST, SqlCompositeElementTypes.SQL_FROM_CLAUSE, SqlCompositeElementTypes.SQL_WHERE_CLAUSE, SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE, SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE, SqlCompositeElementTypes.SQL_HAVING_CLAUSE, SqlCompositeElementTypes.SQL_UNION_EXPRESSION, SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE, SqlCompositeElementTypes.SQL_CLAUSE});
        sectionMakers = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_INSERT, SqlCommonKeywords.SQL_REPLACE, SqlCommonKeywords.SQL_INTO, SqlCommonKeywords.SQL_ON, SqlCommonKeywords.SQL_UPDATE, SqlCommonKeywords.SQL_DELETE, SqlCommonKeywords.SQL_SET, SqlCommonKeywords.SQL_VALUES, SqlCommonKeywords.SQL_WITH, SqlCommonKeywords.SQL_SELECT, SqlCommonKeywords.SQL_FROM, SqlCommonKeywords.SQL_WHERE, SqlCommonKeywords.SQL_START, SqlCommonKeywords.SQL_CONNECT, SqlCommonKeywords.SQL_GROUP, SqlCommonKeywords.SQL_HAVING, SqlCommonKeywords.SQL_UNION, SqlCommonKeywords.SQL_INTERSECT, SqlCommonKeywords.SQL_MINUS, SqlCommonKeywords.SQL_ORDER, SqlCommonKeywords.SQL_OPTION, SqlCommonKeywords.SQL_LIMIT});
        tableJoinWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_NATURAL, SqlCommonKeywords.SQL_LEFT, SqlCommonKeywords.SQL_RIGHT, SqlCommonKeywords.SQL_FULL, SqlCommonKeywords.SQL_INNER, SqlCommonKeywords.SQL_OUTER, SqlCommonKeywords.SQL_CROSS, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_HASH, SqlCommonKeywords.SQL_MERGE, SqlCommonKeywords.SQL_REMOTE, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_REDUCE, SqlCommonKeywords.SQL_REPLICATE, SqlCommonKeywords.SQL_REDISTRIBUTE, SqlCommonKeywords.SQL_ARRAY, SqlCommonKeywords.SQL_APPLY, SqlCommonKeywords.SQL_JOIN, SqlCommonKeywords.SQL_LATERAL});
        unionGluedWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_UNION, SqlCommonKeywords.SQL_INTERSECT, SqlCommonKeywords.SQL_MINUS, SqlCommonKeywords.SQL_ALL});
        commonPatterns = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_INTO, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_ON, (Object)new SeparatorPattern(SetsKt.minus(sectionMakers, (Iterable)SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_ON, SqlCommonKeywords.SQL_UPDATE})), (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.2.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_UPDATE, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.3.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_DELETE, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.4.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_SET, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.5.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_VALUES, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.6.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_WITH, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.7.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_SELECT, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.8.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_FROM, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.9.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_WHERE, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.10.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_START, (Object)new SeparatorPattern(SetsKt.minus(sectionMakers, (Object)SqlCommonKeywords.SQL_WITH), (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.11.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_CONNECT, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.12.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_GROUP, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.13.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_HAVING, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.14.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_UNION, (Object)new ElementTypeSetPattern(unionGluedWords, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.15.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_INTERSECT, (Object)new ElementTypeSetPattern(unionGluedWords, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.16.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_MINUS, (Object)new ElementTypeSetPattern(unionGluedWords, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.17.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_ORDER, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.18.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_OPTION, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.19.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_LIMIT, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.commonPatterns.20.INSTANCE)))});
        insertIntoTogetherPatterns = MapsKt.plus(commonPatterns, (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_INSERT, (Object)new SeparatorPattern(SetsKt.minus(sectionMakers, (Object)SqlCommonKeywords.SQL_INTO), (Function0<? extends SqlRangeBlock>)((Function0)Companion.insertIntoTogetherPatterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_REPLACE, (Object)new SeparatorPattern(SetsKt.minus(sectionMakers, (Object)SqlCommonKeywords.SQL_INTO), (Function0<? extends SqlRangeBlock>)((Function0)Companion.insertIntoTogetherPatterns.2.INSTANCE)))}));
        insertIntoSeparatedPatterns = MapsKt.plus(commonPatterns, (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCommonKeywords.SQL_INSERT, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.insertIntoSeparatedPatterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_REPLACE, (Object)new SeparatorPattern(sectionMakers, (Function0<? extends SqlRangeBlock>)((Function0)Companion.insertIntoSeparatedPatterns.2.INSTANCE)))}));
    }

    public static final /* synthetic */ void access$setAllowedToCollapse$p(SqlQueryBlock $this, boolean bl) {
        $this.isAllowedToCollapse = bl;
    }

    public static final /* synthetic */ void access$setUnion$p(SqlQueryBlock $this, boolean bl) {
        $this.isUnion = bl;
    }

    @NotNull
    public static final /* synthetic */ Set access$getTableJoinWords$cp() {
        return tableJoinWords;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\nH&J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "firstWord", "Lcom/intellij/psi/tree/IElementType;", "getFirstWord$intellij_database_sql_impl", "()Lcom/intellij/psi/tree/IElementType;", "setFirstWord$intellij_database_sql_impl", "(Lcom/intellij/psi/tree/IElementType;)V", "firstWordLength", "", "getFirstWordLength$intellij_database_sql_impl", "()I", "setFirstWordLength$intellij_database_sql_impl", "(I)V", "prefixLength", "getPrefixLength$intellij_database_sql_impl", "setPrefixLength$intellij_database_sql_impl", "prefixSize", "getPrefixSize$intellij_database_sql_impl", "setPrefixSize$intellij_database_sql_impl", "thisQuery", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "getThisQuery$intellij_database_sql_impl", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "adjustNestedNodes", "", "userElementsLineSetting", "userRequiresExpand", "", "whetherSectionToIndent", "intellij.database.sql.impl"})
    private static abstract class QuerySection
    extends SqlRangeBlock {
        private int prefixSize;
        private int prefixLength;
        @Nullable
        private IElementType firstWord;
        private int firstWordLength;

        @NotNull
        public final SqlQueryBlock getThisQuery$intellij_database_sql_impl() {
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlQueryBlock");
            }
            return (SqlQueryBlock)sqlBlock;
        }

        public final int getPrefixSize$intellij_database_sql_impl() {
            return this.prefixSize;
        }

        public final void setPrefixSize$intellij_database_sql_impl(int n) {
            this.prefixSize = n;
        }

        public final int getPrefixLength$intellij_database_sql_impl() {
            return this.prefixLength;
        }

        public final void setPrefixLength$intellij_database_sql_impl(int n) {
            this.prefixLength = n;
        }

        @Nullable
        public final IElementType getFirstWord$intellij_database_sql_impl() {
            return this.firstWord;
        }

        public final void setFirstWord$intellij_database_sql_impl(@Nullable IElementType iElementType) {
            this.firstWord = iElementType;
        }

        public final int getFirstWordLength$intellij_database_sql_impl() {
            return this.firstWordLength;
        }

        public final void setFirstWordLength$intellij_database_sql_impl(int n) {
            this.firstWordLength = n;
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if (firstNode != null) {
                this.firstWord = firstNode.getElementType();
                this.firstWordLength = firstNode.getTextLength();
            }
        }

        public boolean whetherSectionToIndent() {
            return false;
        }

        @Override
        public abstract int userElementsLineSetting();

        @Override
        public boolean userRequiresExpand() {
            return (this.userElementsLineSetting() == 101 || this.userWrapSetting() == 1) && !this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse;
        }

        public QuerySection() {
            this.setRole(BlockRole.ELEMENT);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0014J\u0015\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0010\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/H\u0010\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\u0004H\u0014J\b\u00102\u001a\u000203H\u0016J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u0010:\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u0010;\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0014J\u0016\u0010<\u001a\u00020 2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020/0>H\u0014J\b\u0010?\u001a\u00020 H\u0014J\b\u0010@\u001a\u00020 H\u0014J\b\u0010A\u001a\u00020 H\u0014J\b\u0010B\u001a\u00020\u0004H\u0014J\b\u0010C\u001a\u00020\nH\u0015J\b\u0010D\u001a\u00020\nH\u0016J\b\u0010E\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R$\u0010\t\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006F"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "comma1st", "", "getComma1st", "()Z", "commaLast", "getCommaLast", "commaPlace", "", "commaPlace$annotations", "getCommaPlace", "()I", "setCommaPlace", "(I)V", "countOfDelimiters", "getCountOfDelimiters", "setCountOfDelimiters", "countOfElements", "getCountOfElements", "setCountOfElements", "countOfLineComments", "getCountOfLineComments", "setCountOfLineComments", "delimiterLength", "getDelimiterLength", "delimiterType", "Lcom/intellij/sql/psi/SqlTokenType;", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "analyseOriginalCodeStyle", "", "calculatePrefixLength", "configureFormattingAttributes", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "determineWrapFirstElement", "getChildAttributesForNewElementAtTheEnd", "Lcom/intellij/formatting/ChildAttributes;", "getNewLineIdent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "isPrefixPart", "index", "makeDelimiterBlock", "makeElementBlock", "prepareTheList", "listNodes", "", "prepareThePrefix", "produceNestedBlocks", "tabifyContent", "toAlignElements", "userCommaSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "intellij.database.sql.impl"})
    private static abstract class WordAndListSection
    extends QuerySection {
        private int countOfElements;
        private int countOfDelimiters;
        private int countOfLineComments;
        private int commaPlace;

        public final int getCountOfElements() {
            return this.countOfElements;
        }

        public final void setCountOfElements(int n) {
            this.countOfElements = n;
        }

        public final int getCountOfDelimiters() {
            return this.countOfDelimiters;
        }

        public final void setCountOfDelimiters(int n) {
            this.countOfDelimiters = n;
        }

        public final int getCountOfLineComments() {
            return this.countOfLineComments;
        }

        public final void setCountOfLineComments(int n) {
            this.countOfLineComments = n;
        }

        @NotNull
        protected SqlTokenType getDelimiterType() {
            SqlTokenType sqlTokenType = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_COMMA");
            return sqlTokenType;
        }

        protected int getDelimiterLength() {
            return 1;
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected int userCommaSetting() {
            return 0;
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected static /* synthetic */ void commaPlace$annotations() {
        }

        protected final int getCommaPlace() {
            return this.commaPlace;
        }

        protected final void setCommaPlace(int n) {
            this.commaPlace = n;
        }

        protected boolean getComma1st() {
            return this.commaPlace == 1;
        }

        protected boolean getCommaLast() {
            return this.commaPlace == 2;
        }

        @Override
        protected void produceNestedBlocks() {
            int n = this.getNestedNodes().size();
            if (n > 0) {
                this.prepareThePrefix();
            }
            if (n > this.getPrefixSize$intellij_database_sql_impl()) {
                this.prepareTheList(this.getNestedNodes().subList(this.getPrefixSize$intellij_database_sql_impl(), n));
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void prepareThePrefix() {
            int p2;
            int n = this.getNestedNodes().size();
            for (p2 = 0; p2 < n && this.isPrefixPart(p2, this.getNestedNodes().get(p2)); ++p2) {
            }
            if (p2 == 1) {
                SqlBlock block = this.makeBlock(this.getNestedNodes().get(0));
                block.setRole(BlockRole.PREFIX);
                this.addNestedBlock$intellij_database_sql_impl(block);
                this.setPrefixSize$intellij_database_sql_impl(1);
                this.setPrefixLength$intellij_database_sql_impl(block.getRange().getLength());
                this.setFirstWordLength$intellij_database_sql_impl(this.getPrefixLength$intellij_database_sql_impl());
            } else if (p2 >= 2) {
                void parent$iv;
                void $receiver$iv;
                SqlRangeBlock sqlRangeBlock = new SqlPhraseBlock();
                SqlBlock sqlBlock = this;
                List<ASTNode> nodes$iv = this.getNestedNodes().subList(0, p2);
                $receiver$iv.setup$intellij_database_sql_impl((SqlBlock)parent$iv, nodes$iv);
                SqlPhraseBlock block = (SqlPhraseBlock)$receiver$iv;
                block.setRole(BlockRole.PREFIX);
                this.addNestedBlock$intellij_database_sql_impl(block);
                this.setPrefixSize$intellij_database_sql_impl(p2);
                this.setPrefixLength$intellij_database_sql_impl(block.getRange().getLength());
                this.setFirstWordLength$intellij_database_sql_impl(this.getNestedNodes().get(0).getTextLength());
            }
        }

        protected boolean isPrefixPart(int index2, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return SqlUtilFun.isKeyWord(node) && (index2 == 0 || index2 == 1 && (node.getElementType() == SqlCommonKeywords.SQL_BY || node.getElementType() == SqlCommonKeywords.SQL_WITH));
        }

        /*
         * WARNING - void declaration
         */
        protected void prepareTheList(@NotNull List<? extends ASTNode> listNodes) {
            Intrinsics.checkParameterIsNotNull(listNodes, (String)"listNodes");
            int n = this.getNestedNodes().size();
            int n2 = this.getPrefixSize$intellij_database_sql_impl();
            int n3 = n;
            while (n2 < n3) {
                SqlBlock sqlBlock;
                void i2;
                ASTNode node = this.getNestedNodes().get((int)i2);
                BlockRole blockRole = this.determineRole$intellij_database_sql_impl(node);
                switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$0[blockRole.ordinal()]) {
                    case 1: {
                        sqlBlock = this.makeElementBlock(node);
                        break;
                    }
                    case 2: {
                        sqlBlock = this.makeDelimiterBlock(node);
                        break;
                    }
                    default: {
                        sqlBlock = this.makeBlock(node);
                    }
                }
                SqlBlock block = sqlBlock;
                block.setRole(blockRole);
                this.addNestedBlock$intellij_database_sql_impl(block);
                ++i2;
            }
        }

        @Override
        @NotNull
        public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
            IElementType type = iElementType;
            if (type == this.getDelimiterType()) {
                return BlockRole.DELIMITER;
            }
            BlockRole r = SqlFormattingFunKt.usualRole(node);
            if (r == BlockRole.NOTHING && Intrinsics.areEqual(node.getClass(), LeafPsiElement.class) ^ true) {
                r = BlockRole.ELEMENT;
            }
            return r;
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
            switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$1[role.ordinal()]) {
                case 1: {
                    int n = this.countOfElements;
                    this.countOfElements = n + 1;
                    break;
                }
                case 2: {
                    int n = this.countOfDelimiters;
                    this.countOfDelimiters = n + 1;
                    break;
                }
                case 3: {
                    int n = this.countOfLineComments;
                    this.countOfLineComments = n + 1;
                }
            }
        }

        @NotNull
        protected SqlBlock makeElementBlock(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.makeBlock(node);
        }

        @NotNull
        protected SqlBlock makeDelimiterBlock(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.makeBlock(node);
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            if (this.countOfDelimiters > 0) {
                this.commaPlace = this.userCommaSetting();
                if (this.commaPlace == -1) {
                    this.commaPlace = this.getContext().getSql().QUERY_EL_COMMA;
                }
                if (this.commaPlace == 0) {
                    this.commaPlace = SqlCommonHandlersKt.autodetectDelimiter(this.getContext(), (Iterable<? extends SqlBlock>)this.getNestedBlocks());
                }
                if (this.commaPlace == -1 || this.commaPlace == 0) {
                    this.commaPlace = 2;
                }
            } else {
                this.commaPlace = 0;
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            Object $receiver$iv$iv;
            Alignment a;
            Iterable $receiver$iv;
            SqlCodeStyleSettings s = this.getContext().getSql();
            this.calculatePrefixLength();
            if (this.commaPlace != 4) {
                WrapType wrapType;
                block0 : switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$2[this.getShape().ordinal()]) {
                    case 1: {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                wrapType = WrapType.CHOP_DOWN_IF_LONG;
                                break block0;
                            }
                            case 3: {
                                wrapType = WrapType.NORMAL;
                                break block0;
                            }
                        }
                        if (this.countOfElements <= this.userNumberOfElementsToKeepCollapsed()) {
                            wrapType = null;
                            break;
                        }
                        wrapType = WrapType.NORMAL;
                        break;
                    }
                    case 2: {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                wrapType = WrapType.ALWAYS;
                                break block0;
                            }
                        }
                        wrapType = WrapType.NORMAL;
                        break;
                    }
                    default: {
                        wrapType = null;
                    }
                }
                WrapType wt = wrapType;
                Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, wt, false, 2, null);
                Wrap wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                if (wrap == null) {
                    Intrinsics.throwNpe();
                }
                Wrap dontWrap = wrap;
                boolean wrapFirst = this.determineWrapFirstElement();
                boolean isFirst = true;
                for (SqlBlock b2 : this.getNestedBlocks()) {
                    switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$3[b2.getRole().ordinal()]) {
                        case 1: {
                            if (isFirst) {
                                b2.setMyWrap(wrapFirst ? w : dontWrap);
                            } else {
                                b2.setMyWrap(this.getCommaLast() ? w : dontWrap);
                            }
                            isFirst = false;
                            break;
                        }
                        case 2: {
                            b2.setMyWrap(this.getComma1st() ? w : dontWrap);
                        }
                    }
                }
            }
            switch (this.commaPlace) {
                case 1: {
                    Indent indent;
                    switch (this.userElementsLineSetting()) {
                        case 1: {
                            indent = Indent.getSpaceIndent((int)(this.getPrefixLength$intellij_database_sql_impl() - this.getDelimiterLength()), (boolean)true);
                            break;
                        }
                        default: {
                            indent = Indent.getNormalIndent((boolean)true);
                        }
                    }
                    Indent i2 = indent;
                    $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                    for (Object element$iv : $receiver$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        it.setMyIndent(i2);
                    }
                    break;
                }
                default: {
                    Indent i2 = Indent.getNormalIndent((s.QUERY_TRUE_INDENT && this.countOfElements + this.countOfDelimiters > 1 ? 1 : 0) != 0);
                    $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT, BlockRole.LINE_COMMENT);
                    for (Object element$iv : $receiver$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        it.setMyIndent(i2);
                    }
                    Indent i22 = Indent.getContinuationIndent();
                    Iterator $receiver$iv2 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
                    Iterator element$iv = $receiver$iv2.iterator();
                    while (element$iv.hasNext()) {
                        Object element$iv2 = element$iv.next();
                        SqlBlock it = (SqlBlock)element$iv2;
                        it.setMyIndent(i22);
                    }
                    break block15;
                }
            }
            if (this.toAlignElements()) {
                if (this.getComma1st()) {
                    Alignment alignment;
                    if (this.getPrefixSize$intellij_database_sql_impl() == 1) {
                        alignment = this.getThisQuery$intellij_database_sql_impl().getCommonFirstWordRightAlign();
                        if (alignment == null) {
                            alignment = SqlFormattingModelFunKt.makeRightAlignment();
                        }
                    } else {
                        alignment = SqlFormattingModelFunKt.makeRightAlignment();
                    }
                    a = alignment;
                    $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.PREFIX, BlockRole.DELIMITER);
                    for (Object element$iv : $receiver$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        SqlLeafBlock sqlLeafBlock = it.getLastLeafBlock();
                        if (sqlLeafBlock == null) continue;
                        sqlLeafBlock.setMyAlign(a);
                    }
                } else {
                    SqlBlock b3;
                    a = SqlFormattingModelFunKt.makeLeftAlignment();
                    if (this.countOfLineComments > 0 && this.countOfElements > 0 && this.getNestedBlocks().size() >= 3 && (b3 = this.getNestedBlocks().get(1)) instanceof SqlLineCommentBlock) {
                        a = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                        b3.setMyAlign(a);
                    }
                    $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                    for (Object element$iv : $receiver$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        it.setMyAlign(a);
                    }
                    $receiver$iv = this.getNestedBlocks();
                    $receiver$iv$iv = $receiver$iv;
                    JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
                    JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                    Object object = configureFormattingAttributes.6.INSTANCE;
                    if (object != null) {
                        $receiver$iv = object;
                        object = new SqlQueryBlock$sam$com_intellij_openapi_util_Condition$0((Function1)$receiver$iv);
                    }
                    JBIterable jBIterable3 = jBIterable2.filter((Condition)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"nestedBlocks.filter<SqlL\u2026mentBlock::isWholeString)");
                    $receiver$iv = (Iterable)jBIterable3;
                    for (Object element$iv : $receiver$iv) {
                        SqlLineCommentBlock it = (SqlLineCommentBlock)element$iv;
                        it.setMyAlign(a);
                    }
                }
            }
            this.tabifyContent();
            if (s.QUERY_ALIGN_LINE_COMMENTS) {
                a = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                $receiver$iv = this.getNestedBlocks();
                $receiver$iv$iv = $receiver$iv;
                JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable4 = jBIterable.filter(SqlLineCommentBlock.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable5 = jBIterable4.filter((Condition)configureFormattingAttributes.8.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable5, (String)"nestedBlocks\n          .\u2026r { !it.isWholeString() }");
                $receiver$iv = (Iterable)jBIterable5;
                for (Object element$iv : $receiver$iv) {
                    SqlLineCommentBlock it = (SqlLineCommentBlock)element$iv;
                    if (it.getMyAlign() != null) continue;
                    it.setMyAlign(a);
                }
            }
        }

        protected boolean determineWrapFirstElement() {
            return this.userElementsLineSetting() == 101;
        }

        protected boolean toAlignElements() {
            return this.getContext().getSql().QUERY_ALIGN_ELEMENTS;
        }

        protected void tabifyContent() {
        }

        private final void calculatePrefixLength() {
            SqlBlock sqlBlock = this.getFirstNestedBlock();
            if (sqlBlock == null) {
                return;
            }
            SqlBlock b2 = sqlBlock;
            if (b2.getRole() == BlockRole.PREFIX) {
                b2.analyze();
                this.setPrefixLength$intellij_database_sql_impl(b2.getMinLength());
            }
        }

        public int userNumberOfElementsToKeepCollapsed() {
            return this.userElementsLineSetting() >= 101 ? 0 : 1;
        }

        @Override
        public boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse) {
                return false;
            }
            return this.countOfElements > this.userNumberOfElementsToKeepCollapsed() && this.userWrapSetting() == 1 || this.countOfElements >= 1 && this.userElementsLineSetting() >= 101;
        }

        @Override
        @Nullable
        public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            if (block1 instanceof SqlComma) {
                return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
            }
            if (block2 instanceof SqlComma) {
                if (this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && this.getComma1st() && SqlFormattingModelFunKt.isAlways(block2.getMyWrap())) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
                return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
            }
            return super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
            Object newIndent = SqlFormattingFunKt.getNONE_INDENT();
            Alignment newAlignment = null;
            if (this.countOfElements + this.countOfDelimiters == 0 && this.userBreakFirstElement()) {
                newIndent = SqlFormattingFunKt.getNORMAL_INDENT();
            } else if (this.countOfDelimiters >= this.countOfElements && this.countOfElements > 1) {
                SqlBlock b2;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2;
                block5: {
                    List<SqlBlock> list;
                    List<SqlBlock> list2 = list = this.getNestedBlocks();
                    ListIterator<SqlBlock> listIterator = list2.listIterator(list2.size());
                    while (listIterator.hasPrevious()) {
                        SqlBlock sqlBlock3 = listIterator.previous();
                        SqlBlock it = sqlBlock3;
                        if (!(it.getRole() == BlockRole.ELEMENT)) continue;
                        sqlBlock2 = sqlBlock3;
                        break block5;
                    }
                    sqlBlock2 = null;
                }
                if ((sqlBlock = (b2 = (SqlBlock)sqlBlock2)) == null || (sqlBlock = sqlBlock.getIndent()) == null) {
                    sqlBlock = SqlFormattingFunKt.getNONE_INDENT();
                }
                newIndent = sqlBlock;
                SqlBlock sqlBlock4 = b2;
                newAlignment = sqlBlock4 != null ? sqlBlock4.getAlignment() : null;
            }
            return new ChildAttributes(newIndent, newAlignment);
        }

        @Override
        @Nullable
        public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
            this.analyze();
            BlockRole r1 = blocks.getRole1();
            BlockRole r2 = blocks.getRole2();
            boolean trueIndent = this.getContext().getSql().QUERY_TRUE_INDENT;
            if (r2 == BlockRole.ELEMENT || r1 == BlockRole.DELIMITER) {
                switch (this.userElementsLineSetting()) {
                    case 1: {
                        string = this.getContext().currIndentOf((Block)this, trueIndent, this.getPrefixLength$intellij_database_sql_impl() + 1);
                        break;
                    }
                    default: {
                        string = this.getContext().currIndentOf((Block)this, trueIndent, true);
                        break;
                    }
                }
            } else {
                string = r2 == BlockRole.DELIMITER ? (this.getComma1st() ? this.getContext().currIndentOf((Block)this, trueIndent, this.getPrefixLength$intellij_database_sql_impl() - this.getDelimiterLength()) : (this.userElementsLineSetting() == 1 ? this.getContext().currIndentOf((Block)this, trueIndent, this.getPrefixLength$intellij_database_sql_impl() + 1) : this.getContext().currIndentOf((Block)this, trueIndent, true))) : null;
            }
            return string;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.impl"})
    private static final class InsertSection
    extends QuerySection {
        @NotNull
        private static final Map<IElementType, FlowPattern> patterns;
        @Deprecated
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().INSERT_TABLE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        @NotNull
        protected Map<IElementType, FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return this.getFirstWord$intellij_database_sql_impl() == SqlCommonKeywords.SQL_INTO;
        }

        @Override
        protected void configureFormattingAttributes() {
            block4: {
                Wrap wrap;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ALIAS1);
                if (sqlBlock2 == null) break block4;
                SqlBlock it = sqlBlock = sqlBlock2;
                switch (this.userElementsLineSetting()) {
                    case 1: {
                        wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                        break;
                    }
                    case 101: {
                        wrap = this.makeWrap$intellij_database_sql_impl(WrapType.ALWAYS, true);
                        break;
                    }
                    default: {
                        wrap = null;
                    }
                }
                it.setMyWrap(wrap);
            }
        }

        static {
            Companion = new Companion(null);
            patterns = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (Object)new SingleElementPattern(BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonTokens.SQL_LEFT_PAREN, (Object)new EndIncElementPattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE))), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_HINT_CLAUSE, (Object)new SingleElementPattern((Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE)))});
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final Map<IElementType, FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "incomplete", "", "makeElementBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "node", "Lcom/intellij/lang/ASTNode;", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userWrapSetting", "whetherSectionToIndent", "intellij.database.sql.impl"})
    private static final class ValuesSection
    extends WordAndListSection {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected SqlCortegeLikeParenthesizedListBlock makeElementBlock(@NotNull ASTNode node) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SqlRangeBlock sqlRangeBlock = new SqlCortegeLikeParenthesizedListBlock();
            SqlBlock parent$iv = this;
            TextRange textRange = node.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"outerNode.textRange");
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
            return (SqlCortegeLikeParenthesizedListBlock)sqlRangeBlock;
        }

        @Override
        protected void tabifyContent() {
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return this.getContext().getSql().INSERT_COLLAPSE_MULTI_ROW_VALUES ? (this.getContext().getLengthThresholdMax() - 7) / 4 : 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().INSERT_VALUES_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getCountOfElements() <= this.userNumberOfElementsToKeepCollapsed() ? 2 : 1;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().INSERT_CLOSING >= 3 && this.getContext().getSql().INSERT_OPENING == 1 ? 4 : this.getContext().getSql().INSERT_EL_COMMA;
        }

        @Override
        public boolean incomplete() {
            SqlBlock sqlBlock = (SqlBlock)CollectionsKt.lastOrNull(this.getSubBlocks());
            if (sqlBlock == null) {
                return true;
            }
            SqlBlock last = sqlBlock;
            return Intrinsics.areEqual((Object)SqlFormattingModelFunKt.primaryElementType(last), (Object)SqlCommonTokens.SQL_COMMA) || last.incomplete();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedListBlock;", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "userClosingSetting", "", "userContentSetting", "userDelimiterSetting", "userOpeningSetting", "userSpaceWithinParentheses", "", "userWrapSetting", "intellij.database.sql.impl"})
    private static final class SqlCortegeLikeParenthesizedListBlock
    extends SqlParenthesizedListBlock {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
            void what$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            BlockRole blockRole = super.determineRole$intellij_database_sql_impl(node);
            BlockRole blockRole2 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            return Intrinsics.areEqual((Object)$receiver$iv, (Object)what$iv) ? with$iv : blockRole;
        }

        @Override
        protected int userOpeningSetting() {
            return this.getContext().getSql().INSERT_OPENING;
        }

        @Override
        protected int userContentSetting() {
            return this.getContext().getSql().INSERT_CONTENT;
        }

        @Override
        protected int userClosingSetting() {
            return this.getContext().getSql().INSERT_CLOSING;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().INSERT_EL_WRAP;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userDelimiterSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().INSERT_EL_COMMA;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_COMMA;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public boolean userSpaceWithinParentheses() {
            return this.getContext().getSql().INSERT_SPACE_WITHIN_PARENTHESES;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UpdateSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class UpdateSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$DeleteSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class DeleteSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u0006H\u0014J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "isPrefixPart", "", "index", "", "node", "Lcom/intellij/lang/ASTNode;", "makeElementBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetAssignment;", "tabifyContent", "", "userCommaSetting", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.impl"})
    private static final class SetSection
    extends WordAndListSection {
        @NotNull
        private static final SqlTokenType[] additionalPrefixWords;
        @Deprecated
        public static final Companion Companion;

        @Override
        protected boolean isPrefixPart(int index2, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return super.isPrefixPart(index2, node) || index2 > 0 && ArraysKt.contains((Object[])additionalPrefixWords, (Object)node.getElementType());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected SetAssignment makeElementBlock(@NotNull ASTNode node) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SqlNodeBlock sqlNodeBlock = new SetAssignment();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
            return (SetAssignment)sqlNodeBlock;
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().SET_ALIGN_EQUAL_SIGN) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Companion = new Companion(null);
            additionalPrefixWords = new SqlTokenType[]{SqlCommonKeywords.SQL_ON, SqlCommonKeywords.SQL_DUPLICATE, SqlCommonKeywords.SQL_KEY, SqlCommonKeywords.SQL_UPDATE};
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection$Companion;", "", "()V", "additionalPrefixWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "getAdditionalPrefixWords", "()[Lcom/intellij/sql/psi/SqlTokenType;", "[Lcom/intellij/sql/psi/SqlTokenType;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final SqlTokenType[] getAdditionalPrefixWords() {
                return additionalPrefixWords;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "makeElementBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE;", "node", "Lcom/intellij/lang/ASTNode;", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "intellij.database.sql.impl"})
    private static final class WithSection
    extends WordAndListSection {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected CTE makeElementBlock(@NotNull ASTNode node) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SqlNodeBlock sqlNodeBlock = new CTE();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
            return (CTE)sqlNodeBlock;
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().WITH_ALIGN_AS) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().WITH_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WITH_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WITH_EL_COMMA;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "firstIsAsterisk", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineWrapFirstElement", "isPrefixPart", "index", "", "node", "Lcom/intellij/lang/ASTNode;", "makeElementBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement;", "produceNestedBlocks", "", "tabifyContent", "userCommaSetting", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "userWrapSetting", "intellij.database.sql.impl"})
    private static final class SelectSection
    extends WordAndListSection {
        private boolean firstIsAsterisk;

        @Override
        protected void produceNestedBlocks() {
            super.produceNestedBlocks();
            SqlBlock b1e = (SqlBlock)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).first();
            if (b1e instanceof SelectElement) {
                ((SelectElement)b1e).grow();
                this.firstIsAsterisk = ((SelectElement)b1e).isAsterisk$intellij_database_sql_impl();
            }
        }

        @Override
        protected boolean isPrefixPart(int index2, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SqlCodeStyleSettings s = this.getContext().getSql();
            return index2 == 1 && node instanceof SqlSelectOption && (this.userElementsLineSetting() == 101 || !s.SELECT_NEW_LINE_AFTER_ALL_DISTINCT) ? true : super.isPrefixPart(index2, node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected SelectElement makeElementBlock(@NotNull ASTNode node) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Object object = node.getElementType();
            List innerNodes = Intrinsics.areEqual((Object)object, (Object)SqlCompositeElementTypes.SQL_AS_EXPRESSION) ? SqlFormattingModelFunKt.listChildren(node) : CollectionsKt.listOf((Object)node);
            object = new SelectElement();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, innerNodes);
            return (SelectElement)object;
        }

        @Override
        protected boolean determineWrapFirstElement() {
            return !this.firstIsAsterisk && super.determineWrapFirstElement();
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().SELECT_ALIGN_AS && this.getContext().getSql().SELECT_EL_WRAP != 3) {
                boolean hasAliases1 = false;
                boolean hasAliases2 = false;
                JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).filter(SqlFlowBlock.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"nestedBlocks.filter(ELEM\u2026SqlFlowBlock::class.java)");
                Iterable $receiver$iv = (Iterable)jBIterable;
                for (Object element$iv : $receiver$iv) {
                    SqlFlowBlock it = (SqlFlowBlock)element$iv;
                    hasAliases1 = hasAliases1 || SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)it.getNestedBlocks(), BlockRole.ALIAS1).isNotEmpty();
                    hasAliases2 = hasAliases2 || SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)it.getNestedBlocks(), BlockRole.ALIAS2).isNotEmpty();
                }
                if (hasAliases1) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS1);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ESSENCE);
                }
                if (hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS2);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse && this.getMinLength() < this.getContext().getLengthThresholdMin()) {
                return false;
            }
            return this.getContext().getSql().SELECT_EL_WRAP == 1 && this.getCountOfElements() > this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            int n = this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
            int n2 = this.userElementsLineSetting() == 101 ? SqlUtilFun.toInt(this.firstIsAsterisk) : 1;
            return Math.max(n, n2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().SELECT_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SELECT_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SELECT_EL_COMMA;
        }

        @Override
        @Nullable
        public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            IElementType t1;
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            ASTNode aSTNode = SqlFormattingModelFunKt.primaryNode(block1);
            Object object = t1 = aSTNode != null ? aSTNode.getElementType() : null;
            return t1 == SqlCommonKeywords.SQL_ALL || t1 == SqlCommonKeywords.SQL_DISTINCT ? this.getContext().makeSpace(this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT, this.userElementsLineSetting() == 0) : super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0004H\u0014J\b\u0010\u0010\u001a\u00020\nH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "hasJoins", "", "getHasJoins", "()Z", "setHasJoins", "(Z)V", "configureFormattingAttributes", "", "makeElementBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement;", "node", "Lcom/intellij/lang/ASTNode;", "toAlignElements", "tuneNestedNodesAfterAnalysis", "userCommaSetting", "", "userElementsLineSetting", "userRequiresExpand", "userWrapSetting", "whetherSectionToIndent", "intellij.database.sql.impl"})
    private static final class FromSection
    extends WordAndListSection {
        private boolean hasJoins;

        public final boolean getHasJoins() {
            return this.hasJoins;
        }

        public final void setHasJoins(boolean bl) {
            this.hasJoins = bl;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected PrimaryTableElement makeElementBlock(@NotNull ASTNode node) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SqlNodeBlock sqlNodeBlock = new PrimaryTableElement();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
            return (PrimaryTableElement)sqlNodeBlock;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().FROM_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().FROM_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().FROM_EL_COMMA;
        }

        @Override
        protected void tuneNestedNodesAfterAnalysis() {
            Iterable $receiver$iv;
            super.tuneNestedNodesAfterAnalysis();
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)this.getNestedBlocks();
            JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
            $receiver$iv = (Iterable)jBIterable2;
            for (Object element$iv : $receiver$iv) {
                PrimaryTableElement it = (PrimaryTableElement)element$iv;
                this.hasJoins = this.hasJoins || it.getCountOfJoins() > 0;
            }
            if (this.getCountOfElements() > 1 && this.hasJoins) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected boolean toAlignElements() {
            return this.getContext().getSql().FROM_ONLY_JOIN_INDENT > -1 && this.getCountOfElements() + this.getCountOfDelimiters() <= 1 ? false : super.toAlignElements();
        }

        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            if (this.getContext().getSql().FROM_ALIGN_ALIASES) {
                Alignment a1 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Iterable $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                Iterable $receiver$iv$iv = $receiver$iv;
                JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable3 = jBIterable2.flatten((Function)configureFormattingAttributes.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"nestedBlocks\n          .\u2026atten { it.nestedBlocks }");
                $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable3), BlockRole.ELEMENT);
                $receiver$iv$iv = $receiver$iv;
                JBIterable jBIterable4 = JBIterable.from((Iterable)$receiver$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"JBIterable.from(this)");
                JBIterable jBIterable5 = jBIterable4.filter(SecondaryTableElement.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable5, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable6 = jBIterable5.flatten((Function)configureFormattingAttributes.2.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable6, (String)"nestedBlocks\n          .\u2026atten { it.nestedBlocks }");
                $receiver$iv = (Iterable)jBIterable6;
                for (Object element$iv : $receiver$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    if (it.getRole() == BlockRole.AS) {
                        it.setMyAlign(a1);
                    }
                    if (it.getRole() != BlockRole.ALIAS2) continue;
                    it.setMyAlign(a2);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.getCountOfElements() >= 2 && (this.hasJoins || this.userWrapSetting() == 1);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0014J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "delimiterLength", "", "getDelimiterLength", "()I", "<set-?>", "Lcom/intellij/sql/psi/SqlTokenType;", "delimiterType", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "setDelimiterType", "(Lcom/intellij/sql/psi/SqlTokenType;)V", "adjustNestedNodes", "", "determinePrimaryDelimiter", "userCommaSetting", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "intellij.database.sql.impl"})
    private static final class WhereSection
    extends WordAndListSection {
        @NotNull
        private SqlTokenType delimiterType;

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        @NotNull
        protected SqlTokenType getDelimiterType() {
            return this.delimiterType;
        }

        public void setDelimiterType(@NotNull SqlTokenType sqlTokenType) {
            Intrinsics.checkParameterIsNotNull((Object)sqlTokenType, (String)"<set-?>");
            this.delimiterType = sqlTokenType;
        }

        @Override
        protected int getDelimiterLength() {
            SqlTokenType sqlTokenType = this.getDelimiterType();
            return Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_OR) ? 2 : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_AND) ? 3 : 1);
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            this.determinePrimaryDelimiter();
            if (this.getDelimiterType() != SqlCommonKeywords.SQL_NO) {
                this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>(this){
                    final /* synthetic */ WhereSection this$0;

                    public final boolean invoke(@NotNull ASTNode it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return it.getElementType() == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION && SqlUtilFun.hasChildNode(it, (IElementType)this.this$0.getDelimiterType());
                    }
                    {
                        this.this$0 = whereSection;
                        super(1);
                    }
                }));
            }
        }

        private final void determinePrimaryDelimiter() {
            Object v0;
            Object object;
            block3: {
                Iterable iterable = this.getNestedNodes();
                object = iterable;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    ASTNode it = (ASTNode)t;
                    if (!(it.getElementType() == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ASTNode aSTNode = v0;
            if (aSTNode == null) {
                return;
            }
            ASTNode conditionNode = aSTNode;
            object = SqlUtilFun.children(conditionNode).iterator();
            while (object.hasNext()) {
                IElementType type;
                ASTNode child;
                ASTNode aSTNode2 = child = (ASTNode)object.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"child");
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2.getElementType(), (String)"child.elementType");
                if (type != SqlCommonKeywords.SQL_OR && type != SqlCommonKeywords.SQL_AND) continue;
                this.setDelimiterType((SqlTokenType)type);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().WHERE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WHERE_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WHERE_EL_BOUND;
        }

        public WhereSection() {
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_NO;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_NO");
            this.delimiterType = sqlTokenType;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "intellij.database.sql.impl"})
    private static final class GroupOrderSection
    extends WordAndListSection {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean whetherSectionToIndent() {
            if (!this.getThisQuery$intellij_database_sql_impl().isUnion) return true;
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if ((aSTNode != null ? aSTNode.getElementType() : null) == SqlCommonKeywords.SQL_ORDER) return false;
            return true;
        }

        @Override
        @NotNull
        public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_ASC) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_DESC) ? BlockRole.AMENDMENT : super.determineRole$intellij_database_sql_impl(node);
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().ORDER_ALIGN_ASC_DESC) {
                this.tabify(BlockRole.AMENDMENT);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $receiver$iv;
            int n = this.getContext().getSql().ORDER_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            return $receiver$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().ORDER_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().ORDER_EL_COMMA;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LimitSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "whetherSectionToIndent", "", "intellij.database.sql.impl"})
    private static final class LimitSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return !this.getThisQuery$intellij_database_sql_impl().isUnion;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\bJ\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnionSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class UnionSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        @NotNull
        public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnknownSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "whetherSectionToIndent", "", "intellij.database.sql.impl"})
    private static final class UnknownSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetAssignment;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "intellij.database.sql.impl"})
    private static final class SetAssignment
    extends SqlNodeBlock {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.impl"})
    private static final class CTE
    extends SqlNodeBlock {
        @NotNull
        private static final Map<IElementType, FlowPattern> patterns;
        public static final Companion Companion;

        @Override
        @NotNull
        protected Map<IElementType, FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                if (!(sqlBlock instanceof SqlFlowBlock)) {
                    sqlBlock = null;
                }
                SqlFlowBlock sqlFlowBlock = (SqlFlowBlock)sqlBlock;
                if (sqlFlowBlock == null) break block1;
                sqlFlowBlock.countRole$intellij_database_sql_impl(role);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                SqlBlock sqlBlock;
                Iterable iterable = this.getNestedBlocks();
                SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_AS;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_AS");
                SqlBlock sqlBlock2 = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)iterable, (IElementType)sqlTokenType);
                if (sqlBlock2 == null) break block0;
                SqlBlock it = sqlBlock = sqlBlock2;
                it.setMyWrap(SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.NORMAL, false, 2, null));
            }
        }

        static {
            Companion = new Companion(null);
            patterns = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IDENTIFIER, (Object)new SingleElementPattern(BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_AS, (Object)new SingleElementPattern(BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE))), TuplesKt.to((Object)SqlCommonTokens.SQL_LEFT_PAREN, (Object)new EndIncElementPattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), BlockRole.ESSENCE, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)))});
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
        public static final class Companion {
            @NotNull
            public final Map<IElementType, FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "isAsterisk", "", "isAsterisk$intellij_database_sql_impl", "()Z", "setAsterisk$intellij_database_sql_impl", "(Z)V", "adjustProducedNestedBlocks", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugNameSuffix", "", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.database.sql.impl"})
    private static final class SelectElement
    extends SqlRangeBlock {
        private boolean isAsterisk;
        @NotNull
        private static final Map<IElementType, FlowPattern> patterns;
        @Deprecated
        public static final Companion Companion;

        public final boolean isAsterisk$intellij_database_sql_impl() {
            return this.isAsterisk;
        }

        public final void setAsterisk$intellij_database_sql_impl(boolean bl) {
            this.isAsterisk = bl;
        }

        @Override
        @NotNull
        protected Map<IElementType, FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SqlBlock makeBlock(@NotNull ASTNode node) {
            SqlBlock sqlBlock;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            ASTNode aSTNode = node;
            if (aSTNode instanceof SqlExpression) {
                void $receiver$iv;
                SqlNodeBlock sqlNodeBlock = new SelectElementEssence();
                SqlBlock parent$iv = this;
                $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
                sqlBlock = SqlBlockKt.withRole((SqlBlock)sqlNodeBlock, BlockRole.ESSENCE);
            } else {
                sqlBlock = super.makeBlock(node);
            }
            return sqlBlock;
        }

        @Override
        protected void adjustProducedNestedBlocks() {
            boolean essencePassed = false;
            for (SqlBlock b2 : this.getNestedBlocks()) {
                SqlBlock sqlBlock = b2;
                if (sqlBlock instanceof SqlAliasBlock) {
                    b2.setRole(essencePassed ? BlockRole.ALIAS2 : BlockRole.ALIAS1);
                    continue;
                }
                if (!(sqlBlock instanceof SelectElementEssence)) continue;
                essencePassed = true;
                this.isAsterisk = this.isAsterisk || ((SelectElementEssence)b2).isAsterisk$intellij_database_sql_impl();
            }
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                if (!(sqlBlock instanceof SqlFlowBlock)) {
                    sqlBlock = null;
                }
                SqlFlowBlock sqlFlowBlock = (SqlFlowBlock)sqlBlock;
                if (sqlFlowBlock == null) break block1;
                sqlFlowBlock.countRole$intellij_database_sql_impl(role);
            }
        }

        @Override
        @Nullable
        protected String getDebugNameSuffix() {
            return this.isAsterisk ? "*" : null;
        }

        static {
            Companion = new Companion(null);
            patterns = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)SqlCompositeElementTypes.SQL_IDENTIFIER, (Object)new SingleElementPattern((Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))), TuplesKt.to((Object)SqlCommonTokens.SQL_OP_EQ, (Object)new SingleElementPattern(BlockRole.EQ, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE))), TuplesKt.to((Object)SqlCommonKeywords.SQL_AS, (Object)new SingleElementPattern(BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE))), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (Object)new SingleElementPattern(BlockRole.ESSENCE, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE))), TuplesKt.to((Object)SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, (Object)new SingleElementPattern(BlockRole.ESSENCE, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE))), TuplesKt.to((Object)SqlCommonTokens.SQL_COMMA, (Object)new SingleElementPattern(BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE)))});
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final Map<IElementType, FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElementEssence;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "isAsterisk", "", "isAsterisk$intellij_database_sql_impl", "()Z", "incomplete", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.impl"})
    private static final class SelectElementEssence
    extends SqlNodeBlock {
        public final boolean isAsterisk$intellij_database_sql_impl() {
            return SqlUtilFun.isSymbol(this.getBlockNode(), '*');
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.isAsterisk$intellij_database_sql_impl() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.getBlockNode());
        }

        @Override
        public boolean incomplete() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\u0016\u0010&\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\b\u0010(\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020%H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "countOfJoins", "", "getCountOfJoins", "()I", "setCountOfJoins", "(I)V", "forceWrap1", "", "getForceWrap1", "()Z", "forceWrap2", "getForceWrap2", "joinAlign", "Lcom/intellij/formatting/Alignment;", "getJoinAlign", "()Lcom/intellij/formatting/Alignment;", "setJoinAlign", "(Lcom/intellij/formatting/Alignment;)V", "parentSection", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "getParentSection", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "produceNestedBlocks", "nodes", "userRequiresExpand", "whetherToFlatten", "node", "intellij.database.sql.impl"})
    private static final class PrimaryTableElement
    extends SqlNodeBlock {
        private int countOfJoins;
        @Nullable
        private Alignment joinAlign;

        @NotNull
        public final FromSection getParentSection() {
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlQueryBlock.FromSection");
            }
            return (FromSection)sqlBlock;
        }

        public final int getCountOfJoins() {
            return this.countOfJoins;
        }

        public final void setCountOfJoins(int n) {
            this.countOfJoins = n;
        }

        @Nullable
        public final Alignment getJoinAlign() {
            return this.joinAlign;
        }

        public final void setJoinAlign(@Nullable Alignment alignment) {
            this.joinAlign = alignment;
        }

        public final boolean getForceWrap1() {
            return this.getContext().getSql().FROM_WRAP_JOIN_1 && this.countOfJoins >= 1;
        }

        public final boolean getForceWrap2() {
            return this.getContext().getSql().FROM_WRAP_JOIN_2 && this.countOfJoins >= 2;
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.getBlockNode().getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION ? CollectionsKt.listOf((Object)this.getBlockNode()) : super.listTheChildren();
        }

        @Override
        protected boolean whetherToFlatten(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return node.getElementType() == SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes2) {
            Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
            int n = nodes2.size();
            int p2 = 0;
            while (p2 < n) {
                IntRange $receiver$iv;
                SecondaryTableElement elementBlock;
                int e;
                IntRange join2;
                IntRange intRange = join2 = SqlFormattingModelFunKt.findConsequence(nodes2, p2, (Function1<? super ASTNode, Boolean>)((Function1)produceNestedBlocks.join.1.INSTANCE));
                int n2 = e = intRange != null ? intRange.getStart() : n;
                if (p2 < e) {
                    List<? extends ASTNode> subList = nodes2.subList(p2, e);
                    elementBlock = new SecondaryTableElement();
                    elementBlock.setup$intellij_database_sql_impl(this, subList);
                    elementBlock.setRole(BlockRole.ELEMENT);
                    this.addNestedBlock$intellij_database_sql_impl(elementBlock);
                }
                if (join2 == null) break;
                JoinPhrase joinBlock = new JoinPhrase();
                elementBlock = join2;
                int n3 = join2.getStart();
                List<? extends ASTNode> list = nodes2;
                SqlBlock sqlBlock = this;
                JoinPhrase joinPhrase = joinBlock;
                int n4 = $receiver$iv.getEndInclusive();
                joinPhrase.setup$intellij_database_sql_impl(sqlBlock, list.subList(n3, n4 + 1));
                joinBlock.setRole(BlockRole.DELIMITER);
                this.addNestedBlock$intellij_database_sql_impl(joinBlock);
                $receiver$iv = join2;
                p2 = $receiver$iv.getEndInclusive() + 1;
            }
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
            if (role == BlockRole.DELIMITER) {
                int n = this.countOfJoins;
                this.countOfJoins = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Indent defaultChildIndent(@NotNull SqlBlock block) {
            Indent indent;
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            if (block.getRole() == BlockRole.ELEMENT) {
                void what$iv;
                void $receiver$iv;
                int n = this.getContext().getSql().FROM_EL_LINE;
                int n2 = -1;
                int with$iv = this.getContext().getSql().QUERY_EL_LINE;
                if (($receiver$iv == what$iv ? with$iv : n) == 1) {
                    indent = SqlFormattingFunKt.getNONE_INDENT();
                    return indent;
                }
            }
            indent = super.defaultChildIndent(block);
            return indent;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            boolean unindentJoins;
            Wrap w2;
            Wrap w1;
            if (this.countOfJoins == 0) {
                return;
            }
            SqlCodeStyleSettings s = this.getContext().getSql();
            if (this.getForceWrap1() == this.getForceWrap2()) {
                Wrap wrap = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                if (wrap == null) {
                    Intrinsics.throwNpe();
                }
                w2 = w1 = wrap;
            } else {
                Wrap wrap = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                if (wrap == null) {
                    Intrinsics.throwNpe();
                }
                w1 = wrap;
                Wrap wrap2 = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.getForceWrap2() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                if (wrap2 == null) {
                    Intrinsics.throwNpe();
                }
                w2 = wrap2;
            }
            boolean bl = unindentJoins = s.FROM_ONLY_JOIN_INDENT > -1 && this.getParentSection().getCountOfElements() == 1;
            Indent i2 = unindentJoins && s.FROM_ONLY_JOIN_INDENT == 1 ? SqlFormattingFunKt.getNORMAL_INDENT() : (unindentJoins && s.FROM_ONLY_JOIN_INDENT == 2 ? SqlFormattingFunKt.getNONE_INDENT() : (s.FROM_INDENT_JOIN ? Indent.getNormalIndent((boolean)true) : Indent.getSpaceIndent((int)0, (boolean)true)));
            this.joinAlign = s.QUERY_ALIGN_ELEMENTS && !unindentJoins ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
            JBIterable<SqlBlock> joinWords = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            boolean bl2 = false;
            for (SqlBlock jw : (Iterable)joinWords) {
                void index2;
                if (index2 == false) {
                    jw.setMyWrap(w1);
                }
                if (index2 >= true) {
                    jw.setMyWrap(w2);
                }
                jw.setMyIndent(i2);
                jw.setMyAlign(this.joinAlign);
                ++index2;
            }
            if (s.FROM_ALIGN_JOIN_TABLES) {
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"nestedBlocks.filter(ELEMENT).skip(1)");
                Iterable $receiver$iv = (Iterable)jBIterable;
                for (Object element$iv : $receiver$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    it.setMyAlign(a2);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.getForceWrap1() || this.getForceWrap2();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\u0015\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0014J\b\u0010\u001e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "hasCondition", "", "getHasCondition", "()Z", "setHasCondition", "(Z)V", "adjustNestedNodes", "", "configureFormattingAttributes", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userRequiresExpand", "Companion", "intellij.database.sql.impl"})
    private static final class SecondaryTableElement
    extends SqlRangeBlock {
        private boolean hasCondition;
        @NotNull
        private static final Map<IElementType, FlowPattern> patterns;
        @Deprecated
        public static final Companion Companion;

        public final boolean getHasCondition() {
            return this.hasCondition;
        }

        public final void setHasCondition(boolean bl) {
            this.hasCondition = bl;
        }

        @Override
        protected void adjustNestedNodes() {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)adjustNestedNodes.1.INSTANCE));
        }

        @Override
        @NotNull
        protected Map<IElementType, FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
            BlockRole blockRole;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_AS)) {
                blockRole = BlockRole.AS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                blockRole = BlockRole.ALIAS2;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_USING_CLAUSE)) {
                blockRole = BlockRole.AMENDMENT;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_PERIOD)) {
                blockRole = BlockRole.NOTHING;
            } else {
                void var3_3;
                BlockRole r = super.determineRole$intellij_database_sql_impl(node);
                if (r == BlockRole.NOTHING || r == BlockRole.ELEMENT) {
                    r = BlockRole.ESSENCE;
                }
                blockRole = var3_3;
            }
            return blockRole;
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
            this.hasCondition = this.hasCondition || role == BlockRole.AMENDMENT;
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlCodeStyleSettings s = this.getContext().getSql();
            Iterable $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.AMENDMENT);
            for (Object element$iv : $receiver$iv) {
                Object object;
                Indent indent;
                SqlBlock it = (SqlBlock)element$iv;
                it.setMyWrap(SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, s.FROM_WRAP_ON ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null));
                switch (s.FROM_PLACE_ON) {
                    case 10: {
                        indent = SqlFormattingFunKt.getNONE_INDENT();
                        break;
                    }
                    case 11: {
                        indent = SqlFormattingFunKt.getNORMAL_INDENT();
                        break;
                    }
                    case 12: {
                        indent = Indent.getContinuationIndent();
                        break;
                    }
                    case 20: {
                        indent = Indent.getSpaceIndent((int)0, (boolean)true);
                        break;
                    }
                    case 21: {
                        indent = Indent.getNormalIndent((boolean)true);
                        break;
                    }
                    default: {
                        indent = this.getMyIndent();
                    }
                }
                it.setMyIndent(indent);
                if (s.FROM_PLACE_ON == 10) {
                    SqlBlock sqlBlock = this.getParent();
                    if (!(sqlBlock instanceof PrimaryTableElement)) {
                        sqlBlock = null;
                    }
                    PrimaryTableElement primaryTableElement = (PrimaryTableElement)sqlBlock;
                    object = primaryTableElement != null ? primaryTableElement.getJoinAlign() : null;
                } else {
                    object = null;
                }
                it.setMyAlign((Alignment)object);
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.hasCondition && this.getContext().getSql().FROM_WRAP_ON;
        }

        @Override
        @Nullable
        public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            return (r1 == BlockRole.ESSENCE || r1 == BlockRole.AS) && r2 == BlockRole.ALIAS2 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }

        static {
            Companion = new Companion(null);
            patterns = MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCommonTokens.SQL_LEFT_PAREN, (Object)new EndIncElementPattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final Map<IElementType, FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinPhrase;", "Lcom/intellij/sql/formatter/model/SqlPhraseBlock;", "()V", "intellij.database.sql.impl"})
    private static final class JoinPhrase
    extends SqlPhraseBlock {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "insertIntoSeparatedPatterns", "kotlin.jvm.PlatformType", "insertIntoTogetherPatterns", "nodesToFlatten", "", "sectionMakers", "tableJoinWords", "unionGluedWords", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

