/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import b.h.la;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.a;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleTypeBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public final class RModuleUtil {
    private static final Logger a;
    private static final long b;

    public static RModuleUtil getInstance() {
        return SingletonHolder.a;
    }

    private RModuleUtil() {
    }

    public Module[] getAllModulesWithRubySupport(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.a(0);
        }
        ArrayList arrayList = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Module[] moduleArray;
            if (project == null) {
                RModuleUtil.a(9);
            }
            if (project.isDisposed()) {
                return;
            }
            for (Module module : moduleArray = ModuleManager.getInstance((Project)project).getModules()) {
                if (!this.hasRubySupport(module)) continue;
                arrayList.add(module);
            }
        });
        return arrayList.toArray(Module.EMPTY_ARRAY);
    }

    @Contract(value="null -> false")
    public boolean hasRubySupport(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (this.isRubyModule(module)) {
            return true;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.hasRubySupport(module)) continue;
            return true;
        }
        return false;
    }

    public boolean isRubyModule(@Nullable Module module) {
        return module != null && this.isRubyModuleType(ModuleType.get((Module)module));
    }

    public boolean isRubyModuleType(@Nullable ModuleType moduleType) {
        return moduleType instanceof RubyModuleTypeBase;
    }

    @Contract(value="null -> null")
    @Nullable
    public VirtualFile getFirstContentRoot(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            RModuleUtil.a(1);
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
    }

    public void refreshRubyModuleTypeContent(Module module) {
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                VirtualFile virtualFile = this.getFirstContentRoot(module);
                if (virtualFile != null) {
                    virtualFile.refresh(false, true);
                }
            });
        }
        catch (Exception exception) {
            a.error((Throwable)exception);
        }
    }

    public RSupportPerModuleSettings getRubyModuleSettings(@NotNull Module module) {
        if (module == null) {
            RModuleUtil.a(2);
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            RSupportPerModuleSettings rSupportPerModuleSettings = rubySupportProvider.findRubySettings(module);
            if (rSupportPerModuleSettings == null) continue;
            return rSupportPerModuleSettings;
        }
        return RubyModuleSettings.getInstance(module);
    }

    @Nullable
    public Module getModule(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            RModuleUtil.a(3);
        }
        if ((module = (Module)dataContext.getData(LangDataKeys.MODULE.getName())) != null) {
            return module;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT.getName());
        if (project != null) {
            return this.getModuleWithRubySupport(project);
        }
        return null;
    }

    @Nullable
    public Module getModuleWithRubySupport(@NotNull Project project) {
        Module[] moduleArray;
        if (project == null) {
            RModuleUtil.a(4);
        }
        if ((moduleArray = this.getAllModulesWithRubySupport(project)).length == 1) {
            return moduleArray[0];
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return (Module)ReadAction.compute(() -> {
                if (project == null) {
                    RModuleUtil.a(8);
                }
                if (project.isDisposed()) {
                    return null;
                }
                Module module = ModuleAttachProcessor.getPrimaryModule((Project)project);
                if (this.isRubyModule(module)) {
                    return module;
                }
                return null;
            });
        }
        return null;
    }

    public boolean changeModuleSdk(@Nullable Sdk sdk, @NotNull Module module) {
        if (module == null) {
            RModuleUtil.a(5);
        }
        if (this.isRubyModule(module)) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Sdk sdk2 = moduleRootManager.getSdk();
            if (sdk2 != sdk) {
                ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
                return true;
            }
            return false;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.updateFacetSdk(module, sdk)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevelByModule(Module module) {
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getEffectiveLanguageLevel(this.findRubySdkForModule(module));
        if (languageLevel == null) {
            RModuleUtil.a(6);
        }
        return languageLevel;
    }

    public boolean isMultiProject(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.a(7);
        }
        return PlatformUtils.isRubyMine() && this.getAllModulesWithRubySupport(project).length > 1;
    }

    @Contract(value="null -> false")
    public boolean isInMultiProject(@Nullable Module module) {
        return module != null && this.isMultiProject(module.getProject());
    }

    @Nullable
    public Project getProject(@Nullable Module module) {
        return module != null ? module.getProject() : null;
    }

    @Nullable
    public Sdk findRubySdkForVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null || project == null) {
            return null;
        }
        return this.findRubySdkForModule(ScratchUtil.isScratch((VirtualFile)virtualFile) ? (Module)ContainerUtil.getFirstItem(Arrays.asList(this.getAllModulesWithRubySupport(project))) : ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project));
    }

    @Nullable
    public Sdk findRubySdkForModule(@Nullable Module module) {
        Object object;
        if (module == null || module.isDisposed()) {
            return null;
        }
        if (this.isRubyModule(module) && (object = ModuleRootManager.getInstance((Module)module).getSdk()) != null && object.getSdkType() instanceof RubySdkType) {
            return object;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            Sdk sdk = rubySupportProvider.findRubySdk(module);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    /* synthetic */ RModuleUtil(a x0) {
        this();
    }

    static {
        b = la.a(-3042561085083395229L, 7307413356563523763L, MethodHandles.lookup().lookupClass()).a(254044301841322L);
        a = Logger.getInstance(RModuleUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x4ACA9CF02F0BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelByModule";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesWithRubySupport";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFirstContentRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRubyModuleSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleWithRubySupport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeModuleSdk";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMultiProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModuleWithRubySupport$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllModulesWithRubySupport$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingletonHolder {
        private static final RModuleUtil a = new RModuleUtil(null);

        private SingletonHolder() {
        }
    }
}

