/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class RakeUtilBase {
    @NonNls
    public static final String RAKE_FILE = "Rakefile";
    @NonNls
    public static final String TASKS_SPEC_FULLCMD = "spec";
    @NonNls
    public static final String TASKS_TEST_FULLCMD = "test";
    @NonNls
    public static final String OPTIONS_TRACE = "--trace";
    @NonNls
    protected static final String RAKE_FILE_EXT = "rake";
    @NonNls
    public static final String RAKE_TASK_DESCRIPTION_SHORT_NAME = "desc";
    @NonNls
    public static final String RAKE_NAMESPACE_CLOSURE_SHORT_NAME = "namespace";
    @NonNls
    public static final String RAKE_TASK_CLOSURE_SHORT_NAME = "task";
    private static final long p = la.a(-6428256646302825611L, -8977040845815484391L, MethodHandles.lookup().lookupClass()).a(16922408146846L);

    public static boolean isRakeFileByNamingConventions(@Nullable VirtualFile file) {
        long l2 = p ^ 0x2712793BCBB2L;
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!RubyVirtualFileScanner.isRubyFile(file)) {
            return false;
        }
        String string = file.getNameWithoutExtension();
        if (string.toLowerCase().equals("rakefile")) {
            return true;
        }
        String string2 = file.getExtension();
        return string2 != null && string2.toLowerCase().equals(RAKE_FILE_EXT);
    }

    @NotNull
    public static Collection<VirtualFile> getRakeFiles(@Nullable Module module) {
        if (module == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                RakeUtilBase.a(0);
            }
            return list2;
        }
        Collection collection = Arrays.stream(ModuleRootManager.getInstance((Module)module).getContentRoots()).map(virtualFile -> {
            long l2 = p ^ 0xC1C5193D4A6L;
            return virtualFile.findChild(RAKE_FILE);
        }).filter(virtualFile -> virtualFile != null && !virtualFile.isDirectory()).collect(Collectors.toList());
        if (collection == null) {
            RakeUtilBase.a(1);
        }
        return collection;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = p ^ 0x5635B3CC9A49L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/tasks/rake/RakeUtilBase", "getRakeFiles"));
    }
}

