/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolCache;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.inline.JSFunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSVarOrFieldInliner
implements JSInlineHandler.Inliner {
    @NotNull
    private final JSVariable myElement;
    private final JSFunction myContainingFunction;
    private final MySettings mySettings;
    private final boolean myLocalVar;
    private final boolean myDependsOnContext;
    @NotNull
    private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfo;

    JSVarOrFieldInliner(@NotNull JSVariable element, MySettings settings) {
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.mySettings = settings;
        this.myLocalVar = JSVarOrFieldInliner.isLocalVariable(element);
        this.myContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        this.myDependsOnContext = JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)settings.initialized, false, false);
        this.myReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo((PsiElement)settings.initialized);
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, final @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(2);
        }
        JSVariable toInline = this.myElement;
        final PsiElement expression = reference.getElement();
        if (!JSResolveUtil.isSelfReference(expression) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess(expression) != ReadWriteAccessDetector.Access.Read && (this.mySettings.myTarget instanceof JSVariable || JSVarOrFieldInliner.referencesOurDefinition(expression, this.mySettings.myTarget))) {
            conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.used.as.lvalue", (Object[])new Object[0]));
        }
        JSFunction usageContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (this.myLocalVar && this.myDependsOnContext && this.myContainingFunction != usageContainingFunction) {
            final boolean isArrowFunction = JSPsiImplUtils.isArrowFunction(usageContainingFunction);
            JSExpression initializer = toInline.getInitializer();
            if (initializer != null) {
                initializer.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                    final Set<String> processed = new THashSet();

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        PsiElement resolve;
                        String referenced;
                        super.visitJSReferenceExpression(node);
                        if (node.getQualifier() == null && (referenced = node.getReferenceName()) != null && this.processed.add(referenced) && conflicts.size() == 0 && (resolve = node.resolve()) != null) {
                            JSFunction funScope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)resolve, JSFunction.class);
                            Object scope = funScope != null ? resolve.getUseScope() : GlobalSearchScope.fileScope((PsiFile)node.getContainingFile());
                            for (PsiReference ref : ReferencesSearch.search((PsiElement)resolve, (SearchScope)scope).findAll()) {
                                if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref.getElement()) == ReadWriteAccessDetector.Access.Read) continue;
                                conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                            }
                        }
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        super.visitJSThisExpression(node);
                        if (!isArrowFunction) {
                            conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                        }
                    }
                });
            }
        }
        JSInlineHandler.checkES6ModuleConflicts(this.myReferenceExpressionsInfo, (JSQualifiedNamedElement)toInline, ES6PsiUtil.findExternalModule(reference.getElement()), conflicts);
        JSRefactoringConflictsUtil.checkClassMemberAccessibilityConflicts(reference, (JSAttributeListOwner)toInline, JSVisibilityUtil.DEFAULT_OPTIONS, conflicts);
    }

    @Override
    @Nullable
    public PsiElement inlineUsage(@NotNull UsageInfo usage) {
        JSExpression result2;
        JSReferenceExpression usageElement;
        if (usage == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(3);
        }
        if ((usageElement = (JSReferenceExpression)ObjectUtils.tryCast((Object)usage.getElement(), JSReferenceExpression.class)) == null) {
            return null;
        }
        if (this.mySettings.myTarget instanceof JSDefinitionExpression && !JSVarOrFieldInliner.referencesOurDefinition((PsiElement)usageElement, this.mySettings.myTarget) || usageElement.getParent() == this.myElement) {
            return null;
        }
        JSExpression initializer = this.mySettings.initialized;
        PsiElement usageModule = ES6PsiUtil.findExternalModule((PsiElement)usageElement);
        JSExpression qualifier = usageElement.getQualifier();
        String s = JSFunctionInliner.buildReplacement((PsiElement)initializer, (JSExpression)usageElement, Collections.emptyMap(), qualifier);
        PsiElement parent = usageElement.getParent();
        if (parent instanceof ES6Property && ((ES6Property)parent).isShorthanded()) {
            String objectLiteralText = "{ " + usageElement.getReferenceName() + ": " + s + "}";
            PsiElement objectLiteral = JSInheritedLanguagesHelper.createExpressionFromText(objectLiteralText, (PsiElement)initializer);
            JSProperty property = ((JSObjectLiteralExpression)objectLiteral).getFirstProperty();
            assert (property != null);
            result2 = parent.replace((PsiElement)property);
        } else {
            JSExpression replacementExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(s, (PsiElement)initializer);
            replacementExpression = JSFunctionInliner.removeRedundantAwaitExpressions(replacementExpression, (PsiElement)usageElement);
            result2 = JSChangeUtil.replaceExpression((JSExpression)usageElement, replacementExpression);
        }
        this.mySettings.addRangeHighlighterForPsiElement((PsiElement)result2);
        if (usageModule != null) {
            ES6CreateImportUtil.addRequiredImports(this.myReferenceExpressionsInfo, usageModule);
        }
        return result2;
    }

    private static boolean referencesOurDefinition(PsiElement usageElement, PsiElement target) {
        return JSVarOrFieldInliner.findDefinition(usageElement) == target;
    }

    private static PsiElement findDefinition(PsiElement usageElement) {
        if (usageElement instanceof JSReferenceExpression) {
            PsiElement usageElementParent = usageElement.getParent();
            String referencedName = ((JSReferenceExpression)usageElement).getReferenceName();
            if (usageElementParent instanceof JSNamedElement || referencedName == null) {
                return null;
            }
            SinkResolveProcessor<ResolveResultSink> p = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            p.setLocalResolve(true);
            JSResolveUtil.treeWalkUp(p, usageElement, usageElementParent, usageElement);
            return p.getResult();
        }
        return null;
    }

    static boolean isLocalVariable(JSVariable jsVariable) {
        return !(jsVariable instanceof JSParameter) && jsVariable.getUseScope() instanceof LocalSearchScope;
    }

    @Nullable
    public static MySettings handleVariable(JSVariable element, @Nullable Editor editor, @Nullable PsiReference invocationReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean isInvokedOnReference) {
        String problemKey;
        if (element.getInitializer() != null) {
            return new MySettings(element, (PsiElement)element, deferredUsages, isInvokedOnReference, editor);
        }
        if (invocationReference != null) {
            JSDefinitionExpression expr = null;
            if (invocationReference instanceof JSReferenceExpression) {
                PsiElement grandParent;
                PsiElement parent = invocationReference.getElement().getParent();
                if (!(parent instanceof JSDefinitionExpression)) {
                    parent = JSVarOrFieldInliner.findDefinition((PsiElement)((JSReferenceExpression)invocationReference));
                }
                if (parent instanceof JSDefinitionExpression && (grandParent = parent.getParent()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getROperand() != null) {
                    expr = (JSDefinitionExpression)parent;
                }
            }
            if (expr != null) {
                boolean foundDefinitionUsages = false;
                for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                    if (!(ref instanceof JSReferenceExpression) || !JSVarOrFieldInliner.referencesOurDefinition((PsiElement)ref, (PsiElement)expr)) continue;
                    foundDefinitionUsages = true;
                    break;
                }
                if (foundDefinitionUsages) {
                    return new MySettings(element, (PsiElement)expr, deferredUsages, true, editor);
                }
                problemKey = "javascript.refactoring.cannot.find.usages.of.definition.to.inline";
            } else {
                problemKey = "javascript.refactoring.cannot.find.definition.to.inline";
            }
        } else {
            problemKey = "javascript.refactoring.cannot.not.inline.noninitialized.definition";
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JSBundle.message((String)problemKey, (Object[])new Object[0]), (String)JSBundle.message((String)"javascript.refactoring.inline.variable.title", (Object[])new Object[0]), (String)"refactoring.inlineVariable");
        return null;
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        boolean b;
        JSExpressionStatement expressionStatement;
        PsiElement toRemove;
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(4);
        }
        if ((toRemove = this.mySettings.myTarget) instanceof JSDefinitionExpression && (expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)toRemove, JSExpressionStatement.class)) != null) {
            toRemove = expressionStatement;
        }
        JSInlineHandler.deleteElementWithReformat(toRemove);
        if (element instanceof JSNamedElement && toRemove != element && (b = JSUnusedGlobalSymbolCache.calcUnused(element))) {
            JSInlineHandler.deleteElementWithReformat(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConflicts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MySettings
    extends JSInlineHandler.Settings {
        private final PsiElement myTarget;
        private JSExpression initialized;

        MySettings(JSVariable variable, PsiElement target, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean invokedOnReference, @Nullable Editor editor) {
            super((PsiElement)variable, deferredUsages, invokedOnReference, editor);
            this.myTarget = target;
            if (target instanceof JSVariable) {
                this.initialized = ((JSVariable)target).getInitializer();
            } else if (target instanceof JSDefinitionExpression) {
                this.initialized = ((JSAssignmentExpression)target.getParent()).getROperand();
            }
            assert (this.initialized != null);
        }

        @Override
        public void highlightUsages(Editor editor, Collection<PsiReference> refs) {
            ArrayList<PsiElement> refsToHighlight = new ArrayList<PsiElement>();
            boolean referencingDef = this.myTarget instanceof JSDefinitionExpression;
            for (PsiReference ref : refs) {
                if (referencingDef && !JSVarOrFieldInliner.referencesOurDefinition((PsiElement)ref, this.myTarget)) continue;
                refsToHighlight.add(ref.getElement());
            }
            Project project = editor.getProject();
            HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(PsiUtilCore.toPsiElementArray(refsToHighlight)), false);
            if (Comparing.equal((Object)JSInlineHandler.getPhysicalFileOfEditor(editor), (Object)JSInlineHandler.getVirtualFile(this.myTarget.getContainingFile()))) {
                HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(new PsiElement[]{this.myTarget instanceof JSVariable ? ((JSVariable)this.myTarget).getNameIdentifier() : this.myTarget}), true);
            }
            HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        }
    }
}

