/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inject.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.plugins.intelliLang.inject.JSLanguageInjectionSupport;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDontFormatCommentInjectionAction
extends JavaScriptIntention {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inject.dont.format.intention.text", (Object[])new Object[0]);
        if (string == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Pair<JSInjection, PsiElement> pair;
        if (project == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(3);
        }
        return (pair = JSDontFormatCommentInjectionAction.getCommentInjection(editor, element)) != null && ((JSInjection)((Object)pair.first)).canReformat();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<JSInjection, PsiElement> pair;
        if (project == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(5);
        }
        if ((pair = JSDontFormatCommentInjectionAction.getCommentInjection(editor, element)) == null) {
            return;
        }
        JSInjection oldInjection = (JSInjection)((Object)pair.first);
        JSInjection newInjection = oldInjection.copy();
        newInjection.setCanReformat(false);
        ((PsiElement)pair.second).replace(JSDontFormatCommentInjectionAction.createCommentFromText(element, JSDontFormatCommentInjectionAction.getCommentText(oldInjection, element)));
        Configuration.getProjectInstance((Project)project).replaceInjectionsWithUndo(project, element.getContainingFile(), ContainerUtil.list((Object[])new JSInjection[]{newInjection}), ContainerUtil.list((Object[])new JSInjection[]{oldInjection}), ContainerUtil.list((Object[])new PsiElement[0]));
    }

    @NotNull
    private static String getCommentText(@NotNull JSInjection injection, @NotNull PsiElement context) {
        if (injection == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(7);
        }
        String commentPrefix = JSCodeStyleSettings.getLineCommentPrefix(context);
        StringBuilder builder = new StringBuilder("//" + commentPrefix + "language=" + injection.getInjectedLanguageId());
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" prefix=").append(injection.getPrefix());
        }
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" suffix=").append(injection.getSuffix());
        }
        builder.append(" format=false");
        String string = builder.toString();
        if (string == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static Pair<JSInjection, PsiElement> getCommentInjection(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(9);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost injectionHost = JSDontFormatCommentInjectionAction.getInjectionHost(element);
        PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)offset);
        if (injectedPsi == null || injectionHost == null || !JSFormattableInjectionUtil.hostContainsFormattableInjection((PsiElement)injectionHost)) {
            return null;
        }
        JSLanguageInjectionSupport injectionSupport = (JSLanguageInjectionSupport)((Object)ObjectUtils.tryCast((Object)injectedPsi.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT), JSLanguageInjectionSupport.class));
        if (injectionSupport == null) {
            return null;
        }
        Ref commentRef = new Ref();
        BaseInjection injection = injectionSupport.findCommentInjection((PsiElement)injectionHost, commentRef);
        if (injection != null && !commentRef.isNull()) {
            return Pair.create((Object)injection, (Object)commentRef.get());
        }
        return null;
    }

    @Nullable
    private static PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        PsiElement stringLiteral;
        if (element == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(10);
        }
        return (stringLiteral = element.getParent()) instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)stringLiteral : null;
    }

    @NotNull
    private static PsiElement createCommentFromText(@NotNull PsiElement element, String text) {
        if (element == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(11);
        }
        ASTNode node = JSChangeUtil.createJSTreeFromText(element.getProject(), text, DialectDetector.languageDialectOfElement(element));
        PsiElement psiElement = ((ASTNode)ObjectUtils.assertNotNull((Object)node)).getPsi(PsiComment.class);
        if (psiElement == null) {
            JSDontFormatCommentInjectionAction.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/intelliLang/inject/JSDontFormatCommentInjectionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/intelliLang/inject/JSDontFormatCommentInjectionAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommentFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommentInjection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionHost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCommentFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

