/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsHolder {
    public static final String DOCKER_ACCOUNT_NAME = "DOCKER_ACCOUNT_NAME";
    public static final String DOCKER_COMPOSE_FILE_PATH = "DOCKER_COMPOSE_FILE_PATH";
    public static final String DOCKER_COMPOSE_SERVICE_NAME = "DOCKER_COMPOSE_SERVICE_NAME";
    public static final String DOCKER_REMOTE_PROJECT_PATH = "DOCKER_REMOTE_PROJECT_PATH";
    private static final String DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG = "dockerComposeConfigurationPaths";
    private static final String ITEM_TAG = "item";
    private static final String VALUE_ATTRIBUTE = "value";
    private String myAccountName;
    private List<String> myComposeFilePaths;
    private String myComposeServiceName;
    private String myRemoteProjectPath;
    @NotNull
    private EnvironmentVariablesData myEnvs = EnvironmentVariablesData.DEFAULT;

    public String getAccountName() {
        return this.myAccountName;
    }

    public void setAccountName(String accountName) {
        this.myAccountName = accountName;
    }

    public List<String> getComposeFilePaths() {
        return this.myComposeFilePaths;
    }

    public void setComposeFilePaths(List<String> composeFilePaths) {
        this.myComposeFilePaths = composeFilePaths;
    }

    public String getComposeServiceName() {
        return this.myComposeServiceName;
    }

    public void setComposeServiceName(String composeServiceName) {
        this.myComposeServiceName = composeServiceName;
    }

    public String getRemoteProjectPath() {
        return this.myRemoteProjectPath;
    }

    public void setRemoteProjectPath(String remoteProjectPath) {
        this.myRemoteProjectPath = remoteProjectPath;
    }

    @NotNull
    public EnvironmentVariablesData getEnvs() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvs;
        if (environmentVariablesData == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(0);
        }
        return environmentVariablesData;
    }

    public void setEnvs(@NotNull EnvironmentVariablesData envs) {
        if (envs == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(1);
        }
        this.myEnvs = envs;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(2);
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_ACCOUNT_NAME, this.myAccountName);
        if (this.myComposeFilePaths != null) {
            Element configurationsTag = new Element(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            for (String path : this.myComposeFilePaths) {
                Element itemElement = new Element(ITEM_TAG);
                itemElement.setAttribute(VALUE_ATTRIBUTE, path);
                configurationsTag.addContent(itemElement);
            }
            element.addContent(configurationsTag);
        }
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_COMPOSE_SERVICE_NAME, this.myComposeServiceName);
        DockerComposeCredentialsHolder.setAttribute(element, DOCKER_REMOTE_PROJECT_PATH, this.myRemoteProjectPath);
        this.myEnvs.writeExternal(element);
    }

    private static void setAttribute(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(3);
        }
        if (name == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)value)) {
            element.setAttribute(name, value);
        }
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            DockerComposeCredentialsHolder.$$$reportNull$$$0(5);
        }
        this.myAccountName = element.getAttributeValue(DOCKER_ACCOUNT_NAME);
        String composeFilePath = element.getAttributeValue(DOCKER_COMPOSE_FILE_PATH);
        this.myComposeFilePaths = new ArrayList<String>();
        if (composeFilePath != null) {
            this.myComposeFilePaths.add(composeFilePath);
        } else {
            Element configurationPathsTag = element.getChild(DOCKER_COMPOSE_CONFIGURATION_PATHS_TAG);
            if (configurationPathsTag != null) {
                for (Element item : configurationPathsTag.getChildren(ITEM_TAG)) {
                    String value = item.getAttributeValue(VALUE_ATTRIBUTE);
                    if (!StringUtil.isNotEmpty((String)value)) continue;
                    this.myComposeFilePaths.add(value);
                }
            }
        }
        this.myComposeServiceName = element.getAttributeValue(DOCKER_COMPOSE_SERVICE_NAME);
        this.myRemoteProjectPath = element.getAttributeValue(DOCKER_REMOTE_PROJECT_PATH);
        this.myEnvs = EnvironmentVariablesData.readExternal((Element)element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeCredentialsHolder holder = (DockerComposeCredentialsHolder)o;
        if (this.myAccountName != null ? !this.myAccountName.equals(holder.myAccountName) : holder.myAccountName != null) {
            return false;
        }
        if (this.myComposeFilePaths != null ? !this.myComposeFilePaths.equals(holder.myComposeFilePaths) : holder.myComposeFilePaths != null) {
            return false;
        }
        if (this.myComposeServiceName != null ? !this.myComposeServiceName.equals(holder.myComposeServiceName) : holder.myComposeServiceName != null) {
            return false;
        }
        if (this.myRemoteProjectPath != null ? !this.myRemoteProjectPath.equals(holder.myRemoteProjectPath) : holder.myRemoteProjectPath != null) {
            return false;
        }
        return this.myEnvs.equals((Object)holder.myEnvs);
    }

    public int hashCode() {
        int result = this.myAccountName != null ? this.myAccountName.hashCode() : 0;
        result = 31 * result + (this.myComposeFilePaths != null ? this.myComposeFilePaths.hashCode() : 0);
        result = 31 * result + (this.myComposeServiceName != null ? this.myComposeServiceName.hashCode() : 0);
        result = 31 * result + (this.myRemoteProjectPath != null ? this.myRemoteProjectPath.hashCode() : 0);
        result = 31 * result + this.myEnvs.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeCredentialsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

