/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gems;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.gems.GemsUmlDiagramProvider;
import com.intellij.diagram.gems.GemsUmlUtil;
import com.intellij.diagram.rails.RailsUmlNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public class GemsUmlDataModel
extends DiagramDataModel<RClass> {
    private final GemInfo myGem;
    private final Module myModule;
    private final Project myProject;
    private final List<RClass> myClasses = new ArrayList<RClass>();
    private final Map<GemInfo, Set<RClass>> myGems2ModelFiles = new HashMap<GemInfo, Set<RClass>>();
    private final Set<DiagramNode<RClass>> myNodes = new com.intellij.util.containers.hash.HashSet();
    private final Collection<DiagramEdge<RClass>> myEdges = new HashSet<DiagramEdge<RClass>>();

    public GemsUmlDataModel(Module module, GemInfo gem) {
        super(module.getProject(), GemsUmlDiagramProvider.getInstance());
        this.myGem = gem;
        this.myModule = module;
        this.myProject = module.getProject();
    }

    private void init() {
        GemsUmlUtil.addRelationInGemModelsMap(this.myGems2ModelFiles, this.myGem, this.myProject);
        Set allGems = GemManager.getAllGems((Module)this.myModule);
        Set<GemInfo> dependentGems = GemsUmlUtil.getDependentGems(this.myGem, allGems);
        for (GemInfo gem : dependentGems) {
            GemsUmlUtil.addRelationInGemModelsMap(this.myGems2ModelFiles, gem, this.myProject);
        }
        for (GemInfo gem : this.myGems2ModelFiles.keySet()) {
            this.myClasses.addAll((Collection<RClass>)this.myGems2ModelFiles.get(gem));
        }
    }

    @NotNull
    public Collection<DiagramNode<RClass>> getNodes() {
        Set<DiagramNode<RClass>> set = this.myNodes;
        if (set == null) {
            GemsUmlDataModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Collection<DiagramEdge<RClass>> getEdges() {
        Collection<DiagramEdge<RClass>> collection = this.myEdges;
        if (collection == null) {
            GemsUmlDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<RClass> node) {
        String name = node.getTooltip();
        if (name != null) {
            String string = name;
            if (string == null) {
                GemsUmlDataModel.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = new String();
        if (string == null) {
            GemsUmlDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<RClass> addElement(RClass element) {
        return null;
    }

    public void refreshDataModel() {
        this.init();
        Iterator<RClass> iterator = this.myClasses.iterator();
        while (iterator.hasNext()) {
            RClass next = iterator.next();
            if (next.isValid()) {
                this.myNodes.add((DiagramNode<RClass>)new RailsUmlNode(next));
                continue;
            }
            iterator.remove();
        }
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            GemsUmlDataModel.$$$reportNull$$$0(4);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagram/gems/GemsUmlDataModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

