/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.inspections;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

public class PathInputForm {
    private JPanel myContentPane;
    private LabeledComponent<TextFieldWithBrowseButton> myFileComponent;
    private TextFieldWithBrowseButton myFileTextField;
    private JLabel myIconLabel;
    private final String myMessage;

    public PathInputForm(@NotNull Project project, @NotNull @Nls String message, @Nullable Icon icon, VirtualFile rootFolder) {
        if (project == null) {
            PathInputForm.$$$reportNull$$$0(0);
        }
        if (message == null) {
            PathInputForm.$$$reportNull$$$0(1);
        }
        this.myMessage = message;
        this.$$$setupUI$$$();
        this.myIconLabel.setIcon(icon);
        this.myIconLabel.setText(null);
        String folderChooserDialogTitle = RBundle.message((String)"cucumber.quick.fix.create.step.folder.chooser.title");
        FileChooserDescriptor folderChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        folderChooserDescriptor.setTitle(folderChooserDialogTitle);
        folderChooserDescriptor.setRoots(new VirtualFile[]{rootFolder});
        folderChooserDescriptor.withTreeRootVisible(true);
        folderChooserDescriptor.setShowFileSystemRoots(false);
        folderChooserDescriptor.setHideIgnored(true);
        this.myFileTextField.addBrowseFolderListener(folderChooserDialogTitle, null, project, folderChooserDescriptor);
    }

    public JComponent getContent() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileTextField.getTextField();
    }

    public String getFilePath() {
        return FileUtil.toSystemIndependentName((String)this.myFileTextField.getText().trim());
    }

    public void setFilePath(String value) {
        this.myFileTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)value)));
        JTextField originalTF = this.myFileTextField.getTextField();
        originalTF.setCaretPosition(originalTF.getText().length());
    }

    private void createUIComponents() {
        this.myFileTextField = new TextFieldWithBrowseButton();
        this.myFileComponent = new LabeledComponent();
        this.myFileComponent.setComponent((JComponent)this.myFileTextField);
        this.myFileComponent.setText(this.myMessage);
    }

    public JTextField getTextField() {
        return this.myFileTextField.getTextField();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/cucumber/inspections/PathInputForm";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIconLabel = jLabel = new JLabel();
        jLabel.setText("[icon]");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent = this.myFileComponent;
        labeledComponent.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.quick.fix.create.step.file.path.msg"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(600, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

