/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.MacOsKeychainLibrary;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.SecKeychainAttribute;
import com.intellij.credentialStore.SecKeychainAttributeList;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.StringKt;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u001b\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/KeyChainCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "()V", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "Companion", "intellij.platform.credentialStore"})
public final class KeyChainCredentialStore
implements CredentialStore {
    private static final MacOsKeychainLibrary library;
    public static final Companion Companion;

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        Companion companion = Companion;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return companion.findGenericPassword(byArray2, StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null));
    }

    /*
     * Unable to fully structure code
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        block20: {
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            var4_3 = attributes.getServiceName();
            var5_4 = Charsets.UTF_8;
            v0 = var4_3;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v1 = v0.getBytes(var5_4);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).getBytes(charset)");
            serviceName = v1;
            if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
                itemRef = new PointerByReference();
                v2 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
                if (v2 != null) {
                    var6_6 = v2;
                    var7_9 = Charsets.UTF_8;
                    v3 = var6_6;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v4 = v3.getBytes(var7_9);
                    v5 = v4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).getBytes(charset)");
                } else {
                    v5 = null;
                }
                userName = v5;
                v6 = userName;
                code = KeyChainCredentialStore.library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, v6 != null ? ((String)v6).length : 0, (byte[])userName, null, null, itemRef);
                if (code == -25300 || code == -67701) {
                    return;
                }
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "find (for delete)", code);
                v7 = itemRef.getValue();
                if (v7 != null) {
                    it = var7_9 = v7;
                    com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "delete", KeyChainCredentialStore.library.SecKeychainItemDelete((Pointer)it));
                    KeyChainCredentialStore.library.CFRelease((Pointer)it);
                }
                return;
            }
            v8 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            if (v8 == null) {
                v9 = credentials;
                if (v9 == null) {
                    Intrinsics.throwNpe();
                }
                v8 = v9.getUserName();
            }
            if (v8 != null) {
                userName = v8;
                code = Charsets.UTF_8;
                v10 = userName;
                if (v10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v11 = v10.getBytes(code);
                v12 = v11;
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"(this as java.lang.String).getBytes(charset)");
            } else {
                v12 = null;
            }
            userName = v12;
            searchUserName = (byte[])(Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") != false ? userName : null);
            itemRef = new PointerByReference();
            library = KeyChainCredentialStore.library;
            com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "find (for save)", library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, searchUserName != null ? searchUserName.length : 0, searchUserName, null, null, itemRef));
            if (attributes.isPasswordMemoryOnly()) ** GOTO lbl-1000
            v13 = credentials;
            if (v13 == null) {
                Intrinsics.throwNpe();
            }
            if (v13.getPassword() == null) lbl-1000:
            // 2 sources

            {
                v14 = null;
            } else {
                v15 = credentials.getPassword();
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                v14 = v15.toByteArray(false);
            }
            password = v14;
            pointer = itemRef.getValue();
            if (pointer == null) {
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "save (new)", MacOsKeychainLibrary.DefaultImpls.SecKeychainAddGenericPassword$default(library, null, serviceName.length, serviceName, userName != null ? userName.length : 0, userName, password != null ? password.length : 0, password, null, 128, null));
            } else {
                attribute = new SecKeychainAttribute();
                attribute.tag = 1633903476;
                v16 = attribute.length = userName != null ? userName.length : 0;
                if (userName != null && (var12_16 = (var11_15 = userName)).length == 0 == false) {
                    userNamePointer = new Memory((long)userName.length);
                    userNamePointer.write(0L, userName, 0, userName.length);
                    attribute.data = (Pointer)userNamePointer;
                }
                attributeList = new SecKeychainAttributeList();
                attributeList.count = 1;
                attribute.write();
                attributeList.attr = attribute.getPointer();
                v17 = password != null ? password.length : 0;
                v18 = password;
                if (password == null) {
                    v18 = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                }
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "save (update)", library.SecKeychainItemModifyContent(pointer, (Object)attributeList, v17, v18));
                library.CFRelease(pointer);
            }
            if (password == null) break block20;
            ArraysKt.fill$default((byte[])password, (byte)0, (int)0, (int)0, (int)6, null);
        }
    }

    static {
        Companion = new Companion(null);
        library = (MacOsKeychainLibrary)Native.loadLibrary((String)"Security", MacOsKeychainLibrary.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/credentialStore/KeyChainCredentialStore$Companion;", "", "()V", "library", "Lcom/intellij/credentialStore/MacOsKeychainLibrary;", "kotlin.jvm.PlatformType", "checkForError", "", "message", "", "code", "findGenericPassword", "Lcom/intellij/credentialStore/Credentials;", "serviceName", "", "accountName", "intellij.platform.credentialStore"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Credentials findGenericPassword(byte[] serviceName, String accountName) {
            byte[] byArray;
            String string = accountName;
            if (string != null) {
                String string2 = string;
                Charset charset = Charsets.UTF_8;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            } else {
                byArray = null;
            }
            byte[] accountNameBytes = byArray;
            int[] passwordSize = new int[1];
            PointerByReference passwordRef = new PointerByReference();
            PointerByReference itemRef = new PointerByReference();
            int errorCode = this.checkForError("find", library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountNameBytes != null ? accountNameBytes.length : 0, accountNameBytes, passwordSize, passwordRef, itemRef));
            if (errorCode == -128) {
                return CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED();
            }
            Pointer pointer = passwordRef.getValue();
            if (pointer == null) {
                return null;
            }
            Pointer pointer2 = pointer;
            byte[] byArray3 = pointer2.getByteArray(0L, passwordSize[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"pointer.getByteArray(0, passwordSize.get(0))");
            OneTimeString password = CredentialAttributesKt.OneTimeString$default((byte[])byArray3, (int)0, (int)0, (boolean)false, (int)14, null);
            library.SecKeychainItemFreeContent(null, pointer2);
            String effectiveAccountName = accountName;
            if (effectiveAccountName == null) {
                PointerByReference attributes = new PointerByReference();
                MacOsKeychainLibrary macOsKeychainLibrary = library;
                Pointer pointer3 = itemRef.getValue();
                if (pointer3 == null) {
                    Intrinsics.throwNpe();
                }
                this.checkForError("SecKeychainItemCopyAttributesAndData", macOsKeychainLibrary.SecKeychainItemCopyAttributesAndData(pointer3, MacOsKeychainLibraryKt.access$SecKeychainAttributeInfo(1633903476), null, attributes, null, null));
                Pointer pointer4 = attributes.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pointer4, (String)"attributes.value");
                SecKeychainAttributeList attributeList = new SecKeychainAttributeList(pointer4);
                try {
                    attributeList.read();
                    effectiveAccountName = (String)MacOsKeychainLibraryKt.access$readAttributes(attributeList).get(1633903476);
                }
                finally {
                    library.SecKeychainItemFreeAttributesAndData(attributeList, null);
                }
            }
            return new Credentials(effectiveAccountName, password);
        }

        /*
         * WARNING - void declaration
         */
        private final int checkForError(String message, int code) {
            if (code == 0 || code == -25300) {
                return code;
            }
            Pointer translated = library.SecCopyErrorMessageString(code, null);
            StringBuilder builder2 = new StringBuilder(message).append(": ");
            if (translated == null) {
                builder2.append(code);
            } else {
                char[] buf = new char[(int)library.CFStringGetLength(translated)];
                int n = 0;
                int n2 = buf.length;
                while (n < n2) {
                    void i;
                    buf[i] = library.CFStringGetCharacterAtIndex(translated, (long)i);
                    ++i;
                }
                library.CFRelease(translated);
                builder2.append(buf).append(" (").append(code).append(')');
            }
            if (code == -25293 || code == -128 || code == -25299) {
                CredentialStoreKt.getLOG().warn(builder2.toString());
            } else {
                CredentialStoreKt.getLOG().error(builder2.toString());
            }
            return code;
        }

        private Companion() {
        }

        public static final /* synthetic */ int access$checkForError(Companion $this, @NotNull String message, int code) {
            return $this.checkForError(message, code);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

