/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateInfoKt;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\nH\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010(\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\f\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "blogPost", "", "getBlogPost", "()Ljava/lang/String;", "buttons", "", "Lcom/intellij/openapi/updateSettings/impl/ButtonInfo;", "getButtons", "()Ljava/util/List;", "downloadUrl", "getDownloadUrl", "message", "getMessage", "number", "getNumber", "patches", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "getPatches", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "target", "Lcom/intellij/openapi/util/BuildRange;", "getTarget", "()Lcom/intellij/openapi/util/BuildRange;", "version", "getVersion", "parseBuildNumber", "value", "parseDate", "toString", "intellij.platform.ide.impl"})
public final class BuildInfo {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final String blogPost;
    @Nullable
    private final Date releaseDate;
    @Nullable
    private final BuildRange target;
    @NotNull
    private final List<ButtonInfo> buttons;
    @NotNull
    private final List<PatchInfo> patches;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getBlogPost() {
        return this.blogPost;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final BuildRange getTarget() {
        return this.target;
    }

    @NotNull
    public final List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    @NotNull
    public final List<PatchInfo> getPatches() {
        return this.patches;
    }

    private final BuildNumber parseBuildNumber(String value) {
        BuildNumber buildNumber;
        BuildNumber buildNumber2 = buildNumber = BuildNumber.fromString((String)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber2, (String)"buildNumber");
        String string = buildNumber2.getProductCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildNumber.productCode");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            BuildNumber buildNumber3 = applicationInfoEx.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber3, (String)"ApplicationInfoImpl.getShadowInstance().build");
            int[] nArray = buildNumber.getComponents();
            buildNumber = new BuildNumber(buildNumber3.getProductCode(), Arrays.copyOf(nArray, nArray.length));
        }
        return buildNumber;
    }

    private final Date parseDate(String value) {
        Date date;
        if (value == null) {
            date = null;
        } else {
            Date date2;
            try {
                date2 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(value);
            }
            catch (ParseException e) {
                Logger.getInstance(BuildInfo.class).info("invalid build release date: " + value);
                date2 = null;
            }
            date = date2;
        }
        return date;
    }

    @Nullable
    public final String getDownloadUrl() {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.buttons;
            for (Object t : iterable2) {
                Object receiver = t;
                if (!((ButtonInfo)receiver).isDownload()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ButtonInfo buttonInfo = v0;
        return buttonInfo != null ? buttonInfo.getUrl() : null;
    }

    @NotNull
    public String toString() {
        return this.number + '/' + this.version;
    }

    public BuildInfo(@NotNull Element node) {
        Object object;
        Element p1;
        Collection<Object> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object object2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.number = this.parseBuildNumber(UpdateInfoKt.access$getMandatoryAttributeValue(node, "fullNumber", "number"));
        BuildNumber buildNumber = BuildNumber.fromStringWithProductCode((String)node.getAttributeValue("apiVersion"), (String)this.number.getProductCode());
        if (buildNumber == null) {
            buildNumber = this.apiVersion = this.number;
        }
        if ((string = node.getAttributeValue("version")) == null) {
            string = this.version = "";
        }
        if ((object2 = node.getChild("message")) == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        this.message = object2;
        Element element = node.getChild("blogPost");
        this.blogPost = element != null ? element.getAttributeValue("url") : null;
        this.releaseDate = this.parseDate(node.getAttributeValue("releaseDate"));
        this.target = BuildRange.fromStrings((String)node.getAttributeValue("targetSince"), (String)node.getAttributeValue("targetUntil"));
        List list2 = node.getChildren("button");
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"node.getChildren(\"button\")");
        Iterable iterable = list2;
        BuildInfo buildInfo = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Element element2 = (Element)item$iv$iv;
            collection = destination$iv$iv;
            object = new ButtonInfo(p1);
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        buildInfo.buttons = collection;
        List list3 = node.getChildren("patch");
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"node.getChildren(\"patch\")");
        $receiver$iv = list3;
        buildInfo = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            p1 = (Element)item$iv$iv;
            collection = destination$iv$iv;
            object = new PatchInfo(p1);
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        buildInfo.patches = collection;
    }
}

