/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J?\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2'\u0010\u001d\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J9\u0010\"\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J\u001c\u0010%\u001a\u00020&2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010'\u001a\u00020\u0014J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/tools/util/text/LineOffsets;)V", "getHandler", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "getLineOffsets1", "()Lcom/intellij/diff/tools/util/text/LineOffsets;", "getLineOffsets2", "getText1", "()Ljava/lang/CharSequence;", "getText2", "isWhitespaceOnlySeparated", "", "block1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "block2", "mergeBlocks", "processMergeableGroups", "", "blocks", "", "processGroup", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "group", "processMergedBlocks", "processBlock", "merged", "refresh", "Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "fastRefresh", "refreshBlock", "block", "Result", "intellij.platform.diff.impl"})
final class BlocksRefresher {
    @NotNull
    private final DocumentTracker.Handler handler;
    @NotNull
    private final CharSequence text1;
    @NotNull
    private final CharSequence text2;
    @NotNull
    private final LineOffsets lineOffsets1;
    @NotNull
    private final LineOffsets lineOffsets2;

    @NotNull
    public final Result refresh(@NotNull List<DocumentTracker.Block> blocks, boolean fastRefresh) {
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        ArrayList newBlocks = new ArrayList();
        this.processMergeableGroups(blocks, (Function1<? super List<DocumentTracker.Block>, Unit>)((Function1)new Function1<List<? extends DocumentTracker.Block>, Unit>(this, fastRefresh, newBlocks){
            final /* synthetic */ BlocksRefresher this$0;
            final /* synthetic */ boolean $fastRefresh;
            final /* synthetic */ ArrayList $newBlocks;

            public final void invoke(@NotNull List<DocumentTracker.Block> group) {
                boolean bl;
                block5: {
                    Intrinsics.checkParameterIsNotNull(group, (String)"group");
                    Iterable $receiver$iv = group;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                            if (!it.isDirty$intellij_platform_diff_impl()) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    BlocksRefresher.access$processMergedBlocks(this.this$0, group, (Function1)new Function1<DocumentTracker.Block, Unit>(this){
                        final /* synthetic */ refresh.1 this$0;

                        public final void invoke(@NotNull DocumentTracker.Block mergedBlock) {
                            Intrinsics.checkParameterIsNotNull((Object)mergedBlock, (String)"mergedBlock");
                            List freshBlocks = BlocksRefresher.access$refreshBlock(this.this$0.this$0, mergedBlock, this.this$0.$fastRefresh);
                            this.this$0.this$0.getHandler().onRangeRefreshed(mergedBlock, freshBlocks);
                            this.this$0.$newBlocks.addAll(freshBlocks);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                } else {
                    this.$newBlocks.addAll((Collection)group);
                }
            }
            {
                this.this$0 = blocksRefresher;
                this.$fastRefresh = bl;
                this.$newBlocks = arrayList;
                super(1);
            }
        }));
        return new Result(newBlocks);
    }

    private final void processMergeableGroups(List<DocumentTracker.Block> blocks, Function1<? super List<DocumentTracker.Block>, Unit> processGroup) {
        int i;
        if (blocks.isEmpty()) {
            return;
        }
        int blockStart = 0;
        for (i = 0; i < blocks.size() - 1; ++i) {
            if (this.isWhitespaceOnlySeparated(blocks.get(i), blocks.get(i + 1))) continue;
            processGroup.invoke(blocks.subList(blockStart, i + 1));
            blockStart = i + 1;
        }
        processGroup.invoke(blocks.subList(blockStart, i + 1));
    }

    private final boolean isWhitespaceOnlySeparated(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        TextRange textRange = DiffUtil.getLinesRange(this.lineOffsets1, block1.getRange().start1, block1.getRange().end1, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"DiffUtil.getLinesRange(l\u2026block1.range.end1, false)");
        TextRange range1 = textRange;
        TextRange textRange2 = DiffUtil.getLinesRange(this.lineOffsets1, block2.getRange().start1, block2.getRange().end1, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"DiffUtil.getLinesRange(l\u2026block2.range.end1, false)");
        TextRange range2 = textRange2;
        int start2 = range1.getEndOffset();
        int end = range2.getStartOffset();
        return TrimUtil.trimStart(this.text1, start2, end) == end;
    }

    private final void processMergedBlocks(List<DocumentTracker.Block> group, Function1<? super DocumentTracker.Block, Unit> processBlock) {
        boolean bl;
        boolean bl2 = bl = !group.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DocumentTracker.Block merged = null;
        for (DocumentTracker.Block block : group) {
            if (merged == null) {
                merged = block;
                continue;
            }
            DocumentTracker.Block newMerged = this.mergeBlocks(merged, block);
            if (newMerged != null) {
                merged = newMerged;
                continue;
            }
            processBlock.invoke((Object)merged);
            merged = block;
        }
        DocumentTracker.Block block = merged;
        if (block == null) {
            Intrinsics.throwNpe();
        }
        processBlock.invoke((Object)block);
    }

    private final DocumentTracker.Block mergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        boolean isTooBig;
        Range range2 = new Range(block1.getRange().start1, block2.getRange().end1, block1.getRange().start2, block2.getRange().end2);
        boolean isDirty = block1.isDirty$intellij_platform_diff_impl() || block2.isDirty$intellij_platform_diff_impl();
        DocumentTracker.Block merged = new DocumentTracker.Block(range2, isDirty, isTooBig = block1.isTooBig$intellij_platform_diff_impl() || block2.isTooBig$intellij_platform_diff_impl());
        if (!this.handler.onRangesMerged(block1, block2, merged)) {
            return null;
        }
        return merged;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshBlock(DocumentTracker.Block block, boolean fastRefresh) {
        void $receiver$iv$iv;
        Iterable<Range> $receiver$iv;
        boolean isTooBig;
        FairDiffIterable iterable;
        if (block.getRange().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (block.isTooBig$intellij_platform_diff_impl() && fastRefresh) {
            iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            isTooBig = true;
        } else {
            FairDiffIterable realIterable = RangesBuilder.tryCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            if (realIterable != null) {
                iterable = realIterable;
                isTooBig = false;
            } else {
                iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
                isTooBig = true;
            }
        }
        Iterable<Range> iterable2 = iterable.iterateChanges();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"iterable.iterateChanges()");
        Iterable<Range> iterable3 = $receiver$iv = iterable2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            DocumentTracker.Block block2 = new DocumentTracker.Block(DocumentTrackerKt.access$shiftRange((Range)v1, block.getRange().start1, block.getRange().start2), false, isTooBig);
            collection.add(block2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DocumentTracker.Handler getHandler() {
        return this.handler;
    }

    @NotNull
    public final CharSequence getText1() {
        return this.text1;
    }

    @NotNull
    public final CharSequence getText2() {
        return this.text2;
    }

    @NotNull
    public final LineOffsets getLineOffsets1() {
        return this.lineOffsets1;
    }

    @NotNull
    public final LineOffsets getLineOffsets2() {
        return this.lineOffsets2;
    }

    public BlocksRefresher(@NotNull DocumentTracker.Handler handler2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2) {
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text2");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets2, (String)"lineOffsets2");
        this.handler = handler2;
        this.text1 = text1;
        this.text2 = text2;
        this.lineOffsets1 = lineOffsets1;
        this.lineOffsets2 = lineOffsets2;
    }

    public static final /* synthetic */ void access$processMergedBlocks(BlocksRefresher $this, @NotNull List group, @NotNull Function1 processBlock) {
        $this.processMergedBlocks(group, (Function1<? super DocumentTracker.Block, Unit>)processBlock);
    }

    @NotNull
    public static final /* synthetic */ List access$refreshBlock(BlocksRefresher $this, @NotNull DocumentTracker.Block block, boolean fastRefresh) {
        return $this.refreshBlock(block, fastRefresh);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "", "newBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "(Ljava/util/List;)V", "getNewBlocks", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class Result {
        @NotNull
        private final List<DocumentTracker.Block> newBlocks;

        @NotNull
        public final List<DocumentTracker.Block> getNewBlocks() {
            return this.newBlocks;
        }

        public Result(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkParameterIsNotNull(newBlocks, (String)"newBlocks");
            this.newBlocks = newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.newBlocks;
        }

        @NotNull
        public final Result copy(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkParameterIsNotNull(newBlocks, (String)"newBlocks");
            return new Result(newBlocks);
        }

        @NotNull
        public static /* synthetic */ Result copy$default(Result result2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.newBlocks;
            }
            return result2.copy(list2);
        }

        @NotNull
        public String toString() {
            return "Result(newBlocks=" + this.newBlocks + ")";
        }

        public int hashCode() {
            List<DocumentTracker.Block> list2 = this.newBlocks;
            return list2 != null ? ((Object)list2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual(this.newBlocks, result2.newBlocks)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

