/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CanonicalPathMap {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    private final List<String> myRecursiveWatchRoots;
    private final List<String> myFlatWatchRoots;
    private final List<String> myCanonicalRecursiveWatchRoots;
    private final List<String> myCanonicalFlatWatchRoots;
    private final MultiMap<String, String> myPathMapping;

    CanonicalPathMap() {
        this.myCanonicalFlatWatchRoots = Collections.emptyList();
        this.myFlatWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myCanonicalRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myPathMapping = MultiMap.empty();
    }

    CanonicalPathMap(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            CanonicalPathMap.$$$reportNull$$$0(0);
        }
        if (flat == null) {
            CanonicalPathMap.$$$reportNull$$$0(1);
        }
        this.myRecursiveWatchRoots = ContainerUtil.newArrayList(recursive);
        this.myFlatWatchRoots = ContainerUtil.newArrayList(flat);
        List mapping = ContainerUtil.newSmartList();
        Map<String, String> resolvedPaths = CanonicalPathMap.resolvePaths(recursive, flat);
        this.myCanonicalRecursiveWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, recursive, mapping);
        this.myCanonicalFlatWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, flat, mapping);
        this.myPathMapping = MultiMap.createConcurrentSet();
        this.addMapping(mapping);
    }

    @NotNull
    private static Map<String, String> resolvePaths(@NotNull Collection<String> recursiveRoots, @NotNull Collection<String> flatRoots) {
        if (recursiveRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(2);
        }
        if (flatRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(3);
        }
        ConcurrentMap result2 = ContainerUtil.newConcurrentMap();
        ((Stream)Stream.concat(recursiveRoots.stream(), flatRoots.stream()).parallel()).forEach(root -> ContainerUtil.putIfNotNull((Object)root, (Object)FileSystemUtil.resolveSymLink((String)root), (Map)result2));
        ConcurrentMap concurrentMap = result2;
        if (concurrentMap == null) {
            CanonicalPathMap.$$$reportNull$$$0(4);
        }
        return concurrentMap;
    }

    @NotNull
    private static List<String> mapPaths(@NotNull Map<String, String> resolvedPaths, @NotNull List<String> paths, @NotNull Collection<? super Pair<String, String>> mapping) {
        if (resolvedPaths == null) {
            CanonicalPathMap.$$$reportNull$$$0(5);
        }
        if (paths == null) {
            CanonicalPathMap.$$$reportNull$$$0(6);
        }
        if (mapping == null) {
            CanonicalPathMap.$$$reportNull$$$0(7);
        }
        ArrayList canonicalPaths = ContainerUtil.newArrayList(paths);
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            String canonicalPath = resolvedPaths.get(path);
            if (canonicalPath == null || path.equals(canonicalPath)) continue;
            canonicalPaths.set(i, canonicalPath);
            mapping.add((Pair<String, String>)Pair.create((Object)canonicalPath, (Object)path));
        }
        ArrayList arrayList = canonicalPaths;
        if (arrayList == null) {
            CanonicalPathMap.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    List<String> getCanonicalRecursiveWatchRoots() {
        List<String> list2 = this.myCanonicalRecursiveWatchRoots;
        if (list2 == null) {
            CanonicalPathMap.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    List<String> getCanonicalFlatWatchRoots() {
        List<String> list2 = this.myCanonicalFlatWatchRoots;
        if (list2 == null) {
            CanonicalPathMap.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public void addMapping(@NotNull Collection<? extends Pair<String, String>> mapping) {
        if (mapping == null) {
            CanonicalPathMap.$$$reportNull$$$0(11);
        }
        for (Pair<String, String> pair : mapping) {
            Collection preRemapPathToWatchedPaths = this.myPathMapping.get(pair.second);
            for (String realWatchedPath : preRemapPathToWatchedPaths) {
                Collection remappedPathMappings = this.myPathMapping.getModifiable(pair.first);
                remappedPathMappings.add(realWatchedPath);
            }
            Collection symLinksToCanonicalPath = this.myPathMapping.getModifiable(pair.first);
            symLinksToCanonicalPath.add(pair.second);
        }
    }

    @NotNull
    Collection<String> getWatchedPaths(@NotNull String reportedPath, boolean isExact) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(12);
        }
        if (this.myFlatWatchRoots.isEmpty() && this.myRecursiveWatchRoots.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CanonicalPathMap.$$$reportNull$$$0(13);
            }
            return list2;
        }
        Collection<String> affectedPaths = this.applyMapping(reportedPath);
        List changedPaths = ContainerUtil.newSmartList();
        block0: for (String path : affectedPaths) {
            for (String root : this.myFlatWatchRoots) {
                if (FileUtil.namesEqual((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact) {
                    if (!CanonicalPathMap.isApproxParent(path, root)) continue;
                    changedPaths.add(path);
                    continue block0;
                }
                if (!CanonicalPathMap.isApproxParent(root, path)) continue;
                changedPaths.add(root);
            }
            for (String root : this.myRecursiveWatchRoots) {
                if (FileUtil.startsWith((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact || !CanonicalPathMap.isApproxParent(root, path)) continue;
                changedPaths.add(root);
            }
        }
        if (changedPaths.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("Not watchable, filtered: " + reportedPath);
        }
        List list3 = changedPaths;
        if (list3 == null) {
            CanonicalPathMap.$$$reportNull$$$0(14);
        }
        return list3;
    }

    private static boolean isApproxParent(@NotNull String path, @NotNull String parent) {
        if (path == null) {
            CanonicalPathMap.$$$reportNull$$$0(15);
        }
        if (parent == null) {
            CanonicalPathMap.$$$reportNull$$$0(16);
        }
        return path.lastIndexOf(File.separatorChar) == parent.length() && FileUtil.startsWith((String)path, (String)parent);
    }

    @NotNull
    private Collection<String> applyMapping(@NotNull String reportedPath) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(17);
        }
        if (this.myPathMapping.isEmpty()) {
            List<String> list2 = Collections.singletonList(reportedPath);
            if (list2 == null) {
                CanonicalPathMap.$$$reportNull$$$0(18);
            }
            return list2;
        }
        List results = ContainerUtil.newSmartList((Object)reportedPath);
        List pathComponents = FileUtil.splitPath((String)reportedPath);
        File runningPath = null;
        for (int i = 0; i < pathComponents.size(); ++i) {
            String currentPathComponent = (String)pathComponents.get(i);
            runningPath = runningPath == null ? new File(currentPathComponent.isEmpty() ? "/" : currentPathComponent) : new File(runningPath, currentPathComponent);
            Collection mappedPaths = this.myPathMapping.get((Object)runningPath.getPath());
            for (String mappedPath : mappedPaths) {
                String fileSuffix = StringUtil.join(pathComponents.subList(i + 1, pathComponents.size()), (String)File.separator);
                results.add(new File(mappedPath, fileSuffix).getPath());
            }
        }
        List list3 = results;
        if (list3 == null) {
            CanonicalPathMap.$$$reportNull$$$0(19);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRoots";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPaths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalRecursiveWatchRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalFlatWatchRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchedPaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "applyMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolvePaths";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWatchedPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isApproxParent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

