/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.remote.RemoteCredentialException;
import java.net.NoRouteToHostException;

public class RemoteSdkException
extends ExecutionException {
    private final boolean myNoRouteToHost;
    private final boolean myAuthFailed;
    private Throwable myCause;

    public RemoteSdkException(String s, Throwable throwable) {
        super(s, throwable);
        this.myAuthFailed = false;
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof NoRouteToHostException)) continue;
            this.myCause = t;
            this.myNoRouteToHost = true;
            return;
        }
        this.myNoRouteToHost = false;
        this.myCause = throwable;
    }

    public RemoteSdkException(String s) {
        super(s);
        this.myAuthFailed = false;
        this.myNoRouteToHost = false;
    }

    public boolean isNoRouteToHost() {
        return this.myNoRouteToHost;
    }

    public boolean isAuthFailed() {
        return this.myAuthFailed;
    }

    public String getMessage() {
        if (this.myNoRouteToHost) {
            return this.myCause.getMessage();
        }
        if (this.myAuthFailed) {
            return "Authentication failed";
        }
        return super.getMessage();
    }

    public static RemoteSdkException cantObtainRemoteCredentials(Throwable e) {
        if (e.getCause() instanceof RemoteCredentialException) {
            return new RemoteSdkException("Cant obtain remote credentials", e);
        }
        return new RemoteSdkException(e.getMessage(), e);
    }
}

