/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsFullCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    public static final String USERS = "users";
    public static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    public VcsLogUserIndex(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry, @NotNull FatalErrorHandler consumer, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(0);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            VcsLogUserIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(3);
        }
        super(storageId, USERS, new UserIndexer(VcsLogUserIndex.createUsersEnumerator(storageId, userRegistry)), VoidDataExternalizer.INSTANCE, consumer, disposableParent);
        this.myUserIndexer = (UserIndexer)this.myIndexer;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (consumer == null) {
                VcsLogUserIndex.$$$reportNull$$$0(11);
            }
            consumer.consume(this, (Throwable)e);
        }));
    }

    @Override
    @NotNull
    protected ForwardIndex<Integer, Void> createForwardIndex(@NotNull IndexExtension<Integer, Void, VcsFullCommitDetails> extension) throws IOException {
        if (extension == null) {
            VcsLogUserIndex.$$$reportNull$$$0(4);
        }
        KeyCollectionBasedForwardIndex<Integer, Void> keyCollectionBasedForwardIndex = new KeyCollectionBasedForwardIndex<Integer, Void>(extension){

            @NotNull
            public PersistentHashMap<Integer, Collection<Integer>> createMap() throws IOException {
                File storageFile = VcsLogUserIndex.this.myStorageId.getStorageFile(VcsLogUserIndex.this.myName + ".idx");
                PersistentHashMap persistentHashMap = new PersistentHashMap(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new IntCollectionDataExternalizer(), Page.PAGE_SIZE);
                if (persistentHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return persistentHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogUserIndex$1", "createMap"));
            }
        };
        if (keyCollectionBasedForwardIndex == null) {
            VcsLogUserIndex.$$$reportNull$$$0(5);
        }
        return keyCollectionBasedForwardIndex;
    }

    @NotNull
    private static PersistentEnumeratorBase<VcsUser> createUsersEnumerator(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(6);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(7);
        }
        File storageFile = storageId.getStorageFile(USERS_IDS);
        PersistentBTreeEnumerator persistentBTreeEnumerator = new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), Page.PAGE_SIZE, null, storageId.getVersion());
        if (persistentBTreeEnumerator == null) {
            VcsLogUserIndex.$$$reportNull$$$0(8);
        }
        return persistentBTreeEnumerator;
    }

    public TIntHashSet getCommitsForUsers(@NotNull Set<VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            VcsLogUserIndex.$$$reportNull$$$0(9);
        }
        HashSet ids = ContainerUtil.newHashSet();
        for (VcsUser user : users) {
            ids.add(this.myUserIndexer.getUserId(user));
        }
        return this.getCommitsWithAnyKey(ids);
    }

    @Nullable
    public VcsUser getAuthorForCommit(int commit) throws IOException {
        Collection userIds = (Collection)this.getKeysForCommit(commit);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        LOG.assertTrue(userIds.size() == 1);
        return this.myUserIndexer.getUserById((Integer)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)userIds)));
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        if (user == null) {
            VcsLogUserIndex.$$$reportNull$$$0(10);
        }
        return this.myUserIndexer.getUserId(user);
    }

    @Nullable
    public VcsUser getUserById(int id) throws IOException {
        return this.myUserIndexer.getUserById(id);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myUserIndexer.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERS;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createForwardIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsersEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndex";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUsersEnumerator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsForUsers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<VcsUser> myUserEnumerator;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        UserIndexer(@NotNull PersistentEnumeratorBase<VcsUser> userEnumerator) {
            if (userEnumerator == null) {
                UserIndexer.$$$reportNull$$$0(0);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myUserEnumerator = userEnumerator;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                UserIndexer.$$$reportNull$$$0(1);
            }
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                UserIndexer.$$$reportNull$$$0(2);
            }
            return tHashMap;
        }

        @Nullable
        public VcsUser getUserById(int id) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id);
        }

        public int getUserId(@NotNull VcsUser user) throws IOException {
            if (user == null) {
                UserIndexer.$$$reportNull$$$0(3);
            }
            return this.myUserEnumerator.enumerate((Object)user);
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                UserIndexer.$$$reportNull$$$0(4);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userEnumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserId";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

