/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalkerFactory;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker JSON_ORIGINAL_PSI_WALKER = new JsonOriginalPsiWalker();

    public ThreeState isName(PsiElement var1);

    public boolean isPropertyWithValue(@NotNull PsiElement var1);

    public PsiElement goUpToCheckable(@NotNull PsiElement var1);

    @Nullable
    public List<JsonSchemaVariantsTreeBuilder.Step> findPosition(@NotNull PsiElement var1, boolean var2);

    public boolean isNameQuoted();

    public boolean onlyDoubleQuotesForStringLiterals();

    default public boolean quotesForStringLiterals() {
        return true;
    }

    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement var1);

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement var1, PsiElement var2);

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement var1);

    public boolean isTopJsonElement(@NotNull PsiElement var1);

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement var1);

    default public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(0);
        }
        return element.getTextRange();
    }

    @Nullable
    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element, JsonSchemaObject schemaObject) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(1);
        }
        if (JSON_ORIGINAL_PSI_WALKER.handles(element)) {
            return JSON_ORIGINAL_PSI_WALKER;
        }
        return JsonLikePsiWalkerFactory.EXTENSION_POINT_NAME.getExtensionList().stream().filter(extension -> {
            if (element == null) {
                JsonLikePsiWalker.$$$reportNull$$$0(2);
            }
            return extension.handles(element);
        }).findFirst().map(extension -> extension.create(schemaObject)).orElse(null);
    }

    default public String getDefaultObjectValue() {
        return "{}";
    }

    @Nullable
    default public String defaultObjectValueDescription() {
        return null;
    }

    default public String getDefaultArrayValue() {
        return "[]";
    }

    @Nullable
    default public String defaultArrayValueDescription() {
        return null;
    }

    default public boolean invokeEnterBeforeObjectAndArray() {
        return false;
    }

    default public String getNodeTextForValidation(PsiElement element) {
        return element.getText();
    }

    default public QuickFixAdapter getQuickFixAdapter(Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWalker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getWalker$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface QuickFixAdapter {
        @Nullable
        public PsiElement getPropertyValue(PsiElement var1);

        @NotNull
        default public PsiElement adjustValue(@NotNull PsiElement value) {
            if (value == null) {
                QuickFixAdapter.$$$reportNull$$$0(0);
            }
            PsiElement psiElement = value;
            if (psiElement == null) {
                QuickFixAdapter.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @Nullable
        public String getPropertyName(PsiElement var1);

        @NotNull
        public PsiElement createProperty(@NotNull String var1, @NotNull String var2);

        public boolean ensureComma(PsiElement var1, PsiElement var2, PsiElement var3);

        public void removeIfComma(PsiElement var1);

        public boolean fixWhitespaceBefore(PsiElement var1, PsiElement var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker$QuickFixAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker$QuickFixAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

