/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.indexes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

class I18nYamlIndexUtil {
    @NotNull
    static final DataExternalizer<List<String>> STRING_LIST_EXTERNALIZER = new DataExternalizer<List<String>>(){

        public void save(@NotNull DataOutput out, @NotNull List<String> info) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if (info == null) {
                1.$$$reportNull$$$0(1);
            }
            IOUtil.writeStringList((DataOutput)out, info);
        }

        @NotNull
        public List<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(2);
            }
            List list = IOUtil.readStringList((DataInput)in);
            if (list == null) {
                1.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    static final FileBasedIndex.InputFilter EXPLICIT_I18N_YAML_FILTER = file -> {
        String extension = file.getExtension();
        if (extension == null) {
            return false;
        }
        return "yml".equals(extension = extension.toLowerCase(Locale.ENGLISH)) || "yaml".equals(extension);
    };

    private I18nYamlIndexUtil() {
    }

    static void visitYamlI18nLikeKeys(@NotNull FileContent inputData, final @NotNull BiConsumer<String, String> consumer) {
        if (inputData == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(1);
        }
        ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex().accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    2.$$$reportNull$$$0(0);
                }
                I18nYamlIndexUtil.processKeyValue(keyValue, consumer);
                super.visitKeyValue(keyValue);
            }

            public void visitSequence(@NotNull YAMLSequence sequence) {
                if (sequence == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keyValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sequence";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSequence";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void processKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull BiConsumer<String, String> consumer) {
        PsiElement key;
        if (keyValue == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(3);
        }
        if ((key = keyValue.getKey()) == null) {
            return;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)keyValue, YAMLSequence.class) != null) {
            return;
        }
        String fullPath = YAMLUtil.getConfigFullName((YAMLPsiElement)keyValue);
        int idx = fullPath.indexOf(".");
        if (idx == -1) {
            return;
        }
        if (keyValue.getValue() instanceof YAMLScalar || keyValue.getValue() instanceof YAMLSequence) {
            consumer.accept(fullPath, keyValue.getValueText());
            return;
        }
        String otherTranslation = I18nYamlIndexUtil.getPluralizedKeyTranslation(keyValue);
        if (otherTranslation != null) {
            consumer.accept(fullPath, otherTranslation);
        }
    }

    @Nullable
    private static String getPluralizedKeyTranslation(@NotNull YAMLKeyValue element) {
        if (element == null) {
            I18nYamlIndexUtil.$$$reportNull$$$0(4);
        }
        boolean hasOne = false;
        String other = null;
        YAMLValue value = element.getValue();
        if (value instanceof YAMLMapping) {
            for (YAMLKeyValue child : ((YAMLMapping)value).getKeyValues()) {
                String text = child.getKeyText();
                hasOne |= "one".equals(text);
                if (!"other".equals(text)) continue;
                other = child.getValueText();
            }
        }
        return hasOne && other != null ? other : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/indexes/I18nYamlIndexUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitYamlI18nLikeKeys";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeyValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPluralizedKeyTranslation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

