/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.PlaybackPositionEvent;
import net.bluecow.spectro.PlaybackPositionListener;

public class PlayerThread
extends Thread {
    private static final Logger logger = Logger.getLogger(PlayerThread.class.getName());
    private boolean playing = false;
    private boolean terminated = false;
    private SourceDataLine outputLine;
    private final Clip clip;
    private AudioInputStream in;
    private long outputLinePositionOffset;
    private int startSample;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final List<PlaybackPositionListener> playbackPositionListeners = new ArrayList<PlaybackPositionListener>();

    public PlayerThread(Clip clip) throws LineUnavailableException {
        this.clip = clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.in == null) {
            this.setPlaybackPosition(0);
        }
        try {
            AudioFormat outputFormat = this.in.getFormat();
            this.outputLine = AudioSystem.getSourceDataLine(outputFormat);
            logger.finer("Output line buffer: " + this.outputLine.getBufferSize());
            this.outputLine.open();
            byte[] buf = new byte[this.outputLine.getBufferSize()];
            block15: while (!this.terminated) {
                boolean reachedEOF = false;
                logger.info("playback starting: reachedEOF=" + reachedEOF + " playing=" + this.playing + " terminated=" + this.terminated);
                this.fireStateChanged();
                this.outputLine.start();
                while (this.playing && !reachedEOF) {
                    PlayerThread playerThread = this;
                    synchronized (playerThread) {
                        int readSize = Math.min(this.outputLine.available(), 4096);
                        int len = this.in.read(buf, 0, readSize);
                        if (len != readSize) {
                            logger.fine(String.format("Didn't read full %d bytes (got %d)\n", readSize, len));
                        }
                        if (len == -1) {
                            reachedEOF = true;
                        } else {
                            this.outputLine.write(buf, 0, len);
                        }
                    }
                    this.firePlaybackPositionUpdate(this.getPlaybackPosition());
                }
                if (this.playing) {
                    logger.finer("Draining output line...");
                    long lastPlaybackPos = 0L;
                    while (this.outputLine.isRunning()) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException ex) {
                            logger.finer("Interrupted while draining output line");
                        }
                        this.firePlaybackPositionUpdate(this.getPlaybackPosition());
                        if (lastPlaybackPos == this.getPlaybackPosition()) break;
                        lastPlaybackPos = this.getPlaybackPosition();
                    }
                    logger.finer("Finished draining output line");
                } else {
                    logger.finer("Stopping output line");
                    this.outputLine.stop();
                }
                if (reachedEOF) {
                    this.playing = false;
                    this.setPlaybackPosition(0);
                }
                logger.info("playback ended or paused: reachedEOF=" + reachedEOF + " playing=" + this.playing + " terminated=" + this.terminated);
                this.fireStateChanged();
                while (true) {
                    PlayerThread lastPlaybackPos = this;
                    synchronized (lastPlaybackPos) {
                        if (this.playing || this.terminated) {
                            continue block15;
                        }
                    }
                    try {
                        logger.finest(String.format("Player thread sleeping for 10 seconds. playing=%b\n", this.playing));
                        PlayerThread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        logger.finer(String.format("Player thread interrupted in sleep\n", new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.outputLine != null) {
                this.outputLine.close();
                this.outputLine = null;
            }
        }
        logger.fine("Player thread terminated");
    }

    public synchronized void stopPlaying() {
        this.playing = false;
    }

    public synchronized void startPlaying() {
        this.playing = true;
        this.interrupt();
    }

    public synchronized boolean isPlaying() {
        return this.playing;
    }

    public synchronized void terminate() {
        this.stopPlaying();
        this.terminated = true;
        this.interrupt();
    }

    public synchronized void setPlaybackPosition(int sample) {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.outputLine != null) {
            this.outputLine.stop();
            this.outputLine.flush();
            this.outputLine.start();
        }
        this.outputLinePositionOffset = this.outputLine != null ? this.outputLine.getLongFramePosition() : 0L;
        this.startSample = sample;
        this.in = this.clip.getAudio(sample);
        this.firePlaybackPositionUpdate(this.getPlaybackPosition());
    }

    public long getPlaybackPosition() {
        if (this.outputLine == null) {
            return 0L;
        }
        AudioFormat format = this.outputLine.getFormat();
        long elapsedSamples = (this.outputLine.getLongFramePosition() - this.outputLinePositionOffset) * (long)format.getFrameSize();
        return elapsedSamples + (long)this.startSample;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private void fireStateChanged() {
        logger.fine("Firing state change to " + this.changeListeners.size() + " listeners... playing=" + this.playing);
        ChangeEvent e = new ChangeEvent(this);
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            this.changeListeners.get(i).stateChanged(e);
        }
    }

    public void addPlaybackPositionListener(PlaybackPositionListener l) {
        this.playbackPositionListeners.add(l);
    }

    public void removePlaybackPositionListener(PlaybackPositionListener l) {
        this.playbackPositionListeners.remove(l);
    }

    public void firePlaybackPositionUpdate(long samplePos) {
        logger.finest("Firing playback position update: " + samplePos);
        PlaybackPositionEvent e = new PlaybackPositionEvent(this, samplePos);
        for (int i = this.playbackPositionListeners.size() - 1; i >= 0; --i) {
            this.playbackPositionListeners.get(i).playbackPositionUpdate(e);
        }
    }
}

