/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.MemoryMonitor;
import net.bluecow.spectro.PositionReadout;
import net.bluecow.spectro.SpectroEditSession;
import net.bluecow.spectro.tool.PaintbrushTool;
import net.bluecow.spectro.tool.RegionFlipTool;
import net.bluecow.spectro.tool.RegionScaleTool;
import net.bluecow.spectro.tool.RegionThresholdTool;
import net.bluecow.spectro.tool.TitleBorder;
import net.bluecow.spectro.tool.Tool;
import net.bluecow.spectro.tool.ToolButton;

public class ToolboxPanel {
    private final SpectroEditSession session;
    private final ClipPanel clipPanel;
    private final JPanel panel;
    private final JPanel toolButtonPanel;
    private final JPanel toolSettingsPanel;
    private final JPanel viewSettingsPanel;
    private final ButtonGroup toolButtonGroup = new ButtonGroup();
    private Tool currentTool;
    private final TitleBorder toolSettingsBorder;

    public ToolboxPanel(SpectroEditSession session) {
        this.session = session;
        this.clipPanel = session.getClipPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.viewSettingsPanel = new JPanel(new GridBagLayout());
        this.viewSettingsPanel.setBackground(Color.WHITE);
        this.viewSettingsPanel.setBorder(new TitleBorder("View Settings"));
        gbc.gridx = 0;
        this.viewSettingsPanel.add((Component)this.clipPanel.getColorizer().getSettingsPanel(), gbc);
        this.viewSettingsPanel.add((Component)new PositionReadout(this.clipPanel).getLabel(), gbc);
        MemoryMonitor memoryMonitor = new MemoryMonitor();
        memoryMonitor.start();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.viewSettingsPanel.add(Box.createVerticalGlue(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.viewSettingsPanel.add((Component)memoryMonitor.getLabel(), gbc);
        this.toolSettingsPanel = new JPanel(new BorderLayout());
        this.toolSettingsPanel.setBackground(Color.WHITE);
        this.toolSettingsBorder = new TitleBorder("Tool Settings");
        this.toolSettingsPanel.setBorder(this.toolSettingsBorder);
        this.toolButtonPanel = new JPanel(new FlowLayout());
        this.toolButtonPanel.setBackground(Color.WHITE);
        this.toolButtonPanel.setBorder(new TitleBorder("Tools"));
        ActionListener actionHandler = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ToolboxPanel.this.currentTool != null) {
                    ToolboxPanel.this.currentTool.deactivate();
                    ToolboxPanel.this.toolSettingsPanel.remove(ToolboxPanel.this.currentTool.getSettingsPanel());
                }
                ToolboxPanel.this.currentTool = ((ToolButton)e.getSource()).getTool();
                ToolboxPanel.this.currentTool.activate(ToolboxPanel.this.session);
                ToolboxPanel.this.toolSettingsPanel.add((Component)ToolboxPanel.this.currentTool.getSettingsPanel(), "Center");
                ToolboxPanel.this.toolSettingsBorder.setTitle("Tool Settings: " + ToolboxPanel.this.currentTool.getName());
                ToolboxPanel.this.panel.revalidate();
                ToolboxPanel.this.panel.repaint();
            }
        };
        ToolButton paintbrushToolButton = new ToolButton(new PaintbrushTool(), "paintbrush", this.toolButtonGroup);
        this.toolButtonPanel.add(paintbrushToolButton);
        paintbrushToolButton.addActionListener(actionHandler);
        ToolButton regionScaleToolButton = new ToolButton(new RegionScaleTool(), "contrast_change", this.toolButtonGroup);
        this.toolButtonPanel.add(regionScaleToolButton);
        regionScaleToolButton.addActionListener(actionHandler);
        ToolButton regionThresholdToolButton = new ToolButton(new RegionThresholdTool(), "threshold", this.toolButtonGroup);
        this.toolButtonPanel.add(regionThresholdToolButton);
        regionThresholdToolButton.addActionListener(actionHandler);
        ToolButton flipToolButton = new ToolButton(new RegionFlipTool(), "shape_flip_vertical", this.toolButtonGroup);
        this.toolButtonPanel.add(flipToolButton);
        flipToolButton.addActionListener(actionHandler);
        this.panel = new JPanel(new GridLayout(3, 1));
        this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panel.setBackground(Color.WHITE);
        this.panel.add(this.toolButtonPanel);
        this.panel.add(this.toolSettingsPanel);
        this.panel.add(this.viewSettingsPanel);
        paintbrushToolButton.doClick();
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

