/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.CatalogsPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.fw.gui.SQLCatalogsComboBox;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeInternalFrame
extends SessionTabWidget
implements IObjectTreeInternalFrame {
    private final IApplication _app;
    private ObjectTreePanel _objTreePanel;
    private ObjectTreeToolBar _toolBar;
    private boolean _hasBeenVisible = false;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeInternalFrame.class);

    public ObjectTreeInternalFrame(ISession session) {
        super(session.getTitle(), true, true, true, true, session);
        this._app = session.getApplication();
        this.setVisible(false);
        this.createGUI(session);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._hasBeenVisible) {
            this._hasBeenVisible = true;
            this._objTreePanel.refreshTree();
        }
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._objTreePanel;
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPI() {
        return this._objTreePanel;
    }

    private void createGUI(ISession session) {
        this.setVisible(false);
        IApplication app = session.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetActivated(WidgetEvent evt) {
                Component focusOwner;
                Window window = SwingUtilities.windowForComponent(ObjectTreeInternalFrame.this.getObjectTreePanel());
                Component component = focusOwner = window != null ? window.getFocusOwner() : null;
                if (focusOwner != null) {
                    FocusEvent lost = new FocusEvent(focusOwner, 1005);
                    FocusEvent gained = new FocusEvent(focusOwner, 1004);
                    window.dispatchEvent(lost);
                    window.dispatchEvent(gained);
                    window.dispatchEvent(lost);
                    focusOwner.requestFocus();
                }
            }
        });
        this._objTreePanel = new ObjectTreePanel(this.getSession());
        this._objTreePanel.addTreeSelectionListener(new ObjectTreeSelectionListener());
        this._toolBar = new ObjectTreeToolBar(this.getSession(), this._objTreePanel);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this._toolBar, "North");
        contentPanel.add((Component)this._objTreePanel, "Center");
        this.setContentPane(contentPanel);
        this.validate();
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return false;
    }

    private final class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private ObjectTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            TreePath selPath = evt.getNewLeadSelectionPath();
            if (selPath != null) {
                StringBuffer buf = new StringBuffer();
                Object[] fullPath = selPath.getPath();
                for (int i = 0; i < fullPath.length; ++i) {
                    if (!(fullPath[i] instanceof ObjectTreeNode)) continue;
                    ObjectTreeNode node = (ObjectTreeNode)fullPath[i];
                    buf.append('/').append(node.toString());
                }
            }
        }
    }

    private final class CatalogsComboListener
    implements ActionListener {
        private CatalogsComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SQLCatalogsComboBox cmb;
            String catalog;
            Object src = evt.getSource();
            if (src instanceof SQLCatalogsComboBox && (catalog = (cmb = (SQLCatalogsComboBox)src).getSelectedCatalog()) != null) {
                try {
                    ObjectTreeInternalFrame.this.getSession().getSQLConnection().setCatalog(catalog);
                }
                catch (SQLException ex) {
                    ObjectTreeInternalFrame.this.getSession().showErrorMessage(ex);
                }
            }
        }
    }

    private class ObjectTreeToolBar
    extends ToolBar {
        private final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeToolBar.class);
        private ILogger s_log = LoggerController.createLogger(ObjectTreeToolBar.class);
        private CatalogsPanel _catalogsPanel;

        ObjectTreeToolBar(ISession session, ObjectTreePanel panel) {
            this.createGUI(session, panel);
        }

        private void createGUI(ISession session, ObjectTreePanel panel) {
            this._catalogsPanel = new CatalogsPanel(session, this);
            this._catalogsPanel.addActionListener(new CatalogsComboListener());
            this.add(this._catalogsPanel);
            ActionCollection actions = session.getApplication().getActionCollection();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add(actions.get(RefreshSchemaInfoAction.class));
        }
    }
}

