/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.Options;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class RGBGrayFilter
extends RGBImageFilter {
    private RGBGrayFilter() {
        this.canFilterIndexColorModel = true;
    }

    public static Icon getDisabledIcon(JComponent component, Icon icon) {
        Image img;
        if (icon == null || component == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            img = ((ImageIcon)icon).getImage();
        } else {
            img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(component, img.getGraphics(), 0, 0);
        }
        if (!Options.isHiResGrayFilterEnabled() || Boolean.FALSE.equals(component.getClientProperty("generateHiResDisabledIcon"))) {
            return new ImageIcon(GrayFilter.createDisabledImage(img));
        }
        FilteredImageSource producer = new FilteredImageSource(img.getSource(), new RGBGrayFilter());
        return new ImageIcon(component.createImage(producer));
    }

    public int filterRGB(int x, int y, int rgb) {
        float avg = ((float)(rgb >> 16 & 0xFF) / 255.0f + (float)(rgb >> 8 & 0xFF) / 255.0f + (float)(rgb & 0xFF) / 255.0f) / 3.0f;
        float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
        avg = Math.min(1.0f, 0.35f + 0.65f * avg);
        return (int)(alpha * 255.0f) << 24 | (int)(avg * 255.0f) << 16 | (int)(avg * 255.0f) << 8 | (int)(avg * 255.0f);
    }
}

