# $Id: update_tab.tcl 903 2007-02-07 19:31:31Z sergei $

namespace eval update_tab {
    hook::add draw_message_hook [namespace current]::update 8
}

proc update_tab::update {chatid from type body x} {
    set connid [chat::get_connid $chatid]
    set jid [chat::get_jid $chatid]
    set cw [chat::winid $chatid]

    foreach xelem $x {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children
	
	# Don't update tab if this 'empty' tag is present. It indicates
	# messages history in chat window.
	if {[cequal $tag ""] && \
		[cequal [jlib::wrapper:getattr $vars xmlns] tkabber:x:nolog]} {
	    return
	}
    }

    if {![catch {::plugins::mucignore::is_ignored $connid $from $type} ignore] && \
	    $ignore != ""} {
	return
    }

    switch -- $type {
	error -
	info {
	    tab_set_updated $cw 1 $type
	}
	groupchat {
	    if {$from == $jid} {
		tab_set_updated $cw 1 server
	    } else {
		set myjid [chat::our_jid $chatid]
		set mynick [chat::get_nick $connid $myjid $type]

		if {[check_message $mynick $body]} {
		    tab_set_updated $cw 1 mesg_to_user
		} else {
		    tab_set_updated $cw 1 message
		}
	    }
	}
	chat -
	default {
	    if {$from == ""} {
		# synthesized message
		tab_set_updated $cw 1 server
	    } else {
		tab_set_updated $cw 1 mesg_to_user
	    }
	}
    }
}

# vim:ts=8:sw=4:sts=4:noet
