/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPConnectorHandler
implements ConnectorHandler<TCPSelectorHandler, CallbackHandler>,
AsyncQueueWritable,
AsyncQueueReadable {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected TCPSelectorHandler selectorHandler;
    private CallbackHandler callbackHandler;
    private InputReader inputStream;
    private SocketChannel socketChannel;
    private volatile boolean isConnected;
    private Controller controller;
    private CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;
    protected int connectionTimeout = 30000;

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectorHandler cannot be null");
        }
        this.selectorHandler = selectorHandler;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(this);
        } else {
            this.callbackHandler = callbackHandler;
        }
        TCPConnectorHandler tCPConnectorHandler = this;
        synchronized (tCPConnectorHandler) {
            this.isConnectedLatch = new CountDownLatch(1);
            selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        }
        this.inputStream = new InputReader();
        try {
            this.isConnectedLatch.await(this.connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new TCPSelectorHandler(true));
            DefaultThreadPool threadPool = new DefaultThreadPool();
            this.controller.setThreadPool(threadPool);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new DefaultCallbackHandler(this, false);
            new Thread((Runnable)this.controller, "GrizzlyTCPConnectorHandler-Controller").start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (null == this.callbackHandler) {
            this.callbackHandler = new DefaultCallbackHandler(this);
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        int nRead;
        SelectionKey key;
        block10: {
            if (!this.isConnected) {
                throw new NotYetConnectedException();
            }
            key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
            if (blocking) {
                this.inputStream.setSelectionKey(key);
                return this.inputStream.read(byteBuffer);
            }
            if (this.callbackHandler == null) {
                throw new IllegalStateException("Non blocking read needs a CallbackHandler");
            }
            nRead = -1;
            try {
                try {
                    nRead = this.socketChannel.read(byteBuffer);
                }
                catch (IOException ex) {
                    nRead = -1;
                    throw ex;
                }
                Object var7_5 = null;
                if (nRead != -1) break block10;
            }
            catch (Throwable throwable) {
                SelectionKeyHandler skh222;
                Object var7_6 = null;
                if (nRead == -1 && (skh222 = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                    ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                }
                throw throwable;
            }
            SelectionKeyHandler skh222 = this.selectorHandler.getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
            }
        }
        if (nRead == 0) {
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        int totalWriteBytes;
        SelectionKey key;
        block11: {
            if (!this.isConnected) {
                throw new NotYetConnectedException();
            }
            if (blocking) {
                return OutputWriter.flushChannel((SelectableChannel)this.socketChannel, byteBuffer);
            }
            if (this.callbackHandler == null) {
                throw new IllegalStateException("Non blocking write needs a CallbackHandler");
            }
            key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
            int nWrite = 1;
            totalWriteBytes = 0;
            try {
                try {
                    while (nWrite > 0 && byteBuffer.hasRemaining()) {
                        nWrite = this.socketChannel.write(byteBuffer);
                        totalWriteBytes += nWrite;
                    }
                    Object var8_6 = null;
                    if (nWrite != -1) break block11;
                }
                catch (IOException ex) {
                    nWrite = -1;
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                SelectionKeyHandler skh222;
                Object var8_7 = null;
                if (nWrite == -1 && (skh222 = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                    ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                }
                throw throwable;
            }
            SelectionKeyHandler skh222 = this.selectorHandler.getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
            }
        }
        if (totalWriteBytes == 0 && byteBuffer.hasRemaining()) {
            this.selectorHandler.register(key, 4);
        }
        return totalWriteBytes;
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, condition, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        return this.selectorHandler.getAsyncQueueReader().read(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public void close() throws IOException {
        if (this.socketChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                this.selectorHandler.getSelectionKeyHandler().cancel(key);
            } else {
                this.socketChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
        this.connectionTimeout = 30000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        try {
            block8: {
                if (Controller.logger().isLoggable(Level.FINE)) {
                    Controller.logger().log(Level.FINE, "Finish connect");
                }
                this.socketChannel = (SocketChannel)key.channel();
                this.socketChannel.finishConnect();
                this.isConnected = this.socketChannel.isConnected();
                this.configureChannel(this.socketChannel);
                if (!Controller.logger().isLoggable(Level.FINE)) break block8;
                Controller.logger().log(Level.FINE, "isConnected: " + this.isConnected);
            }
            Object var4_2 = null;
            TCPConnectorHandler tCPConnectorHandler = this;
            synchronized (tCPConnectorHandler) {
                this.isConnectedLatch.countDown();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            TCPConnectorHandler tCPConnectorHandler2 = this;
            synchronized (tCPConnectorHandler2) {
                this.isConnectedLatch.countDown();
                throw throwable;
            }
        }
    }

    public void configureChannel(SelectableChannel channel) throws IOException {
        Socket socket = ((SocketChannel)channel).socket();
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setReuseAddress exception ", ex);
        }
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    public boolean isConnected() {
        return this.isConnected && this.socketChannel.isOpen();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    protected void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public TCPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }
}

