/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.session.AbstractSessionManager;

public abstract class LoginAuthenticator
implements Authenticator {
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null && httpSession.getAttribute("org.eclipse.jetty.security.sessionKnownOnlytoAuthenticated") != Boolean.TRUE) {
            LoginAuthenticator loginAuthenticator = this;
            synchronized (loginAuthenticator) {
                httpSession = AbstractSessionManager.renewSession((HttpServletRequest)request, (HttpSession)httpSession, (boolean)true);
            }
        }
        return httpSession;
    }
}

