/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SPDYAsyncConnection
extends AbstractConnection
implements AsyncConnection,
Controller<StandardSession.FrameBytes>,
IdleListener {
    private static final Logger logger = Log.getLogger(SPDYAsyncConnection.class);
    private final ByteBufferPool bufferPool;
    private final Parser parser;
    private volatile Session session;
    private ByteBuffer writeBuffer;
    private Handler<StandardSession.FrameBytes> writeHandler;
    private StandardSession.FrameBytes writeContext;
    private volatile boolean writePending;

    public SPDYAsyncConnection(AsyncEndPoint endPoint, ByteBufferPool bufferPool, Parser parser) {
        super((EndPoint)endPoint);
        this.bufferPool = bufferPool;
        this.parser = parser;
        this.onIdle(true);
    }

    public Connection handle() throws IOException {
        AsyncEndPoint endPoint = this.getEndPoint();
        boolean progress = true;
        while (endPoint.isOpen() && progress) {
            int filled = this.fill();
            progress = filled > 0;
            int flushed = this.flush();
            progress |= flushed > 0;
            endPoint.flush();
            if ((progress |= endPoint.hasProgressed()) || filled >= 0) continue;
            this.onInputShutdown();
            this.close(false);
        }
        return this;
    }

    public int fill() throws IOException {
        ByteBuffer buffer = this.bufferPool.acquire(8192, true);
        DirectNIOBuffer jettyBuffer = new DirectNIOBuffer(buffer, false);
        jettyBuffer.setPutIndex(jettyBuffer.getIndex());
        AsyncEndPoint endPoint = this.getEndPoint();
        int filled = endPoint.fill((Buffer)jettyBuffer);
        logger.debug("Filled {} from {}", new Object[]{filled, endPoint});
        if (filled <= 0) {
            return filled;
        }
        buffer.limit(jettyBuffer.putIndex());
        buffer.position(jettyBuffer.getIndex());
        this.parser.parse(buffer);
        this.bufferPool.release(buffer);
        return filled;
    }

    public int flush() {
        int result = 0;
        if (this.writePending) {
            result = this.write(this.writeBuffer, this.writeHandler, this.writeContext);
        }
        logger.debug("Flushed {} to {}", new Object[]{result, this.getEndPoint()});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buffer, Handler<StandardSession.FrameBytes> handler, StandardSession.FrameBytes context) {
        int remaining = buffer.remaining();
        DirectNIOBuffer jettyBuffer = buffer.isDirect() ? new DirectNIOBuffer(buffer, false) : new IndirectNIOBuffer(buffer, false);
        AsyncEndPoint endPoint = this.getEndPoint();
        try {
            int written = endPoint.flush((Buffer)jettyBuffer);
            logger.debug("Written {} bytes, {} remaining", new Object[]{written, jettyBuffer.length()});
        }
        catch (Exception x) {
            this.close(false);
            handler.failed((Object)context, (Throwable)x);
            int n = -1;
            return n;
        }
        finally {
            buffer.limit(jettyBuffer.putIndex());
            buffer.position(jettyBuffer.getIndex());
        }
        if (buffer.hasRemaining()) {
            this.writeBuffer = buffer;
            this.writeHandler = handler;
            this.writeContext = context;
            this.writePending = true;
            endPoint.scheduleWrite();
        } else {
            if (this.writePending) {
                this.writeBuffer = null;
                this.writeHandler = null;
                this.writeContext = null;
                this.writePending = false;
            }
            handler.completed((Object)context);
        }
        return remaining - buffer.remaining();
    }

    public void close(boolean onlyOutput) {
        try {
            AsyncEndPoint endPoint = this.getEndPoint();
            try {
                logger.debug("Shutting down output {}", new Object[]{endPoint});
                endPoint.shutdownOutput();
                if (!onlyOutput) {
                    logger.debug("Closing {}", new Object[]{endPoint});
                    endPoint.close();
                }
            }
            catch (IOException x) {
                endPoint.close();
            }
        }
        catch (IOException x) {
            logger.ignore((Throwable)x);
        }
    }

    public void onIdle(boolean idle) {
        this.getEndPoint().setCheckForIdle(idle);
    }

    public AsyncEndPoint getEndPoint() {
        return (AsyncEndPoint)super.getEndPoint();
    }

    public boolean isIdle() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void onClose() {
    }

    public void onInputShutdown() throws IOException {
    }

    public void onIdleExpired(long idleForMs) {
        logger.debug("Idle timeout expired for {}", new Object[]{this.getEndPoint()});
        this.session.goAway();
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public String toString() {
        return String.format("%s@%x{endp=%s@%x}", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getEndPoint().getClass().getSimpleName(), this.getEndPoint().hashCode());
    }
}

