#
# NAME
#	swutils.sh.in - general subroutines for swutils
# VERSION
#	$Id$
# CHANGELOG
#	$Log$
# PACKAGE
#

# global variables
swu_this="UNKNOWN" ;		# name of main script
swu_local_this="UNKNOWN" ; 	# defined in each subroutine
swu_return="" ;			# return value of subroutine
swu_usage_message="" ;		# usage message
swu_verbose="OFF" ;		# verbose mode ("ON" or "OFF")

set_this_name(){
	swu_this=$1 ;
}

set_this_usage(){
	swu_usage_message=$1 ;
}

display_usage() {
	echo " usage: $swu_usage_message" >&2 ;
}

error() {
	echo "$swu_this [ERROR] $1" >&2 ;
	if [ ! -z "$swu_usage_message" ] ; then
		display_usage ;
	fi
	exit 1 ;
}

# USAGE
#	set_verbose_mode "ON" or "OFF"
set_verbose_mode() {
	if test "X$1" = "XON" ; then
		swu_verbose="ON" ;
	elif test "X$1" = "XOFF" ; then
		swu_verbose="OFF" ;
	else
		error "[set_verbose_mode] illegal parameter" ;
	fi
}

get_verbose_mode() {
	export swu_return=$swu_verbose ;
}

verbose() {
	if test "X$swu_verbose" = "XON" ; then
		echo "$1" >&2 ;
	fi
}

# USAGE
#	search_swutils_config (no parameter)
#
search_swutils_config() {
	if test -n "$SWUTILS_CONFIG" ; then
		if test ! -x $SWUTILS_CONFIG ; then
			error "\"SWUTILS_CONFIG\" has illegal value" >&2 ;
		fi
	elif which swutils-config > /dev/null ; then
		export SWUTILS_CONFIG=`which swutils-config` ;
	else 
		error "\"swutils-config\" is not found." ;
	fi
}

# USAGE
#	search_swutils_bin <exe-file>
#	  exe-file : executable file which will be in .../bin directory
# NOTE
#	you must call "search_swutils_config" subroutine before call
#	this routine.
search_swutils_bin(){
	swu_local_this="seach_swutils_bin" ;
	if test "X$1" = "X" ; then
		error "[$swu_local_this] is not given parameter" ;
	fi
	swu_return=`$SWUTILS_CONFIG --bin-path $1` ;
	if test ! -x $swu_return ; then
		error "[$swu_local_this] \"$swu_return\" is not executable" ;
	fi
	export swu_return ;
}

# USAGE
#	search_swutils_libexec <exe-file>
#	  exe-file : executable file which will be in .../libexec directory
# NOTE
#	you must call "search_swutils_config" subroutine before call
#	this routine.
search_swutils_libexec(){
	swu_local_this="seach_swutils_libexec" ;
	if test "X$1" = "X" ; then
		error "[$swu_local_this] is not given parameter" ;
	fi
	swu_return=`$SWUTILS_CONFIG --libexec-path $1` ;
	if test ! -x $swu_return ; then
		error "[$swu_local_this] \"$swu_return\" is not executable" ;
	fi
	export swu_return ;
}

# USAGE
#	search_swutils_data <exe-file>
#	  exe-file : executable file which will be in .../data directory
# NOTE
#	you must call "search_swutils_config" subroutine before call
#	this routine.
search_swutils_data(){
	swu_local_this="seach_swutils_data" ;
	if test "X$1" = "X" ; then
		error "[$swu_local_this] is not given parameter" ;
	fi
	swu_return=`$SWUTILS_CONFIG --data-path $1` ;
	if test ! -x $swu_return ; then
		error "[$swu_local_this] \"$swu_return\" is not executable" ;
	fi
	export swu_return ;
}

# USAGE
#	check_input_file <input-file-name>
check_input_file() {
	if test -z "$1" ; then
		error "no input file name is given." ;
	elif test $1 = "-" ; then
		echo "" > /dev/null ; # do nothing
	elif test ! -f $1 ; then
		error "file \"$1\" is not exist" ;
	elif test ! -r $1 ; then
		error "permission is not given to read \"$1\"" ;
	fi
}

# USAGE
#	check_output_file
check_output_file(){
	if test -z $1 ; then
		error "no output file name is given" ;
	elif test $1 = "-" ; then
		echo "" > /dev/null ; # do nothing
	elif ! touch $1 > /dev/null 2>&1 ; then
		error "can not create \"$1\"" ;
	fi
}

# USAGE
#	remove_file_extension $filename
remove_file_extension() {
	swu_return=`echo $1 | sed 's!\.[^.]*$!!'` ;
	export swu_return ;
}

