package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

public class LegacyLogoutRequest extends Request implements LogoutRequest {
	
	public LegacyLogoutRequest(String server, int port, int sessionId) {
		
		super(server, port, "logout?session-id=" + sessionId);
		
	}
	
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			DataInputStream _in = new DataInputStream(_conn.getInputStream());
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
				
			
			data = new byte[_len];
			_in.readFully(data);
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
}
