		opt nolist
;
; Device type defintions for PIC16F818
;

__progmem_size		equ	1024
__data_eeprom_size	equ	128

__config		set	0x3fff

			set_pic_type	"PIC16F818", "14-bit"

__do_config	macro	; keyword, value
		if streqcase("\1", "osc") | streqcase("\1", "fosc")
			if streqcase("\2", "lp")
__config			set __config & 0b1111111111101100
				exitm
			endif
			if streqcase("\2", "xt")
__config			set (__config & 0b1111111111101100) | 0b00000001
				exitm
			endif
			if streqcase("\2", "hs")
__config			set (__config & 0b1111111111101100) | 0b00000010
				exitm
			endif
			if streqcase("\2", "ec") | streqcase("\2", "extclk")
__config			set (__config & 0b1111111111101100) | 0b00000011
				exitm
			endif
			if streqcase("\2", "intoscio") | streqcase("\2", "intrcio")
__config			set (__config & 0b1111111111101100) | 0b00010000
				exitm
			endif
			if streqcase("\2", "intosc") | streqcase("\2", "intrc")
__config			set (__config & 0b1111111111101100) | 0b00010001
				exitm
			endif
			if streqcase("\2", "extrcio")
__config			set (__config & 0b1111111111101100) | 0b00010010
				exitm
			endif
			if streqcase("\2", "extrc")
__config			set (__config & 0b1111111111101100) | 0b00010011
				exitm
			endif
			error	"Invalid oscillator setting"
			exitm
		endif
		if streqcase("\1", "wdt") | streqcase("\1", "wdte")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0b0000000000000100
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0b1111111111111011
				exitm
			endif
			error "Invalid WDT setting"
			exitm
		endif
		if streqcase("\1", "pwrt") | streqcase("\1", "pwrte")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0b1111111111110111
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0b0000000000001000
				exitm
			endif
			error "Invalid PWRT setting"
			exitm
		endif
		if streqcase("\1", "mclr") | streqcase("\1", "mclre")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0b0000000000100000
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0b1111111111011111
				exitm
			endif
			error "Invalid MCLR setting"
			exitm
		endif
		if streqcase("\1", "boden") | streqcase("\1", "boren")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0b0000000001000000
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0b1111111110111111
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "lvp")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0b0000000010000000
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0b1111111101111111
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "cpd")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0b1111111011111111
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0b0000000100000000
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "wrt")
			if ((\2) >= 0) & ((\2) <= 3)
__config			set (__config & 0b1111100111111111) | ((\2) << 9)
				exitm
			endif
			error "Invalid WRT setting"
			exitm
		endif
		if streqcase("\1", "debug")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0b1111011111111111
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0b0000100000000000
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "ccpmx")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config | 0b0001000000000000
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config & 0b1110111111111111
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		if streqcase("\1", "cp")
			if streqcase("\2", "on") | streqcase("\2", "yes")
__config			set __config & 0b1101111111111111
				exitm
			endif
			if streqcase("\2", "off") | streqcase("\2", "no")
__config			set __config | 0b0010000000000000
				exitm
			endif
			error "Invalid BODEN setting"
			exitm
		endif
		error "Invalid config keyword"
		endm

		opt list
