/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RegexpMatcherTest {
    public static final String UNIX_LINE = "\n";
    private RegexpMatcher reg;

    public abstract RegexpMatcher getImplementation();

    protected final RegexpMatcher getReg() {
        return this.reg;
    }

    @Before
    public void setUp() {
        this.reg = this.getImplementation();
    }

    @Test
    public void testMatches() {
        this.reg.setPattern("aaaa");
        Assert.assertTrue((String)"aaaa should match itself", (boolean)this.reg.matches("aaaa"));
        Assert.assertTrue((String)"aaaa should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        Assert.assertTrue((String)"aaaa shouldn't match xaaa", (!this.reg.matches("xaaa") ? 1 : 0) != 0);
        this.reg.setPattern("^aaaa");
        Assert.assertTrue((String)"^aaaa shouldn't match xaaaa", (!this.reg.matches("xaaaa") ? 1 : 0) != 0);
        Assert.assertTrue((String)"^aaaa should match aaaax", (boolean)this.reg.matches("aaaax"));
        this.reg.setPattern("aaaa$");
        Assert.assertTrue((String)"aaaa$ shouldn't match aaaax", (!this.reg.matches("aaaax") ? 1 : 0) != 0);
        Assert.assertTrue((String)"aaaa$ should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        this.reg.setPattern("[0-9]+");
        Assert.assertTrue((String)"[0-9]+ should match 123", (boolean)this.reg.matches("123"));
        Assert.assertTrue((String)"[0-9]+ should match 1", (boolean)this.reg.matches("1"));
        Assert.assertTrue((String)"[0-9]+ shouldn't match ''", (!this.reg.matches("") ? 1 : 0) != 0);
        Assert.assertTrue((String)"[0-9]+ shouldn't match a", (!this.reg.matches("a") ? 1 : 0) != 0);
        this.reg.setPattern("[0-9]*");
        Assert.assertTrue((String)"[0-9]* should match 123", (boolean)this.reg.matches("123"));
        Assert.assertTrue((String)"[0-9]* should match 1", (boolean)this.reg.matches("1"));
        Assert.assertTrue((String)"[0-9]* should match ''", (boolean)this.reg.matches(""));
        Assert.assertTrue((String)"[0-9]* should match a", (boolean)this.reg.matches("a"));
        this.reg.setPattern("([0-9]+)=\\1");
        Assert.assertTrue((String)"([0-9]+)=\\1 should match 1=1", (boolean)this.reg.matches("1=1"));
        Assert.assertTrue((String)"([0-9]+)=\\1 shouldn't match 1=2", (!this.reg.matches("1=2") ? 1 : 0) != 0);
    }

    @Test
    public void testGroups() {
        this.reg.setPattern("aaaa");
        Vector v = this.reg.getGroups("xaaaa");
        Assert.assertEquals((String)"No parens -> no extra groups", (long)1L, (long)v.size());
        Assert.assertEquals((String)"Trivial match with no parens", (Object)"aaaa", (Object)((String)v.elementAt(0)));
        this.reg.setPattern("(aaaa)");
        v = this.reg.getGroups("xaaaa");
        Assert.assertEquals((String)"Trivial match with single paren", (long)2L, (long)v.size());
        Assert.assertEquals((String)"Trivial match with single paren, full match", (Object)"aaaa", (Object)((String)v.elementAt(0)));
        Assert.assertEquals((String)"Trivial match with single paren, matched paren", (Object)"aaaa", (Object)((String)v.elementAt(0)));
        this.reg.setPattern("(a+)b(b+)");
        v = this.reg.getGroups("xaabb");
        Assert.assertEquals((long)3L, (long)v.size());
        Assert.assertEquals((Object)"aabb", (Object)((String)v.elementAt(0)));
        Assert.assertEquals((Object)"aa", (Object)((String)v.elementAt(1)));
        Assert.assertEquals((Object)"b", (Object)((String)v.elementAt(2)));
    }

    @Test
    public void testBugzillaReport14619() {
        this.reg.setPattern("^(.*)/src/((.*/)*)([a-zA-Z0-9_\\.]+)\\.java$");
        Vector v = this.reg.getGroups("de/tom/src/Google.java");
        Assert.assertEquals((long)5L, (long)v.size());
        Assert.assertEquals((Object)"de/tom", v.elementAt(1));
        Assert.assertEquals((Object)"", v.elementAt(2));
        Assert.assertEquals((Object)"", v.elementAt(3));
        Assert.assertEquals((Object)"Google", v.elementAt(4));
    }

    @Test
    public void testCaseInsensitiveMatch() {
        this.reg.setPattern("aaaa");
        Assert.assertTrue((String)"aaaa doesn't match AAaa", (!this.reg.matches("AAaa") ? 1 : 0) != 0);
        Assert.assertTrue((String)"aaaa matches AAaa ignoring case", (boolean)this.reg.matches("AAaa", 256));
    }

    @Test
    public void testParagraphCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"paragraph character", (!this.reg.matches("end of text\u2029") ? 1 : 0) != 0);
    }

    @Test
    public void testLineSeparatorCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"line-separator character", (!this.reg.matches("end of text\u2028") ? 1 : 0) != 0);
    }

    @Test
    public void testNextLineCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"next-line character", (!this.reg.matches("end of text\u0085") ? 1 : 0) != 0);
    }

    @Test
    public void testStandaloneCR() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"standalone CR", (!this.reg.matches("end of text\r") ? 1 : 0) != 0);
    }

    @Test
    public void testWindowsLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"Windows line separator", (!this.reg.matches("end of text\r\n") ? 1 : 0) != 0);
    }

    @Test
    public void testWindowsLineSeparator2() throws IOException {
        this.reg.setPattern("end of text\r$");
        Assert.assertTrue((String)"Windows line separator", (boolean)this.reg.matches("end of text\r\n"));
    }

    @Test
    public void testUnixLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"Unix line separator", (boolean)this.reg.matches("end of text\n"));
    }

    @Test
    public void testMultiVersusSingleLine() throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("Line1").append(UNIX_LINE);
        buf.append("starttest Line2").append(UNIX_LINE);
        buf.append("Line3 endtest").append(UNIX_LINE);
        buf.append("Line4").append(UNIX_LINE);
        String text = buf.toString();
        this.doStartTest1(text);
        this.doStartTest2(text);
        this.doEndTest1(text);
        this.doEndTest2(text);
    }

    protected void doStartTest1(String text) {
        this.reg.setPattern("^starttest");
        Assert.assertTrue((String)"^starttest in default mode", (!this.reg.matches(text) ? 1 : 0) != 0);
        Assert.assertTrue((String)"^starttest in single line mode", (!this.reg.matches(text, 65536) ? 1 : 0) != 0);
        Assert.assertTrue((String)"^starttest in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doStartTest2(String text) {
        this.reg.setPattern("^Line1");
        Assert.assertTrue((String)"^Line1 in default mode", (boolean)this.reg.matches(text));
        Assert.assertTrue((String)"^Line1 in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"^Line1 in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest1(String text) {
        this.reg.setPattern("endtest$");
        Assert.assertTrue((String)"endtest$ in default mode", (!this.reg.matches(text) ? 1 : 0) != 0);
        Assert.assertTrue((String)"endtest$ in single line mode", (!this.reg.matches(text, 65536) ? 1 : 0) != 0);
        Assert.assertTrue((String)"endtest$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest2(String text) {
        this.reg.setPattern("Line4$");
        Assert.assertTrue((String)"Line4$ in default mode", (boolean)this.reg.matches(text));
        Assert.assertTrue((String)"Line4$ in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"Line4$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }
}

