/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import com.gokgs.client.KClient;
import com.gokgs.client.swing.KGuiClientUtil;
import com.gokgs.client.swing.KRoomPanel;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import org.igoweb.cgoban.ConfigWindow;
import org.igoweb.cgoban.UploadPicWindow;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.FileIo;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.sgf.LoadWarningWindow;
import org.igoweb.go.swing.sgf.SelectFile;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.MsgOut;

public class CGuiClientUtil
extends KGuiClientUtil {
    public CGuiClientUtil(KClient client) {
        super(client);
    }

    @Override
    public void download(AFrame parent, String path, String fileName) {
        try {
            URL url = new URL("http://" + Config.get("fileHost") + '/' + path + fileName);
            if (JnlpIo.isAvailable()) {
                JnlpIo.FileAccessResult far = null;
                try {
                    InputStream inStream = url.openStream();
                    far = JnlpIo.saveAsFile(new File(fileName), inStream);
                    inStream.close();
                }
                catch (IOException excep) {
                    Logger.getLogger("global").log(Level.WARNING, "CGuiClientUtil.download: Error downloading", excep);
                    new Errout(Defs.getString(-382651068, new Object[]{far == null ? "<unknown>" : far.getFileName(), excep.toString()}));
                }
            } else {
                File toSave = SelectFile.getFile((Component)parent, Defs.getString(1096335309), fileName, true);
                if (toSave != null) {
                    this.downloadFileChosen(toSave, url);
                }
            }
        }
        catch (Exception excep) {
            throw new RuntimeException(excep);
        }
    }

    @Override
    public void save(Component parent, GameSummary<?> gameSummary, Object gameData) {
        String defaultName = gameSummary.getFileName();
        if (JnlpIo.isAvailable()) {
            JnlpIo.FileAccessResult far = null;
            ByteArrayOutputStream memOut = new ByteArrayOutputStream();
            try {
                FileIo io = new FileIo((Tree)gameData);
                io.save(memOut);
                far = JnlpIo.saveAsFile(new File(defaultName), new ByteArrayInputStream(memOut.toByteArray()));
            }
            catch (IOException excep) {
                Logger.getLogger("global").log(Level.WARNING, "CGuiClientUtil.save: Error saving", excep);
                new Errout(Defs.getString(-382651068, new Object[]{far == null ? "<unknown>" : far.getFileName(), excep.toString()}));
            }
        } else {
            defaultName = defaultName.substring(defaultName.lastIndexOf(47) + 1);
            File toSave = SelectFile.getFile(parent, Defs.getString(1096335309), defaultName, true);
            if (toSave != null) {
                this.saveTree(toSave, (Tree)gameData);
            }
        }
    }

    private void downloadFileChosen(File localFile, URL downloadUrl) {
        try {
            byte[] tmpBuf = new byte[4096];
            InputStream inStream = downloadUrl.openStream();
            FileOutputStream outStream = new FileOutputStream(localFile);
            int amtRead = inStream.read(tmpBuf);
            while (amtRead >= 0) {
                outStream.write(tmpBuf, 0, amtRead);
                amtRead = inStream.read(tmpBuf);
            }
            inStream.close();
            outStream.close();
            new MsgOut(Defs.getString(-382651076), Defs.getString(-382651067, localFile), 1);
        }
        catch (IOException ioExcep) {
            new Errout(Defs.getString(-382651068, new Object[]{localFile, ioExcep.toString()}));
        }
    }

    private void saveTree(File fileOut, Tree tree) {
        if (tree == null || tree.root == null) {
            return;
        }
        try {
            FileIo io = new FileIo(tree);
            io.save(fileOut);
        }
        catch (IOException excep) {
            new Errout(Defs.getString(1096335306, new Object[]{fileOut, excep.toString()}));
        }
    }

    @Override
    public AFrame createPrefsWindow(AFrame parent) {
        return new ConfigWindow(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uploadFile(CRoom room, AFrame parent, boolean isPrivate) {
        FileIo sgfFile;
        String error;
        File target;
        block10: {
            Rules rules;
            block9: {
                JnlpIo.FileAccessResult inResult = JnlpIo.openFile(null, new String[]{"sgf"});
                target = null;
                InputStream in = null;
                if (inResult == null) {
                    target = SelectFile.getFile((Component)parent, Defs.getString(-382651072), (File)null, false);
                } else if (inResult.isFileSelected()) {
                    target = new File(inResult.getFileName());
                    in = inResult.getInputStream();
                }
                if (target == null && in == null) return;
                error = null;
                sgfFile = new FileIo(target, in);
                rules = sgfFile.tree.root.findProp(0).getRules();
                if (rules.getHandicap() <= 9) break block9;
                error = Defs.getString(-382651032);
                if (error == null) return;
                new Errout(Defs.getString(1096335340, new Object[]{target, error}), parent);
                return;
            }
            if (!(rules.getKomi() < -100.0f) && !(rules.getKomi() > 100.0f)) break block10;
            error = Defs.getString(-382651078);
            if (error == null) return;
            new Errout(Defs.getString(1096335340, new Object[]{target, error}), parent);
            return;
        }
        try {
            ((KRoomPanel)this.client.objects.get(room)).upload(sgfFile.tree, sgfFile.getLoadWarnings(), isPrivate);
            if (error == null) return;
        }
        catch (Exception excep) {
            try {
                String string = error = excep.getMessage() == null ? excep.toString() : excep.getMessage();
                if (error == null) return;
            }
            catch (Throwable throwable) {
                if (error == null) throw throwable;
                new Errout(Defs.getString(1096335340, new Object[]{target, error}), parent);
                throw throwable;
            }
            new Errout(Defs.getString(1096335340, new Object[]{target, error}), parent);
            return;
        }
        new Errout(Defs.getString(1096335340, new Object[]{target, error}), parent);
        return;
    }

    @Override
    public JMenuItem createUploadPicMenuItem(AFrame clientWin) {
        return new UploadPicWindow.MenuItem(clientWin, this.client);
    }

    @Override
    public void showLoadWarnings(String warnings, Component source) {
        LoadWarningWindow.create(warnings, source);
    }

    @Override
    public boolean isRecordSupported() {
        return true;
    }
}

