/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.sgf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.igoweb.go.Loc;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;

public class IshiIo {
    private static final int EVENT_KEY = 0;
    private static final int ANALYSIS_KEY = 1;
    private static final int BLACK_KEY = 2;
    private static final int DATE_KEY = 3;
    private static final int HANDICAP_KEY = 4;
    private static final int KOMI_KEY = 5;
    private static final int PLACE_KEY = 6;
    private static final int RECORDER_KEY = 7;
    private static final int RESULT_KEY = 8;
    private static final int RULES_KEY = 9;
    private static final int SOURCE_KEY = 10;
    private static final int TIMELIMIT_KEY = 11;
    private static final int WHITE_KEY = 12;
    private static final int BLACKMOVE_KEY = 13;
    private static final int BOARDSIZE_KEY = 14;
    private static final int COM_KEY = 15;
    private static final int DIAGRAM_KEY = 16;
    private static final int ENDCOM_KEY = 17;
    private static final int ENDUSER_KEY = 18;
    private static final int ENDVAR_KEY = 19;
    private static final int HIDE_KEY = 20;
    private static final int MARK_KEY = 21;
    private static final int PRISONER_KEY = 22;
    private static final int REMARK_KEY = 23;
    private static final int SETUP_KEY = 24;
    private static final int UNMARK_KEY = 25;
    private static final int USER_KEY = 26;
    private static final int VAR_KEY = 27;
    private static final int WHITEMOVE_KEY = 28;
    private static final int NO_KEY = 29;
    private static final int EOF_KEY = -1;
    private static HashMap<String, Integer> keywords = new HashMap();

    public static Tree read(File fileIn) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileIn));
        Tree tree = new Tree();
        Line line = IshiIo.readHeader(tree, in);
        int boardSize = tree.root.findProp(0).getRules().getSize();
        while (line.keyword != -1 && line.keyword != 0) {
            line = IshiIo.readMove(tree, line, in, boardSize);
        }
        return tree;
    }

    private static Line readHeader(Tree tree, InputStream in) throws IOException {
        Rules rules = new Rules(19);
        tree.add(new Prop(0, rules));
        Line line = new Line(in, false);
        while (line.keyword == 23) {
            line = new Line(in, false);
        }
        if (line.keyword == 0) {
            line = new Line(in, false);
        }
        while (true) {
            switch (line.keyword) {
                case 1: {
                    tree.add(new Prop(12, line.remainder));
                    break;
                }
                case 2: {
                    tree.add(new Prop(2, 0, line.remainder));
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    rules.setHandicap(Integer.parseInt(line.remainder));
                    break;
                }
                case 14: {
                    rules.setSize(Integer.parseInt(line.remainder));
                    break;
                }
                case 5: {
                    rules.setKomi(Float.parseFloat(line.remainder));
                    break;
                }
                case 6: {
                    tree.add(new Prop(9, line.remainder));
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    tree.add(new Prop(2, 1, line.remainder));
                    break;
                }
                case 15: {
                    line = IshiIo.parseCom(tree, line, in);
                    break;
                }
                default: {
                    return line;
                }
            }
            line = new Line(in, false);
        }
    }

    private static Line readMove(Tree tree, Line line, InputStream in, int boardSize) throws IOException {
        tree.addNode();
        while (line.keyword == 23) {
            tree.add(new Prop(24, line.remainder + '\n'), true);
            line = new Line(in, false);
        }
        switch (line.keyword) {
            case 13: {
                IshiIo.parseMove(0, tree, line.tokens, boardSize);
                break;
            }
            case 28: {
                IshiIo.parseMove(1, tree, line.tokens, boardSize);
                break;
            }
            case 24: {
                break;
            }
            case 16: {
                break;
            }
            default: {
                return line;
            }
        }
        block14: while (true) {
            line = new Line(in, false);
            switch (line.keyword) {
                case 15: {
                    line = IshiIo.parseCom(tree, line, in);
                    continue block14;
                }
                case 26: {
                    IshiIo.parseUser(tree, line, in);
                    continue block14;
                }
                case 22: {
                    continue block14;
                }
                case 27: {
                    Node varStart = tree.getActiveNode();
                    tree.setActiveNode(varStart.parent);
                    line = new Line(in, false);
                    while (line.keyword != -1 && line.keyword != 19) {
                        line = IshiIo.readMove(tree, line, in, boardSize);
                    }
                    tree.setActiveNode(varStart);
                    continue block14;
                }
                case -1: 
                case 13: 
                case 16: 
                case 19: 
                case 24: 
                case 28: {
                    return line;
                }
            }
            break;
        }
        throw new RuntimeException();
    }

    private static void parseMove(int color, Tree tree, StringTokenizer tokens, int boardSize) {
        tokens.nextToken();
        Loc loc = IshiIo.parseLoc(tokens.nextToken(), boardSize);
        tree.add(new Prop(14, color, loc));
    }

    private static Loc parseLoc(String locStr, int boardSize) {
        if ((locStr = locStr.toLowerCase(Locale.US)).equals("pass")) {
            return Loc.PASS;
        }
        int x = locStr.charAt(0) - 97;
        if (x > 8) {
            --x;
        }
        return Loc.get(x, boardSize - Integer.parseInt(locStr.substring(1)));
    }

    private static Line parseCom(Tree tree, Line line, InputStream in) throws IOException {
        if (line.remainder.length() > 0) {
            tree.add(new Prop(24, line.remainder + '\n'), true);
        }
        line = new Line(in, true);
        while (line.keyword != -1 && line.keyword != 17) {
            tree.add(new Prop(24, line.text + '\n'), true);
            line = new Line(in, true);
        }
        return line;
    }

    private static Line parseUser(Tree tree, Line line, InputStream in) throws IOException {
        line = new Line(in, true);
        while (line.keyword != -1 && line.keyword != 18) {
            tree.add(new Prop(24, line.text + '\n'), true);
            line = new Line(in, true);
        }
        return line;
    }

    static {
        StringTokenizer keysInit = new StringTokenizer(" event 0 analysis 1 black 2 date 3 handicap 4 komi 5 place 6 recorder 7 result 8 rules 9 source 10 timelimit 11 white 12 b 13 boardsize 14 com 15 diagram 16 endcom 17 enduser 18 endvar 19 hide 20 mark 21 prisoner 22 remark 23 setup 24 unmark 25 user 26 var 27 w 28");
        while (keysInit.hasMoreTokens()) {
            String keyword = keysInit.nextToken();
            keywords.put(keyword, new Integer(Integer.parseInt(keysInit.nextToken())));
        }
    }

    private static class Line {
        public final String text;
        public final int keyword;
        public final String remainder;
        public final StringTokenizer tokens;

        public Line(InputStream in, boolean emptyOk) throws IOException {
            Integer kwResult;
            String kwStr;
            String data;
            do {
                StringBuilder buf = new StringBuilder();
                while (true) {
                    int c;
                    if ((c = in.read()) == -1) {
                        if (buf.length() != 0) break;
                        this.text = null;
                        this.keyword = -1;
                        this.remainder = null;
                        this.tokens = null;
                        return;
                    }
                    if (c == 10) break;
                    if (c == 9) {
                        buf.append(' ');
                        continue;
                    }
                    if (c < 32 || c > 126) continue;
                    buf.append((char)c);
                }
                data = buf.toString().trim();
            } while (!emptyOk && data.length() == 0);
            this.text = data;
            this.tokens = new StringTokenizer(this.text);
            if (this.tokens.hasMoreTokens()) {
                kwStr = this.tokens.nextToken().toLowerCase(Locale.US);
                kwResult = (Integer)keywords.get(kwStr);
            } else {
                kwStr = "";
                kwResult = null;
            }
            if (kwResult == null) {
                this.keyword = 29;
                this.remainder = this.text;
            } else {
                this.keyword = kwResult;
                this.remainder = this.text.substring(kwStr.length()).trim();
            }
        }
    }
}

