/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;

public class CommentWidget
extends JScrollPane
implements EventListener {
    private final Tree tree;
    private final JTextArea textViewer = new JTextArea();
    private Node ignoreChangeNode;

    public CommentWidget(Tree tree, boolean isEditable) {
        super(22, 31);
        this.setMinimumSize(new Dimension(20, 20));
        this.setPreferredSize(new Dimension(20, 20));
        this.setViewportView(this.textViewer);
        this.tree = tree;
        this.textViewer.setEditable(isEditable);
        this.textViewer.setLineWrap(true);
        this.textViewer.setWrapStyleWord(true);
    }

    @Override
    public void removeNotify() {
        this.tree.removeListener(this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        this.tree.addListener(this);
        this.textViewer.setText(this.getComments(this.tree.getActiveNode()));
        super.addNotify();
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 7) {
            Node node = this.tree.getNode((Integer)event.arg);
            this.updateComments(node);
            node = (Node)event.source;
            this.textViewer.setText(this.getComments(node));
            this.textViewer.setCaretPosition(0);
            this.ignoreChangeNode = null;
        } else if (event.source == this.tree.getActiveNode() && event.arg != null) {
            if (this.ignoreChangeNode == event.source) {
                this.ignoreChangeNode = null;
            } else {
                switch (event.type) {
                    case 2: {
                        Prop prop = (Prop)event.arg;
                        if (prop.type != 24) break;
                        this.textViewer.append(prop.getText());
                        break;
                    }
                    case 0: 
                    case 1: {
                        Prop param = (Prop)event.arg;
                        if (param.type != 24) break;
                        this.textViewer.setText(event.type == 1 ? "" : ((Prop)event.arg).getText());
                    }
                }
            }
        }
    }

    public void updateComments() {
        this.updateComments(this.tree.getActiveNode());
    }

    private void updateComments(Node node) {
        String currentComments;
        if (this.textViewer.isEditable() && !(currentComments = this.textViewer.getText()).equals(this.getComments(node))) {
            this.ignoreChangeNode = node;
            if (currentComments.trim().length() > 0) {
                node.add(new Prop(24, currentComments));
            } else {
                node.removeType(24);
            }
        }
    }

    private String getComments(Node node) {
        Prop param = node.findProp(24);
        String result = param == null ? "" : param.getText();
        if (result.length() == 0 && !this.textViewer.isEditable()) {
            return Defs.getString(-451068494);
        }
        return result;
    }
}

