/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JComponent;
import org.igoweb.go.swing.GamePanel;

public class GameLayout
implements LayoutManager2 {
    private final GamePanel panel;
    private Dimension titleSize;
    private Dimension ctrlSize;
    private Dimension boardSize;
    private Dimension chatSize;
    private boolean wide = true;
    private boolean firstTime = true;
    private static final int smGap = 2;

    public GameLayout(GamePanel panel) {
        this.panel = panel;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container cont) {
        Dimension size = cont.getSize();
        Insets insets = cont.getInsets();
        boolean newWide = this.wideConfig(size, insets);
        if (this.firstTime || newWide != this.wide) {
            this.setWide(newWide);
        }
        this.doLayout(cont, size, insets);
    }

    protected void doLayout(Container cont, Dimension size, Insets insets) {
        int boardW;
        Dimension prefDims = this.doPreferred(this.wide, insets);
        if (prefDims.width > size.width || prefDims.height > size.height) {
            prefDims = this.doMinimum(this.wide, insets);
            if (prefDims.width > size.width) {
                size.width = prefDims.width;
            }
            if (prefDims.height > size.height) {
                size.height = prefDims.height;
            }
        }
        int boardH = size.height - (insets.top + this.titleSize.height + 2 + insets.bottom);
        if (!this.wide) {
            boardH -= 2 + this.chatSize.height;
        }
        int w2 = this.ctrlSize.width;
        if (this.wide && this.chatSize.width > w2) {
            w2 = this.chatSize.width;
        }
        if ((boardW = this.getUsableBoardWidth(size.width - (insets.left + 2 + w2 + insets.right), boardH)) > boardH) {
            boardW = boardH;
        }
        if (!this.wide && boardH > boardW && (boardH = boardW) + this.titleSize.height + 2 < this.ctrlSize.height) {
            boardH = this.ctrlSize.height - (this.titleSize.height + 2);
        }
        this.panel.titlePanel.setBounds(insets.left, insets.top, boardW, this.titleSize.height);
        this.getMainWidget().setBounds(insets.left, insets.top + this.titleSize.height + 2, boardW, boardH);
        this.panel.controlPanel.setBounds(boardW += insets.left + 2, insets.top, size.width - (boardW + insets.right), this.ctrlSize.height);
        if (this.wide) {
            this.getCommentWidget().setBounds(boardW, insets.top + this.ctrlSize.height + 2, size.width - (boardW + insets.right), size.height - (insets.top + this.ctrlSize.height + 2 + insets.bottom));
        } else {
            this.getCommentWidget().setBounds(insets.left, insets.top + this.titleSize.height + boardH + 4, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom + this.titleSize.height + boardH + 4));
        }
    }

    public JComponent getCommentWidget() {
        return this.panel.getCommentWidget();
    }

    public JComponent getMainWidget() {
        return this.panel.getGobanWidget();
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        if (this.firstTime) {
            this.setWide(this.wide);
        }
        return this.doMinimum(this.wide, cont.getInsets());
    }

    protected Dimension doMinimum(boolean newWide, Insets insets) {
        this.titleSize = this.panel.titlePanel.getMinimumSize();
        this.ctrlSize = this.panel.controlPanel.getMinimumSize();
        this.boardSize = this.getMainWidget().getMinimumSize();
        this.chatSize = this.getCommentWidget().getMinimumSize();
        return this.doSize(newWide, insets);
    }

    @Override
    public Dimension preferredLayoutSize(Container cont) {
        if (this.firstTime) {
            this.setWide(this.wide);
        }
        return this.doPreferred(this.wide, cont.getInsets());
    }

    protected Dimension doPreferred(boolean newWide, Insets insets) {
        this.titleSize = this.panel.titlePanel.getPreferredSize();
        this.ctrlSize = this.panel.controlPanel.getPreferredSize();
        this.boardSize = this.getMainWidget().getPreferredSize();
        this.chatSize = this.getCommentWidget().getPreferredSize();
        return this.doSize(newWide, insets);
    }

    private Dimension doSize(boolean newWide, Insets insets) {
        int w2 = this.titleSize.width;
        int w = this.boardSize.width;
        if (w2 > w) {
            w = w2;
        }
        int h = this.titleSize.height + 2 + this.boardSize.height;
        w2 = this.ctrlSize.width;
        if (newWide) {
            int h2;
            if (this.chatSize.width > w2) {
                w2 = this.chatSize.width;
            }
            if ((h2 = this.ctrlSize.height + 2 + this.chatSize.height) > h) {
                h = h2;
            }
        } else {
            h += 2 + this.chatSize.height;
        }
        return new Dimension(insets.left + w + 2 + w2 + insets.right, insets.top + h + insets.bottom);
    }

    private boolean wideConfig(Dimension size, Insets insets) {
        return size.width - (insets.left + insets.right) > size.height - (insets.top + insets.bottom);
    }

    protected void setWide(boolean newWide) {
        this.firstTime = false;
        this.wide = newWide;
        this.panel.buildControlPanel(newWide);
    }

    public boolean isWide() {
        return this.wide;
    }

    protected int getUsableBoardWidth(int maxW, int maxH) {
        return maxH >= maxW ? maxW : maxH;
    }
}

