/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.igoweb.games.Clock;
import org.igoweb.go.Game;
import org.igoweb.go.Go;
import org.igoweb.go.swing.CapsWidget;
import org.igoweb.go.swing.Sounds;
import org.igoweb.go.swing.StoneIcon;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.ImageViewer;
import org.igoweb.util.swing.Prefs;

public class PlayerWidget
extends JPanel {
    public static final int WARN_PREF_V0 = 0;
    public static final int WARN_PREF_V1 = 1;
    public static final int WARN_V0_FLASH = 1;
    public static final int WARN_V0_SOUND = 2;
    private final int color;
    private String name;
    private boolean rankShown = true;
    private int rank;
    private final JPanel infoPanel;
    private final CapsWidget capsOut;
    private final JLabel scoreOut;
    private final JLabel timeOut;
    private boolean showScore = false;
    private boolean soundWarningEnabled = false;
    private final Game game;
    private final Clock clock;
    private final ImageViewer nameOut;
    private final Timer jTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlayerWidget.this.updateTimeOut();
        }
    });
    private boolean labSaysScore = false;
    private long beepPhase = Long.MAX_VALUE;
    private static final Color ledColor = new Color(255, 50, 50);
    public static final String TIME_WARNING_LEVEL_PREF = "j8,>s**Q";
    public static final String TIME_BY_WARNING_LEVEL_PREF = "sAvT{V(q";
    public static final String TIME_WARNING_OPTION_VERSION_PREF = "2u32vEZ6";
    public static final String TIME_WARNING_OPTION_V0_PREF = "Y&,g{0UU";
    public static final String TIME_WARNING_OPTION_V1_FLASH_PREF = "FR3L5pOD";
    public static final String TIME_WARNING_OPTION_V1_SOUND_PREF = "lBYLrt8m";
    private boolean timeInverted = false;
    private final EventListener clockChangeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (PlayerWidget.this.clock.isStarted() && !PlayerWidget.this.clock.isPaused()) {
                PlayerWidget.this.animateClock();
            } else {
                PlayerWidget.this.jTimer.stop();
            }
            PlayerWidget.this.updateTimeOut();
        }
    };
    private final EventListener gameListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (PlayerWidget.this.labSaysScore != (PlayerWidget.this.showScore || PlayerWidget.this.game.isPlayOver()) || event.type == 1 || event.type == 4) {
                PlayerWidget.this.sync();
            }
        }
    };

    public PlayerWidget(int color, Game game, Clock clock, String name) {
        this(color, game, clock, name, 0);
    }

    public PlayerWidget(int color, Game game, Clock clock, String name, int rank) {
        this.getMainPanel().setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.color = color;
        this.game = game;
        this.clock = clock;
        this.name = name;
        this.rank = rank;
        Font font = UIManager.getFont("Label.font");
        Font boldFont = font.deriveFont(1);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new OverlayLayout(namePanel));
        this.nameOut = new ImageViewer(-1, -1){

            @Override
            public Dimension getMinimumSize() {
                Dimension result = super.getMinimumSize();
                result.width = 5;
                return result;
            }

            @Override
            public void reshape(int x, int y, int width, int height) {
                super.reshape(x, y, width, height);
                PlayerWidget.this.rebuildTitle();
            }
        };
        this.nameOut.setFont(boldFont);
        namePanel.add(this.nameOut);
        this.rebuildTitle();
        JPanel tsPanel = new JPanel(new GridLayout(1, 3, 0, 0));
        tsPanel.setOpaque(false);
        this.getMainPanel().add("North", namePanel);
        namePanel.add(tsPanel);
        namePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        for (int i = 0; i < 3; ++i) {
            tsPanel.add(new JLabel(new StoneIcon(color, i)));
        }
        CompoundBorder outBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, this.getBackground().darker(), Color.black), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel capsPanel = new JPanel(new GridLayout(2, 1, 2, 2));
        this.capsOut = new CapsWidget(Go.opponent(color));
        capsPanel.add(this.capsOut);
        this.capsOut.setFont(boldFont);
        JPanel timePanel = new JPanel(new CardLayout());
        this.timeOut = new JLabel("", 2);
        this.timeOut.setBorder(outBorder);
        this.timeOut.setFont(boldFont);
        this.timeOut.setBackground(Color.black);
        this.timeOut.setForeground(ledColor);
        this.timeOut.setOpaque(true);
        timePanel.add("a", this.timeOut);
        for (String sample : clock.getSampleReadouts()) {
            JLabel spacer = new JLabel(sample, 2);
            spacer.setBorder(outBorder);
            spacer.setFont(boldFont);
            timePanel.add(sample, spacer);
        }
        capsPanel.add(timePanel);
        JPanel scorePanel = new JPanel(new GridLayout(2, 1, 2, 2));
        scorePanel.add(new JLabel(Defs.getString(-451068484)));
        this.scoreOut = new JLabel("", 2);
        scorePanel.add(this.scoreOut);
        this.scoreOut.setFont(boldFont);
        this.scoreOut.setBackground(Color.black);
        this.scoreOut.setForeground(ledColor);
        this.scoreOut.setBorder(outBorder);
        this.scoreOut.setOpaque(true);
        this.infoPanel = new JPanel(new CardLayout());
        this.getMainPanel().add(this.infoPanel);
        this.infoPanel.add("caps", capsPanel);
        this.infoPanel.add("score", scorePanel);
        ((CardLayout)this.infoPanel.getLayout()).first(this.infoPanel);
        this.updateTimeOut();
        this.sync();
    }

    protected JComponent getMainPanel() {
        return this;
    }

    private void sync() {
        if (this.showScore || this.game.isPlayOver()) {
            String newScore;
            if (!this.labSaysScore) {
                this.labSaysScore = true;
                ((CardLayout)this.infoPanel.getLayout()).last(this.infoPanel);
            }
            if (!(newScore = Game.SCORE_FORMATTER.format(this.game.getScore(this.color))).equals(this.scoreOut.getText())) {
                this.scoreOut.setText(newScore);
            }
        } else {
            if (this.labSaysScore) {
                this.labSaysScore = false;
                ((CardLayout)this.infoPanel.getLayout()).first(this.infoPanel);
            }
            this.capsOut.setCaps(this.game.caps(this.color));
            this.updateTimeOut();
        }
    }

    @Override
    public void addNotify() {
        this.clock.addListener(this.clockChangeListener);
        this.game.addListener(this.gameListener);
        this.sync();
        if (this.clock.isStarted() && !this.clock.isPaused()) {
            this.animateClock();
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.clock.removeListener(this.clockChangeListener);
        this.game.removeListener(this.gameListener);
        this.jTimer.stop();
        super.removeNotify();
    }

    public void setPaused(boolean newPauseValue) {
        this.clock.setPaused(newPauseValue);
    }

    private void updateTimeOut() {
        boolean needsInvert;
        boolean thisGameHasWarningSound;
        long newBeepPhase;
        int timeSystem = this.game.getRules().getTimeSystem();
        WarnSoundOption warningSound = PlayerWidget.getWarningSoundOption();
        int countdownTime = (timeSystem == 2 || timeSystem == 3) && this.clock.isFinalPeriod() ? this.game.getRules().getByoYomiTime() : this.game.getRules().getMainTime();
        long secsLeft = this.clock.getPeriodMsLeft() / 1000L;
        if (warningSound.isSpokenCountdown) {
            newBeepPhase = secsLeft >= 0L ? this.clock.getTotalMsLeft(0L) / 1000L : Long.MAX_VALUE;
        } else if (this.clock.isFinalPeriod()) {
            newBeepPhase = secsLeft;
            if (secsLeft > 0L) {
                newBeepPhase = secsLeft <= 10L ? (newBeepPhase - 1L & 0xFFFFFFFFFFFFFFFEL) + 1L : newBeepPhase - 1L - (newBeepPhase - 1L) % 10L;
            }
        } else {
            newBeepPhase = Long.MAX_VALUE;
        }
        boolean bl = thisGameHasWarningSound = warningSound != WarnSoundOption.NONE && Defs.isSoundEnabled() && this.soundWarningEnabled;
        if (thisGameHasWarningSound) {
            warningSound.warmupSoundCache();
        }
        if (thisGameHasWarningSound && secsLeft <= (long)PlayerWidget.getTimeWarningLevel(timeSystem) && newBeepPhase < this.beepPhase) {
            String clipName = null;
            if (warningSound == WarnSoundOption.BEEP) {
                clipName = warningSound.getFilenameForCount(1);
            } else if (warningSound.isSpokenCountdown && countdownTime > 1 && secsLeft >= 0L && secsLeft < 10L) {
                countdownTime = Math.min(countdownTime, 10);
                if (secsLeft == 9L) {
                    clipName = warningSound.getFilenameForTenSecondsWarning();
                } else if (secsLeft == (long)(countdownTime - 1)) {
                    if (this.clock.isFinalPeriod()) {
                        clipName = warningSound.getFilenameForCount(countdownTime);
                    }
                } else if (secsLeft < (long)countdownTime) {
                    clipName = warningSound.getFilenameForCount((int)((long)(countdownTime - 1) - secsLeft));
                }
            }
            if (clipName != null) {
                Sounds.get(clipName).play();
            }
        }
        this.beepPhase = newBeepPhase;
        boolean bl2 = needsInvert = this.clock.isStarted() && (secsLeft & 1L) != 0L && this.clock.isFinalPeriod() && PlayerWidget.getWarningFlashOption() && secsLeft < (long)PlayerWidget.getTimeWarningLevel(timeSystem);
        if (needsInvert != this.timeInverted) {
            this.timeInverted = needsInvert;
            if (needsInvert) {
                this.timeOut.setForeground(Color.black);
                this.timeOut.setBackground(Color.white);
            } else {
                this.timeOut.setForeground(ledColor);
                this.timeOut.setBackground(Color.black);
            }
        }
        this.timeOut.setText(this.clock.getCurrentReadout());
    }

    public void setShowScore(boolean newShowScore) {
        if (newShowScore != this.showScore) {
            this.showScore = newShowScore;
            this.sync();
        }
    }

    public void setSoundWarningEnabled(boolean newVal) {
        this.soundWarningEnabled = newVal;
    }

    public static int getTimeWarningLevel(int timeSystem) {
        if (timeSystem == 2) {
            return Prefs.getInt(TIME_BY_WARNING_LEVEL_PREF, 10);
        }
        return Prefs.getInt(TIME_WARNING_LEVEL_PREF, 60);
    }

    public static void setTimeWarningLevel(int timeSystem, int newLevel) {
        Prefs.putInt(timeSystem == 2 ? TIME_BY_WARNING_LEVEL_PREF : TIME_WARNING_LEVEL_PREF, newLevel);
    }

    public static void migrateWarningOptions() {
        int ver = Prefs.getInt(TIME_WARNING_OPTION_VERSION_PREF, 0);
        if (ver == 0) {
            int v0Pref = Prefs.getInt(TIME_WARNING_OPTION_V0_PREF, 1);
            Prefs.putBoolean(TIME_WARNING_OPTION_V1_FLASH_PREF, (v0Pref & 1) != 0);
            Prefs.putInt(TIME_WARNING_OPTION_V1_SOUND_PREF, ((v0Pref & 2) != 0 ? WarnSoundOption.BEEP : WarnSoundOption.NONE).ordinal());
            Prefs.putInt(TIME_WARNING_OPTION_VERSION_PREF, 1);
        }
    }

    public static boolean getWarningFlashOption() {
        PlayerWidget.migrateWarningOptions();
        return Prefs.getBoolean(TIME_WARNING_OPTION_V1_FLASH_PREF, true);
    }

    public static WarnSoundOption getWarningSoundOption() {
        PlayerWidget.migrateWarningOptions();
        int ordinal = Prefs.getInt(TIME_WARNING_OPTION_V1_SOUND_PREF, WarnSoundOption.NONE.ordinal());
        if (ordinal >= 0 && ordinal < WarnSoundOption.values().length) {
            return WarnSoundOption.values()[ordinal];
        }
        return WarnSoundOption.NONE;
    }

    public static void setWarningFlashOption(boolean newOption) {
        PlayerWidget.migrateWarningOptions();
        Prefs.putBoolean(TIME_WARNING_OPTION_V1_FLASH_PREF, newOption);
    }

    public static void setWarningSoundOption(WarnSoundOption newOption) {
        PlayerWidget.migrateWarningOptions();
        Prefs.putInt(TIME_WARNING_OPTION_V1_SOUND_PREF, newOption.ordinal());
    }

    private void animateClock() {
        if (!this.jTimer.isRunning() && this.clock.getPeriodMsLeft() >= 0L) {
            int initDelay = (int)(this.clock.getPeriodMsLeft() % 1000L);
            if (initDelay == 0) {
                initDelay = 1000;
            }
            this.jTimer.setInitialDelay(initDelay);
            this.jTimer.start();
        }
    }

    private static Image buildTextImg(String msg, int prefWidth) {
        Font font = UIManager.getFont("Label.font").deriveFont(1);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
        GlyphVector gv = font.createGlyphVector(frc, GuiUtil.makeStringFit(msg, font, frc, prefWidth));
        Rectangle2D bounds = gv.getOutline().getBounds2D();
        int w = (int)Math.ceil(bounds.getWidth()) + 4;
        int h = (int)Math.ceil(bounds.getHeight()) + 4;
        BufferedImage raw = new BufferedImage(w, h, 10);
        Graphics2D g2d = (Graphics2D)raw.getGraphics();
        g2d.setColor(Color.white);
        g2d.drawGlyphVector(gv, (float)(0.5 * ((double)w - (bounds.getMinX() + bounds.getMaxX()))), (float)(0.5 * ((double)h - (bounds.getMinY() + bounds.getMaxY()))));
        BufferedImage result = new BufferedImage(w - 2, h - 2, 2);
        for (int y = 1; y < h - 1; ++y) {
            for (int x = 1; x < w - 1; ++x) {
                int myColor = raw.getRGB(x, y) & 0xFF;
                int c = myColor * 4 + 2 + (raw.getRGB(x - 1, y - 1) & 0xFF) * 2 + (raw.getRGB(x, y - 1) & 0xFF) * 3 + (raw.getRGB(x + 1, y - 1) & 0xFF) * 2 + (raw.getRGB(x - 1, y) & 0xFF) * 3 + (raw.getRGB(x + 1, y) & 0xFF) * 3 + (raw.getRGB(x - 1, y + 1) & 0xFF) * 2 + (raw.getRGB(x, y + 1) & 0xFF) * 3 + (raw.getRGB(x + 1, y + 1) & 0xFF) * 2;
                myColor = 255 - myColor;
                c = c > 1020 ? 1020 : c & 0x3FC;
                result.setRGB(x - 1, y - 1, c << 22 | myColor << 16 | myColor << 8 | myColor);
            }
        }
        return result;
    }

    public void setRankShown(boolean shown) {
        if (this.rankShown != shown) {
            this.rankShown = shown;
            if (this.rank != 0) {
                this.rebuildTitle();
            }
        }
    }

    public void setRank(int newRank) {
        if (newRank != this.rank && this.rank >= 0) {
            this.rank = newRank;
            this.rebuildTitle();
        }
    }

    public void setPlayerName(String newName) {
        if (newName != null && !newName.equals(this.name)) {
            this.name = newName;
            this.rebuildTitle();
        }
    }

    private void rebuildTitle() {
        String nameText = !this.rankShown || this.rank == 0 ? this.name : this.name + " [" + Go.formatRank(this.rank) + ']';
        this.nameOut.setToolTipText(nameText);
        int prefWidth = this.nameOut.getWidth() - 6;
        if (prefWidth < 10) {
            prefWidth = this.nameOut.getFont().getSize() * 12;
        }
        Image textImg = PlayerWidget.buildTextImg(nameText, prefWidth);
        this.nameOut.setImage(textImg, textImg.getWidth(null), textImg.getHeight(null));
    }

    public Clock getClock() {
        return this.clock;
    }

    public static final class WarnSoundOption
    extends Enum<WarnSoundOption> {
        public static final /* enum */ WarnSoundOption NONE = new WarnSoundOption(null, false, -903340671);
        public static final /* enum */ WarnSoundOption BEEP = new WarnSoundOption("timeWarning", false, -903340796);
        public static final /* enum */ WarnSoundOption COUNTDOWN = new WarnSoundOption("countdown-en", true, -903340456);
        private final String filename;
        private final boolean isSpokenCountdown;
        public final int uiRes;
        private boolean cacheWarmed;
        private static final /* synthetic */ WarnSoundOption[] $VALUES;

        public static WarnSoundOption[] values() {
            return (WarnSoundOption[])$VALUES.clone();
        }

        public static WarnSoundOption valueOf(String name) {
            return Enum.valueOf(WarnSoundOption.class, name);
        }

        private WarnSoundOption(String filename, boolean isSpokenCountdown, int uiRes) {
            this.filename = filename;
            this.isSpokenCountdown = isSpokenCountdown;
            this.uiRes = uiRes;
            this.cacheWarmed = false;
        }

        public String getFilenameForCount(int seconds) {
            assert (seconds >= 1 && seconds <= 10);
            return this.isSpokenCountdown ? String.format("%s-%02d", this.filename, seconds) : this.filename;
        }

        public String getFilenameForTenSecondsWarning() {
            assert (this.isSpokenCountdown);
            return String.format("%s-10sec", this.filename);
        }

        public void warmupSoundCache() {
            if (this.cacheWarmed) {
                return;
            }
            if (this.isSpokenCountdown) {
                Sounds.get(this.getFilenameForTenSecondsWarning());
                for (int i = 1; i <= 10; ++i) {
                    Sounds.get(this.getFilenameForCount(i));
                }
            } else if (this.filename != null) {
                Sounds.get(this.filename);
            }
            this.cacheWarmed = true;
        }

        static {
            $VALUES = new WarnSoundOption[]{NONE, BEEP, COUNTDOWN};
        }
    }
}

