/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.metal.MetalButtonUI;
import org.igoweb.igoweb.client.CChallenge;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.IgowebIcon;
import org.igoweb.igoweb.client.swing.UserRenderer;
import org.igoweb.igoweb.shared.GameAction;
import org.igoweb.igoweb.shared.Proposal;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.GCLayout;

public abstract class ChallengePlayer<UserRoleT extends Proposal.UserRole<User>, PropT extends Proposal<User, UserRoleT, PropT>>
extends JPanel
implements ActionListener {
    public static final int CHANGE_ROLE_EVENT = 0;
    public static final int CHANGE_USER_EVENT = 1;
    public static final int DECLINE_USER_EVENT = 2;
    private static final String ROLE_BUTTON_KEY = "a";
    private static final String ROLE_LABEL_KEY = "b";
    public final int playerNum;
    private CChallenge<PropT> chal;
    protected final Client client;
    public final boolean isCreator;
    private final CardLayout leftRoleLayout = new CardLayout();
    private final JPanel leftRolePanel = new JPanel(this.leftRoleLayout);
    private JLabel leftRoleLabel;
    private JButton leftRoleButton;
    private JButton playerInfoBut;
    private JComboBox<User> playerChooser;
    private UserRenderer playerViewer;
    private JLabel readyLabel;
    private final JButton declineBut;
    private final CardLayout rightRoleLayout = new CardLayout();
    private final JPanel rightRolePanel = new JPanel(this.rightRoleLayout);
    private JLabel rightRoleLabel;
    private JButton rightRoleButton;
    private final EventListener listener;

    public ChallengePlayer(Client newClient, EventListener newListener, boolean newIsCreator, PropT proposal, int newPlayerNum, CChallenge<PropT> newChal) {
        super(new GCLayout());
        this.client = newClient;
        this.listener = newListener;
        this.playerNum = newPlayerNum;
        this.isCreator = newIsCreator;
        this.chal = newChal;
        JComponent extraWidget = this.buildExtraWidget(proposal);
        Icon icon = this.buildIcon(proposal, true);
        String iconDesc = "xGrow=f,yGrow=f,ySpan=2,fill=v";
        String playerInfoDesc = "ySpan=1,yGrow=t";
        if (extraWidget == null) {
            iconDesc = "xGrow=f,yGrow=f,fill=v";
            playerInfoDesc = null;
        }
        Border border = BorderFactory.createLineBorder(new Color(0x999999));
        this.leftRoleLabel = new JLabel(icon);
        this.leftRolePanel.add(ROLE_LABEL_KEY, this.leftRoleLabel);
        this.leftRoleLabel.setBorder(border);
        this.leftRoleLabel.setOpaque(true);
        this.leftRoleButton = new JButton(icon);
        this.leftRolePanel.add(ROLE_BUTTON_KEY, this.leftRoleButton);
        this.leftRoleButton.setUI((ButtonUI)MetalButtonUI.createUI(this.leftRoleButton));
        this.leftRoleButton.setOpaque(true);
        this.leftRoleButton.addActionListener(this);
        this.add(iconDesc, this.leftRolePanel);
        this.playerInfoBut = new JButton(Defs.getString(-903340824));
        this.playerInfoBut.setToolTipText(Defs.getString(-903340554));
        this.playerInfoBut.addActionListener(this);
        this.add(playerInfoDesc, this.playerInfoBut);
        this.playerViewer = new UserRenderer(newClient);
        this.playerViewer.setShowHelpful(true);
        if (!newIsCreator || this.isPlayerFixed()) {
            this.add("fill=h,xGrow=t", this.playerViewer);
            this.playerViewer.setBorder(border);
            this.declineBut = null;
        } else {
            this.playerChooser = new JComboBox();
            this.playerChooser.setRenderer(this.playerViewer);
            this.playerChooser.addItem(UserRenderer.NULL_USER);
            this.playerChooser.addActionListener(this);
            this.add("fill=h,xGrow=t", this.playerChooser);
            this.declineBut = new JButton(new IgowebIcon(0));
            this.declineBut.setToolTipText(Defs.getString(-903340647));
            this.declineBut.addActionListener(this);
            this.add("xGrow=f,yGrow=f", this.declineBut);
        }
        this.readyLabel = new JLabel("\u2713");
        Font curFont = this.readyLabel.getFont();
        this.readyLabel.setFont(curFont.deriveFont((float)curFont.getSize() * 2.0f));
        this.add("fill=0,xGrow=f", this.readyLabel);
        icon = this.buildIcon(proposal, false);
        this.rightRoleLabel = new JLabel(icon);
        this.rightRolePanel.add(ROLE_LABEL_KEY, this.rightRoleLabel);
        this.rightRoleLabel.setBorder(border);
        this.rightRoleLabel.setOpaque(true);
        this.rightRoleButton = new JButton(icon);
        this.rightRolePanel.add(ROLE_BUTTON_KEY, this.rightRoleButton);
        this.rightRoleButton.setUI((ButtonUI)MetalButtonUI.createUI(this.rightRoleButton));
        this.rightRoleButton.setOpaque(true);
        this.rightRoleButton.addActionListener(this);
        this.add(iconDesc, this.rightRolePanel);
        if (extraWidget != null) {
            this.add("x=1,y=1,yGrow=t,ySpan=1,xSpan=3,fill=1", extraWidget);
        }
    }

    public void updateGui(PropT proposal, GameAction action, boolean isCurrent) {
        boolean roleEnabled = this.isRoleEnabled(proposal, action);
        this.leftRoleButton.setEnabled(roleEnabled);
        this.rightRoleButton.setEnabled(roleEnabled);
        if (this.playerChooser != null) {
            this.playerChooser.setEnabled(action == GameAction.CHALLENGE_SETUP);
        }
        Object userRole = ((Proposal)proposal).getUserRole((int)this.playerNum);
        Object user = ((Proposal.UserRole)userRole).getUser();
        this.readyLabel.setForeground(isCurrent && this.chal != null && user != null && this.chal.getAction(((User)user).name) == GameAction.CHALLENGE_WAIT ? this.getForeground() : this.readyLabel.getBackground());
        if (this.declineBut != null) {
            this.declineBut.setEnabled(this.chal != null && user != null && this.chal.getRole(((User)user).name) == null);
        }
        if (this.playerChooser == null) {
            this.playerViewer.setUser((User)user);
            this.playerViewer.repaint();
        } else {
            this.playerChooser.setSelectedItem(user);
        }
        this.updateRoleCards(proposal);
        Icon icon = this.buildIcon(proposal, true);
        this.leftRoleButton.setIcon(icon);
        this.leftRoleLabel.setIcon(icon);
        icon = this.buildIcon(proposal, false);
        this.rightRoleButton.setIcon(icon);
        this.rightRoleLabel.setIcon(icon);
    }

    protected boolean isRoleEnabled(PropT proposal, GameAction action) {
        return this.isCreator && action == GameAction.CHALLENGE_SETUP;
    }

    public User getUser() {
        User result = this.playerChooser == null ? this.playerViewer.getUser() : (User)this.playerChooser.getSelectedItem();
        return result == UserRenderer.NULL_USER ? null : result;
    }

    public void setUser(User user) {
        if (this.playerChooser == null) {
            this.playerViewer.setUser(user);
            this.listener.handleEvent(new Event(this, 1, user));
        } else {
            this.playerChooser.setSelectedItem(user == null ? UserRenderer.NULL_USER : user);
        }
    }

    private void updateRoleCards(PropT proposal) {
        String key = this.isRoleFixed(proposal) ? ROLE_LABEL_KEY : ROLE_BUTTON_KEY;
        this.leftRoleLayout.show(this.leftRolePanel, key);
        this.rightRoleLayout.show(this.rightRolePanel, key);
    }

    protected abstract Icon buildIcon(PropT var1, boolean var2);

    protected boolean isRoleFixed(PropT proposal) {
        return this.isCreator;
    }

    protected abstract boolean isPlayerFixed();

    protected JComponent buildExtraWidget(PropT proposal) {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.leftRoleButton || src == this.rightRoleButton) {
            this.listener.handleEvent(new Event(this, 0));
        } else if (src == this.playerInfoBut) {
            User u;
            User user = u = this.playerChooser == null ? this.playerViewer.getUser() : (User)this.playerChooser.getSelectedItem();
            if (u != null) {
                this.client.requestUserDetails(u.name);
            }
        } else if (src == this.playerChooser) {
            this.listener.handleEvent(new Event(this, 1, this.getUser()));
        } else if (src == this.declineBut) {
            User u = this.getUser();
            if (this.chal != null && u != null) {
                this.listener.handleEvent(new Event(this, 2, u));
            }
        }
    }

    protected CChallenge<PropT> getChallenge() {
        return this.chal;
    }

    void setChallenge(CChallenge<PropT> newChal) {
        this.chal = newChal;
    }

    public void add(User user) {
        if (user == this.client.getMe()) {
            throw new RuntimeException();
        }
        if (this.playerChooser != null) {
            this.playerChooser.addItem(user);
        }
    }

    public void remove(User user) {
        if (this.playerChooser != null) {
            if (this.playerChooser.getSelectedItem() == user) {
                this.playerChooser.setSelectedIndex(0);
            }
            this.playerChooser.removeItem(user);
        }
    }

    public void highlightChanges(PropT expectedProposal, PropT proposal) {
        Color userBg;
        Color roleBg = this.isRoleLit(expectedProposal, proposal) ? UIManager.getColor("org.igoweb.highlightBg") : this.getBackground();
        this.leftRoleButton.setBackground(roleBg);
        this.rightRoleButton.setBackground(roleBg);
        this.leftRoleLabel.setBackground(roleBg);
        this.rightRoleLabel.setBackground(roleBg);
        Color color = userBg = this.isUserLit(expectedProposal, proposal) ? UIManager.getColor("org.igoweb.highlightBg") : this.getBackground();
        if (this.playerChooser != null) {
            this.playerChooser.setBackground(userBg);
        }
        if (this.playerViewer != null) {
            this.playerViewer.setBackground(userBg);
        }
    }

    protected boolean isRoleLit(PropT expected, PropT found) {
        if (expected == null || this.playerNum >= ((Proposal)expected).getUserRoles().size() || this.playerNum >= ((Proposal)found).getUserRoles().size()) {
            return false;
        }
        Object expectedUR = ((Proposal)expected).getUserRole((int)this.playerNum);
        Object foundUR = ((Proposal)found).getUserRole((int)this.playerNum);
        Role expectedRole = ((Proposal.UserRole)expectedUR).getRole();
        if (expectedRole != null && expectedRole != ((Proposal.UserRole)foundUR).getRole()) {
            return true;
        }
        Object expectedPlayer = ((Proposal.UserRole)expectedUR).getUser();
        return expectedPlayer != null && expectedPlayer != ((Proposal.UserRole)foundUR).getUser();
    }

    protected boolean isUserLit(PropT expected, PropT found) {
        if (expected == null || this.playerNum >= ((Proposal)expected).getUserRoles().size() || this.playerNum >= ((Proposal)found).getUserRoles().size()) {
            return false;
        }
        Object expectedUser = ((Proposal.UserRole)((Proposal)expected).getUserRole((int)this.playerNum)).getUser();
        return expectedUser != null && expectedUser != ((Proposal.UserRole)((Proposal)found).getUserRole((int)this.playerNum)).getUser();
    }

    public boolean isPlayerValid() {
        return true;
    }

    public void read(PropT proposal) {
    }
}

