/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.shared.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.igoweb.igoweb.shared.IBundle;

public class RankGraph
extends JComponent {
    public final String name;
    private short[] data = null;
    private Runnable dataFetcher;
    private IBundle bundle;

    public RankGraph(String newName, Runnable newDataFetcher, IBundle newBundle) {
        this.name = newName;
        this.dataFetcher = newDataFetcher;
        this.bundle = newBundle;
    }

    public RankGraph(String newName, short[] newData, IBundle newBundle) {
        this.name = newName;
        this.data = newData;
        this.bundle = newBundle;
    }

    public void setData(short[] newData) {
        this.data = newData;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.data == null) {
            if (this.dataFetcher != null) {
                this.dataFetcher.run();
                this.dataFetcher = null;
            }
            return;
        }
        g.setColor(UIManager.getColor("org.igoweb.stdBg"));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(4, 4);
        g.setFont(UIManager.getFont("Label.font"));
        this.drawGraph(g, this.getWidth() - 8, this.getHeight() - 8);
    }

    public void drawGraph(Graphics g, int w, int h) {
        int numVals = this.data.length;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Font font = g2d.getFont();
        Calendar endCal = Calendar.getInstance(this.bundle.locale);
        Calendar startCal = (Calendar)endCal.clone();
        startCal.add(6, -numVals);
        String title = this.bundle.str(this.data.length > 1 ? -669080760 : -669080759, new Object[]{this.name, startCal.getTime(), endCal.getTime()});
        Rectangle2D txtBnd = font.getStringBounds(title, g2d.getFontRenderContext());
        g2d.setColor(Color.black);
        g2d.drawString(title, (float)(((double)w - txtBnd.getWidth()) * 0.5 - txtBnd.getMinX()), -((float)txtBnd.getMinY()));
        if (this.data.length <= 1) {
            return;
        }
        ArrayList<Date> monthLocs = new ArrayList<Date>();
        ArrayList<String> monthLabels = new ArrayList<String>();
        ArrayList<Rectangle2D> monthSizes = new ArrayList<Rectangle2D>();
        ArrayList<Date> yearLocs = new ArrayList<Date>();
        ArrayList<String> yearLabels = new ArrayList<String>();
        ArrayList<Rectangle2D> yearSizes = new ArrayList<Rectangle2D>();
        startCal.set(11, 0);
        Date endCalDate = endCal.getTime();
        Date startCalDate = startCal.getTime();
        startCal.set(5, 1);
        int lastYear = -1;
        DateFormatSymbols dfs = new DateFormatSymbols(this.bundle.locale);
        double maxDateH = 0.0;
        double maxDateAscent = 0.0;
        while (startCal.getTime().compareTo(endCalDate) < 0) {
            monthLocs.add(startCal.getTime());
            String mn = dfs.getShortMonths()[startCal.get(2)];
            monthLabels.add(mn);
            txtBnd = font.getStringBounds(mn, g2d.getFontRenderContext());
            monthSizes.add(txtBnd);
            if (txtBnd.getHeight() > maxDateH) {
                maxDateH = txtBnd.getHeight();
            }
            if (txtBnd.getMinY() < maxDateAscent) {
                maxDateAscent = txtBnd.getMinY();
            }
            if (startCal.get(1) != lastYear) {
                lastYear = startCal.get(1);
                yearLocs.add(startCal.getTime());
                mn = Integer.toString(lastYear);
                yearLabels.add(mn);
                txtBnd = font.getStringBounds(mn, g2d.getFontRenderContext());
                yearSizes.add(txtBnd);
                if (txtBnd.getHeight() > maxDateH) {
                    maxDateH = txtBnd.getHeight();
                }
                if (txtBnd.getMinY() < maxDateAscent) {
                    maxDateAscent = txtBnd.getMinY();
                }
            }
            startCal.add(2, 1);
        }
        maxDateAscent = -maxDateAscent;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < numVals; ++i) {
            if (this.data[i] == Short.MAX_VALUE) continue;
            this.data[i] = (short)Math.min(Math.max(this.data[i], this.bundle.getRankGraphMinimumValue()), this.bundle.getRankGraphMaximumValue());
            if (this.data[i] > max) {
                max = this.data[i];
            }
            if (this.data[i] >= min) continue;
            min = this.data[i];
        }
        if (min == max) {
            ++max;
        }
        int granularity = this.bundle.getRankGraphGranularity();
        min = (int)((double)granularity * Math.floor((double)min / (double)granularity));
        max = (int)((double)granularity * Math.ceil((double)max / (double)granularity));
        int j = 0;
        double maxRankW = 0.0;
        double maxRankH = 0.0;
        String[] labels = new String[(max - min) / granularity + 1];
        Rectangle2D[] labelRects = new Rectangle2D[(max - min) / granularity + 1];
        int i = min;
        while (i <= max) {
            labels[j] = this.bundle.formatRankGraphValue(i);
            labelRects[j] = font.getStringBounds(labels[j], g2d.getFontRenderContext());
            if (labelRects[j].getWidth() > maxRankW) {
                maxRankW = labelRects[j].getWidth();
            }
            if (labelRects[j].getHeight() > maxRankH) {
                maxRankH = labelRects[j].getHeight();
            }
            i += granularity;
            ++j;
        }
        int boxX = (int)Math.ceil(maxRankW) + 2;
        int boxY = (int)Math.ceil(txtBnd.getHeight()) + 2;
        int boxW = w - boxX;
        int boxH = h - boxY - (int)Math.ceil(2.0 * maxDateH) - 4;
        g2d.fillRect(boxX, boxY, boxW, boxH);
        if (numVals == 0) {
            return;
        }
        float xMul = ((float)boxW - 1.0f) / (float)(numVals - 1);
        float xAdd = (float)boxX + 0.5f;
        float yMul = ((float)boxH - 1.0f) / (float)(min - max);
        float yAdd = (float)boxY - (float)max * yMul + 0.5f;
        GeneralPath path = new GeneralPath(0, numVals);
        BasicStroke stroker = new BasicStroke(1.0f);
        j = 0;
        int i2 = min;
        while (i2 <= max) {
            path.moveTo(xAdd, (float)i2 * yMul + yAdd);
            path.lineTo((float)boxW - 1.0f + xAdd, (float)i2 * yMul + yAdd);
            g2d.drawString(labels[j], (float)(maxRankW - labelRects[j].getMaxX()), (float)((double)((float)i2 * yMul + yAdd) - labelRects[j].getMinY() * 0.5));
            i2 += granularity;
            ++j;
        }
        g2d.setColor(new Color(0.5f, 0.5f, 0.5f));
        g2d.fill(stroker.createStrokedShape(path));
        path.reset();
        boolean moveToRequired = true;
        path.moveTo(xAdd, (float)this.data[0] * yMul + yAdd);
        for (int i3 = 0; i3 < numVals; ++i3) {
            short val = this.data[i3];
            if (val == Short.MAX_VALUE) {
                if (moveToRequired) continue;
                path.lineTo(((float)i3 - 0.75f) * xMul + xAdd, (float)this.data[i3 - 1] * yMul + yAdd);
                moveToRequired = true;
                continue;
            }
            if (moveToRequired) {
                path.moveTo(i3 == 0 ? xAdd : ((float)i3 - 0.25f) * xMul + xAdd, (float)this.data[i3] * yMul + yAdd);
                moveToRequired = false;
                continue;
            }
            path.lineTo((float)i3 * xMul + xAdd, (float)this.data[i3] * yMul + yAdd);
        }
        if (!moveToRequired && numVals > 1) {
            path.lineTo((float)(numVals - 1) * xMul + xAdd, (float)this.data[numVals - 1] * yMul + yAdd);
        }
        g2d.setColor(Color.green);
        g2d.fill(stroker.createStrokedShape(path));
        g2d.setColor(Color.black);
        RankGraph.drawDates(g2d, stroker, xAdd, (float)(boxY + boxH) - 0.5f, (float)boxW - 1.0f, (float)(maxDateAscent + 2.5), (float)(maxDateH + 2.5), monthLocs, monthLabels, monthSizes, yearLocs, startCalDate.getTime(), endCalDate.getTime());
        RankGraph.drawDates(g2d, stroker, xAdd, (float)(boxY + boxH) + -0.5f, (float)boxW - 1.0f, (float)(maxDateAscent + maxDateH + 4.5), (float)(2.0 * maxDateH + 4.5), yearLocs, yearLabels, yearSizes, null, startCalDate.getTime(), endCalDate.getTime());
        g2d.setColor(Color.white);
        g2d.fill(stroker.createStrokedShape(new Rectangle2D.Float((float)boxX + 0.5f, (float)boxY + 0.5f, (float)boxW - 1.0f, (float)boxH - 1.0f)));
    }

    private static void drawDates(Graphics2D g2d, BasicStroke stroker, float x, float y, float w, float ascent, float height, ArrayList<Date> locs, ArrayList<String> labels, ArrayList<Rectangle2D> sizes, ArrayList<Date> noDrawLocs, long startDate, long endDate) {
        GeneralPath gp = new GeneralPath();
        if (locs.size() == 1) {
            Rectangle2D r2d = sizes.get(0);
            g2d.drawString(labels.get(0), (float)((double)x + ((double)w - r2d.getWidth()) * 0.5 - r2d.getMinX()), y + ascent);
            return;
        }
        int noDrawIndex = 0;
        long noDrawMilli = 0L;
        if (noDrawLocs != null && noDrawLocs.size() > 1) {
            noDrawIndex = noDrawLocs.size() - 1;
            noDrawMilli = noDrawLocs.get(noDrawIndex).getTime();
        }
        float lastX = 0.0f;
        for (int i = locs.size() - 1; i >= 0; --i) {
            Rectangle2D r2d;
            long millis = i == 0 ? startDate : locs.get(i).getTime();
            float xLoc = x + (float)(millis - startDate) / (float)(endDate - startDate) * w;
            if (noDrawMilli == millis) {
                if (--noDrawIndex >= 0) {
                    noDrawMilli = noDrawLocs.get(noDrawIndex).getTime();
                }
            } else if (i > 0) {
                gp.moveTo(xLoc, y);
                gp.lineTo(xLoc, y + height);
            }
            if ((double)xLoc + 2.0 + (r2d = sizes.get(i)).getMaxX() < (double)(x + w) && (i > 0 || (double)xLoc + 3.0 + r2d.getMaxX() < (double)lastX)) {
                g2d.drawString(labels.get(i), xLoc + 2.0f, y + ascent);
            }
            lastX = xLoc;
        }
        g2d.fill(stroker.createStrokedShape(gp));
    }
}

