/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.tournament;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.igoweb.util.DbConn;

public class Bye
implements Comparable<Object> {
    public final Type type;
    public final int round;

    public Bye(int round, Type type) {
        if (round < 1) {
            throw new IllegalArgumentException("Invalid round of " + round);
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        this.round = round;
        this.type = type;
    }

    public Bye(int round, String typeName) {
        this(round, Type.get(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<Integer, ArrayList<Bye>> getByesForTournament(int tournId, DbConn db) throws SQLException {
        HashMap<Integer, ArrayList<Bye>> result = new HashMap<Integer, ArrayList<Bye>>();
        PreparedStatement ps = db.get("SELECT account_id, round, type  FROM tourns_byes  WHERE tourn_id = ?  ORDER BY round");
        ps.setInt(1, tournId);
        try (ResultSet rs = null;){
            rs = ps.executeQuery();
            while (rs.next()) {
                Integer accountId = Integer.valueOf(rs.getString("account_id"));
                ArrayList<Bye> list = result.get(accountId);
                if (list == null) {
                    list = new ArrayList();
                    result.put(accountId, list);
                }
                list.add(new Bye(rs.getInt("round"), rs.getString("type")));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Bye peer = (Bye)o;
        return this.round == peer.round && this.type == peer.type;
    }

    public int hashCode() {
        return this.round * -1640524983 + this.type.hashCode();
    }

    public String toString() {
        return "Bye[" + this.round + "," + (Object)((Object)this.type) + "]";
    }

    @Override
    public int compareTo(Object o) {
        Bye peer = (Bye)o;
        return this.round == peer.round ? this.type.compareTo(peer.type) : this.round - peer.round;
    }

    public static enum Type {
        PAIRED,
        REQUESTED,
        GRANTED,
        NO_SHOW;

        private static HashMap<String, Type> nameToType;
        public final String sqlName = this.name().toLowerCase(Locale.US);
        public static final int COUNT = 4;

        public static Type get(String sqlName) {
            Type result;
            if (nameToType == null) {
                Type.initNameToType();
            }
            if ((result = nameToType.get(sqlName)) == null) {
                throw new IllegalArgumentException("Invalid bye sql name: " + sqlName);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void initNameToType() {
            Class<Type> clazz = Type.class;
            synchronized (Type.class) {
                if (nameToType == null) {
                    HashMap<String, Type> map = new HashMap<String, Type>();
                    for (Type type : Type.values()) {
                        map.put(type.sqlName, type);
                    }
                    nameToType = map;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }
}

