/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.igoweb.util.DbConn;
import org.igoweb.util.jsp.InvoiceState;
import org.igoweb.util.jsp.PaymentMethod;

public class AbstractInvoice
implements Comparable<AbstractInvoice> {
    public final int id;
    public final int accountId;
    public final int productId;
    public final double cost;
    private double fee;
    public final PaymentMethod paymentMethod;
    public final List<Change> changes;

    public AbstractInvoice(DbConn db, int id, int accountId, int productId, double cost, double fee, PaymentMethod paymentMethod, String notes) throws SQLException {
        this.id = id;
        this.accountId = accountId;
        this.productId = productId;
        this.cost = cost;
        this.fee = fee;
        this.paymentMethod = paymentMethod;
        this.changes = new ArrayList<Change>();
        this.changes.add(new Change(db, id, InvoiceState.STARTED, notes));
    }

    public AbstractInvoice(ResultSet rs) throws SQLException {
        this.id = rs.getInt("invoices.id");
        this.accountId = rs.getInt("invoices.account_id");
        this.productId = rs.getInt("invoices.product_id");
        this.cost = rs.getDouble("invoices.cost");
        double tmpFee = rs.getDouble("invoices.fee");
        this.fee = rs.wasNull() ? -1.0 : tmpFee;
        this.paymentMethod = PaymentMethod.get(rs.getString("invoices.payment_method"));
        this.loadAuxColumns(rs);
        this.changes = new ArrayList<Change>();
        do {
            this.changes.add(new Change(rs));
        } while (rs.next() && rs.getInt("invoices.id") == this.id);
    }

    protected void loadAuxColumns(ResultSet rs) throws SQLException {
    }

    public InvoiceState getState() {
        return this.changes.get((int)(this.changes.size() - 1)).state;
    }

    @Override
    public int compareTo(AbstractInvoice peer) {
        long myStart = this.changes.get((int)0).when;
        long peerStart = peer.changes.get((int)0).when;
        return myStart > peerStart ? 1 : (myStart == peerStart ? this.id - peer.id : -1);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AbstractInvoice peer = (AbstractInvoice)o;
        return this.id == peer.id && this.accountId == peer.accountId && this.productId == peer.productId && this.cost == peer.cost && this.paymentMethod == peer.paymentMethod && this.changes.equals(peer.changes);
    }

    public int getId() {
        return this.id;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getProductId() {
        return this.productId;
    }

    public double getCost() {
        return this.cost;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public Change getStart() {
        return this.changes.get(0);
    }

    public List<Change> getLaterChanges() {
        return this.changes.subList(1, this.changes.size());
    }

    public int getNumChanges() {
        return this.changes.size();
    }

    public void addChange(DbConn db, InvoiceState newState, String notes) throws SQLException {
        this.changes.add(new Change(db, this.id, newState, notes));
    }

    protected void insertIntoDb(DbConn db) throws SQLException {
        PreparedStatement ps = db.get("INSERT INTO invoices    (id, account_id, product_id, cost, fee, payment_method" + this.getAuxColumns() + ")  VALUES (?, ?, ?, ?, ?, ?" + this.getAuxWildcards() + ")");
        ps.setInt(1, this.id);
        ps.setInt(2, this.accountId);
        ps.setInt(3, this.productId);
        ps.setDouble(4, this.cost);
        if (this.fee >= 0.0) {
            ps.setDouble(5, this.fee);
        } else {
            ps.setNull(5, 8);
        }
        ps.setString(6, this.paymentMethod.sqlName);
        this.setAuxColumns(ps, 7);
        ps.executeUpdate();
    }

    protected String getAuxColumns() {
        return "";
    }

    protected String getAuxWildcards() {
        return "";
    }

    protected void setAuxColumns(PreparedStatement ps, int paramIndex) throws SQLException {
    }

    public double getFee() {
        return this.fee;
    }

    public void setFee(DbConn db, double newFee) throws SQLException {
        PreparedStatement ps = db.get("UPDATE invoices SET fee = ? WHERE id = ?");
        if (newFee >= 0.0) {
            ps.setDouble(1, newFee);
        } else {
            ps.setNull(1, 8);
        }
        ps.setInt(2, this.id);
        ps.executeUpdate();
        this.fee = newFee;
    }

    protected void toString(StringBuilder str) {
        str.append("id=").append(this.id).append(", account=").append(this.accountId).append(", product=").append(this.productId).append(", cost=").append(this.cost);
        if (this.fee != -1.0) {
            str.append(", fee=").append(this.fee);
        }
        str.append(", method=").append((Object)this.paymentMethod).append(", changes=").append(this.changes);
    }

    public static class Change {
        public final long when;
        public final InvoiceState state;
        public final String notes;

        private Change(DbConn db, int invoiceId, InvoiceState state, String notes) throws SQLException {
            long now = System.currentTimeMillis();
            now -= now % 1000L;
            this.when = now;
            this.state = state;
            this.notes = notes;
            PreparedStatement ps = db.get("INSERT INTO invoices_changes    (invoice_id, change_time, state, notes)  VALUES    (?, ?, ?, ?)");
            ps.setInt(1, invoiceId);
            ps.setTimestamp(2, new Timestamp(this.when));
            ps.setString(3, state.sqlName);
            ps.setString(4, Change.cleanText(notes));
            ps.execute();
        }

        private Change(ResultSet rs) throws SQLException {
            this.when = rs.getTimestamp("invoices_changes.change_time").getTime();
            this.state = InvoiceState.get(rs.getString("invoices_changes.state"));
            this.notes = rs.getString("invoices_changes.notes");
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Change peer = (Change)o;
            return this.when == peer.when && this.state == peer.state && (this.notes == null ? peer.notes == null : this.notes.equals(peer.notes));
        }

        public Date getDate() {
            return new Date(this.when);
        }

        public InvoiceState getState() {
            return this.state;
        }

        public String getNotes() {
            return this.notes == null ? "" : this.notes;
        }

        public static String cleanText(String initial) {
            if (initial == null) {
                return initial;
            }
            for (int i = 0; i < initial.length(); ++i) {
                if (!Character.isISOControl(initial.charAt(i))) continue;
                StringBuilder sb = new StringBuilder(initial.substring(0, i));
                while (++i < initial.length()) {
                    char c = initial.charAt(i);
                    if (Character.isISOControl(c)) continue;
                    sb.append(c);
                }
                return sb.toString();
            }
            return initial;
        }

        public String toString() {
            return "Change[when=" + this.when + ", state=" + (Object)((Object)this.state) + ", notes=" + this.notes + ']';
        }
    }
}

