/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.speex;

import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.igoweb.util.Emitter;
import org.igoweb.util.Event;
import org.igoweb.util.speex.BitInputStream;
import org.igoweb.util.speex.BitIoError;
import org.xiph.speex.NbDecoder;

public class StreamPlayer
extends Emitter
implements Runnable {
    private static final int EVENT_BASE = 0;
    private FloatControl volumeCtrl;
    private boolean zeroVolume = false;
    public static final int CANT_START_EVENT = 0;
    public static final int CLOSED_EVENT = 1;
    public static final int ERROR_EVENT = 2;
    public static final int EVENT_LIMIT = 3;
    public static final int SAMPLES_PER_SECOND = 8000;
    public static final int MS_PER_FRAME = 20;
    private InputStream bytesIn;
    private final int framesPerPacket;
    private boolean started = false;
    private boolean readerThreadActive = false;
    private boolean outputThreadActive = false;
    private boolean closed = false;
    private final LinkedList<byte[]> decodedFrames = new LinkedList();
    private int frameDropLimit = Integer.MAX_VALUE;
    private static SourceDataLine dataLine;
    private static StreamPlayer dataLineInUse;
    private static Object dataLineLock;
    private static AudioPlayer audioPlayer;

    protected StreamPlayer(int framesPerPacket) {
        this.framesPerPacket = framesPerPacket;
    }

    public StreamPlayer(InputStream in, int framesPerPacket) {
        this.bytesIn = in;
        this.framesPerPacket = framesPerPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInput(InputStream in) {
        StreamPlayer streamPlayer = this;
        synchronized (streamPlayer) {
            this.bytesIn = in;
        }
    }

    public void setDropLimit(int newDropLimit) {
        this.frameDropLimit = newDropLimit / 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean startThread = false;
        Object object = this;
        synchronized (object) {
            this.started = true;
            if (!this.readerThreadActive) {
                this.readerThreadActive = true;
                startThread = true;
            }
        }
        object = this.decodedFrames;
        synchronized (object) {
            this.decodedFrames.clear();
            Object object2 = dataLineLock;
            synchronized (object2) {
                if (audioPlayer == null) {
                    audioPlayer = new AudioPlayer();
                    audioPlayer.start();
                }
                if (dataLineInUse == null || dataLineInUse == this) {
                    this.outputThreadActive = true;
                    dataLineInUse = this;
                    dataLineLock.notifyAll();
                }
            }
        }
        if (startThread) {
            new Thread((Runnable)this, "SPEEX Audio Player - reader thread").start();
        }
    }

    public void close() {
        this.closed = true;
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StreamPlayer streamPlayer = this;
        synchronized (streamPlayer) {
            this.started = false;
        }
        this.writeData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Event event = null;
        try {
            this.processStream();
            event = new Event(this, 1);
        }
        catch (BitIoError excep22) {
            if (!this.closed) {
                event = new Event(this, 2, excep22.getMessage());
            }
        }
        catch (StreamCorruptedException excep) {
            if (!this.closed) {
                event = new Event(this, 2, excep.getMessage());
            }
        }
        finally {
            StreamPlayer excep22 = this;
            synchronized (excep22) {
                this.readerThreadActive = false;
            }
            try {
                this.bytesIn.close();
            }
            catch (Exception excep22) {}
            this.bytesIn = null;
            this.writeData(null);
            this.waitForAudioOutDeath();
            if (event != null) {
                this.emit(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStream() throws BitIoError, StreamCorruptedException {
        NbDecoder decoder = new NbDecoder();
        decoder.nbinit();
        float[] floatPcmData = new float[decoder.getFrameSize()];
        BitInputStream bitsIn = new BitInputStream(this.bytesIn);
        while (true) {
            int bufferedFrames;
            StreamPlayer streamPlayer = this;
            synchronized (streamPlayer) {
                if (!this.started) {
                    return;
                }
            }
            LinkedList<byte[]> linkedList = this.decodedFrames;
            synchronized (linkedList) {
                bufferedFrames = this.decodedFrames.size();
            }
            for (int i = 0; i < this.framesPerPacket; ++i) {
                decoder.decode(bitsIn, floatPcmData);
                if (this.writePcmData(floatPcmData, bufferedFrames)) continue;
                return;
            }
            bitsIn.sync();
        }
    }

    protected boolean writePcmData(float[] floatPcmData, int bufferedFrames) {
        int dropRate = 0;
        if (bufferedFrames >= this.frameDropLimit && (dropRate = (bufferedFrames - this.frameDropLimit) * 4 / this.frameDropLimit) > 16) {
            dropRate = 16;
        }
        byte[] bytePcmData = new byte[(floatPcmData.length * (160 - dropRate) + dropRate) / 160 * 2];
        int dropCounter = 1;
        int byteCounter = 0;
        for (int j = 0; j < floatPcmData.length; ++j) {
            int ival = (int)floatPcmData[j];
            if (ival > Short.MAX_VALUE) {
                ival = Short.MAX_VALUE;
            } else if (ival < Short.MIN_VALUE) {
                ival = Short.MIN_VALUE;
            }
            bytePcmData[byteCounter++] = (byte)ival;
            bytePcmData[byteCounter++] = (byte)(ival >> 8);
            if ((dropCounter -= dropRate) > 0) continue;
            dropCounter += 160 - dropRate;
            ++j;
        }
        return this.writeData(bytePcmData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioOutDeath() {
        try {
            LinkedList<byte[]> linkedList = this.decodedFrames;
            synchronized (linkedList) {
                while (this.outputThreadActive) {
                    this.decodedFrames.wait();
                }
            }
        }
        catch (InterruptedException excep) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeData(byte[] data) {
        LinkedList<byte[]> linkedList = this.decodedFrames;
        synchronized (linkedList) {
            this.decodedFrames.addLast(data);
            this.decodedFrames.notifyAll();
            return this.outputThreadActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doAudioOut() {
        Object object;
        if (dataLine == null) {
            AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
            try {
                SourceDataLine localDataLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, format));
                localDataLine.open(format);
                localDataLine.start();
                dataLine = localDataLine;
            }
            catch (LineUnavailableException excep) {
                this.emit(0, excep.toString());
                return;
            }
            catch (IllegalArgumentException excep) {
                this.emit(0, excep.toString());
                return;
            }
        }
        this.volumeCtrl = (FloatControl)dataLine.getControl(FloatControl.Type.MASTER_GAIN);
        try {
            while (true) {
                byte[] data;
                object = this.decodedFrames;
                synchronized (object) {
                    while (this.decodedFrames.isEmpty()) {
                        this.decodedFrames.wait();
                    }
                    data = this.decodedFrames.removeFirst();
                }
                if (data == null) {
                    return;
                }
                if (this.zeroVolume) continue;
                dataLine.write(data, 0, data.length);
                continue;
                break;
            }
            catch (InterruptedException excep) {
                throw new RuntimeException();
            }
        }
        finally {
            object = this.decodedFrames;
            synchronized (object) {
                this.outputThreadActive = false;
                this.decodedFrames.notifyAll();
            }
            object = dataLineLock;
            synchronized (object) {
                dataLineInUse = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        LinkedList<byte[]> linkedList = this.decodedFrames;
        synchronized (linkedList) {
            return dataLineInUse == this && this.readerThreadActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(float volume) {
        Object object = dataLineLock;
        synchronized (object) {
            if (this.volumeCtrl == null) {
                return;
            }
            if (volume == 0.0f) {
                this.zeroVolume = true;
            } else {
                this.zeroVolume = false;
                float min = this.volumeCtrl.getMinimum();
                float max = this.volumeCtrl.getMaximum();
                this.volumeCtrl.setValue(volume * (max - min) + min);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getVolume() {
        Object object = dataLineLock;
        synchronized (object) {
            if (this.volumeCtrl == null || this.zeroVolume) {
                return 0.0f;
            }
            float min = this.volumeCtrl.getMinimum();
            float max = this.volumeCtrl.getMaximum();
            return (this.volumeCtrl.getValue() - min) / (max - min);
        }
    }

    public int getFramesPerPacket() {
        return this.framesPerPacket;
    }

    static {
        dataLineLock = new Object();
    }

    private static class AudioPlayer
    extends Thread {
        public AudioPlayer() {
            super("SPEEX Audio Player - sound thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    StreamPlayer toRun = null;
                    Object object = dataLineLock;
                    synchronized (object) {
                        while (dataLineInUse == null) {
                            dataLineLock.wait();
                        }
                        toRun = dataLineInUse;
                    }
                    toRun.doAudioOut();
                }
            }
            catch (InterruptedException excep) {
                throw new RuntimeException();
            }
        }
    }
}

