/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;

public class WindowList
extends JMenu
implements ActionListener {
    private String prefix;
    private final HashMap<JFrame, JMenuItem> win2menu = new HashMap();
    private final HashMap<JMenuItem, JFrame> menu2win = new HashMap();
    private final Listener listener = new Listener();

    public WindowList(String prefix) {
        super(Defs.getString(1436228512), true);
        this.prefix = prefix;
    }

    public void add(JFrame win) {
        if (this.win2menu.containsKey(win)) {
            return;
        }
        win.addWindowListener(this.listener);
        win.addPropertyChangeListener("title", this.listener);
        JMenuItem newMenuItem = new JMenuItem(this.findTitle(win.getTitle()));
        newMenuItem.addActionListener(this);
        this.win2menu.put(win, newMenuItem);
        this.menu2win.put(newMenuItem, win);
        super.add(newMenuItem);
    }

    private void retitle(Object win, String newTitle) {
        String title;
        JMenuItem menuItem = this.win2menu.get(win);
        if (menuItem != null && (title = this.findTitle(newTitle)) != null && !title.equals(menuItem.getText())) {
            menuItem.setText(title);
        }
    }

    private String findTitle(String title) {
        if (title != null && title.startsWith(this.prefix)) {
            title = title.substring(this.prefix.length());
        }
        return title;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AFrame win = (AFrame)this.menu2win.get(event.getSource());
        if (win != null) {
            win.toFront();
        }
    }

    public void windowClosed(WindowEvent event) {
        this.remove((AFrame)event.getSource());
    }

    public void remove(AFrame win) {
        win.removeWindowListener(this.listener);
        win.removePropertyChangeListener("title", this.listener);
        JMenuItem menuItem = this.win2menu.remove(win);
        super.remove(menuItem);
        this.menu2win.remove(menuItem);
    }

    public Collection<JFrame> getWindows() {
        return this.menu2win.values();
    }

    private class Listener
    extends WindowAdapter
    implements PropertyChangeListener {
        @Override
        public void windowClosed(WindowEvent event) {
            WindowList.this.remove((AFrame)event.getSource());
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            WindowList.this.retitle(event.getSource(), (String)event.getNewValue());
        }
    }
}

