/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Encoder;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.Stereo;

public class SpeexEncoder {
    public static final String VERSION = "Java Speex Encoder v0.9 ($Revision: 1.8 $)";
    private Encoder encoder;
    private Bits bits = new Bits();
    private float[] rawData;
    private int sampleRate;
    private int channels;
    private int frameSize;

    public boolean init(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                this.encoder = new NbEncoder();
                ((NbEncoder)this.encoder).nbinit();
                break;
            }
            case 1: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).wbinit();
                break;
            }
            case 2: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).uwbinit();
                break;
            }
            default: {
                return false;
            }
        }
        this.encoder.setQuality(n2);
        this.frameSize = this.encoder.getFrameSize();
        this.sampleRate = n3;
        this.channels = n4;
        this.rawData = new float[n3 * n4];
        this.bits.init();
        return true;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getProcessedData(byte[] byArray, int n) {
        int n2 = this.bits.getBufferSize();
        System.arraycopy(this.bits.getBuffer(), 0, byArray, n, n2);
        this.bits.init();
        return n2;
    }

    public int getProcessedDataByteSize() {
        return this.bits.getBufferSize();
    }

    public boolean processData(byte[] byArray, int n, int n2) {
        SpeexEncoder.mapPcm16bitLittleEndian2Float(byArray, n, this.rawData, 0, n2 / 2);
        return this.processData(this.rawData, n2 / 2);
    }

    public boolean processData(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.rawData[i] = sArray[n + i];
        }
        return this.processData(this.rawData, n2);
    }

    public boolean processData(float[] fArray, int n) {
        int n2 = this.channels * this.getFrameSize();
        if (n != n2) {
            throw new RuntimeException("SpeexEncoder requires " + n2 + " samples to process a Frame, not " + n);
        }
        if (this.channels == 2) {
            Stereo.encode(this.bits, fArray, n);
        }
        this.encoder.encode(this.bits, fArray);
        return true;
    }

    public static void mapPcm16bitLittleEndian2Float(byte[] byArray, int n, float[] fArray, int n2, int n3) {
        if (byArray.length - n < 2 * n3) {
            throw new IllegalArgumentException("Insufficient Samples to convert to floats");
        }
        if (fArray.length - n2 < n3) {
            throw new IllegalArgumentException("Insufficient float buffer to convert the samples");
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = byArray[n + 2 * i] & 0xFF | byArray[n + 2 * i + 1] << 8;
        }
    }
}

