/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.online.presenter;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.diylc.swing.plugins.online.model.ProjectEntity;
import org.diylc.swing.plugins.online.presenter.AlreadyExistsException;
import org.diylc.swing.plugins.online.presenter.MySqlDBManager;
import org.diylc.swing.plugins.online.presenter.NotConnectedException;
import org.diylc.swing.plugins.online.presenter.NotExistsException;
import org.diylc.swing.plugins.online.presenter.NotLoggedInException;

public class LibraryPresenter {
    private static final Logger LOG = Logger.getLogger(LibraryPresenter.class);
    private static final String DB_HOST = "diy-fever.com";
    private static final String DB_PORT = "3306";
    private static final String DB_USER = "diylc-app";
    private static final String DB_PASS = "zuf7RuS8";
    private static final String CATEGORY_SQL = "SELECT * FROM diylc.category WHERE 1=1";
    private static final String USER_SQL = "SELECT * FROM diylc.user WHERE name = \"%s\"";
    private static final String CREATE_USER_SQL = "INSERT INTO diylc.user (name, password, email) VALUES (\"%s\", \"%s\", \"%s\")";
    private static final String MY_PROJECTS_SQL = "SELECT project_id, name, category_id, description FROM diylc.project WHERE owner_user_id = %s";
    private static final String PROJECT_SQL = "SELECT content FROM diylc.project WHERE project_id = %s";
    private static final String UPLOAD_PROJECT_SQL = "INSERT INTO diylc.project (name, description, content, category_id, owner_user_id) VALUES (\"%s\", \"%s\", \"%s\", %s, %s)";
    private static final String UPDATE_PROJECT_SQL = "UPDATE diylc.project SET name = \"%s\", description = \"%s\", content = \"%s\", category_id = %s WHERE project_id = %s";
    private MySqlDBManager dbManager = new MySqlDBManager("diy-fever.com", "3306", "diylc-app", "zuf7RuS8");
    private MessageDigest messageDigest;
    private Integer currentUserId;

    public LibraryPresenter() {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"Could not initialize MD5, algorithm not found.");
        }
    }

    public boolean connectDb() {
        try {
            this.dbManager.connectDB();
            return true;
        }
        catch (Exception exception) {
            LOG.error((Object)("Could not connect to the database: " + exception.getMessage()));
            return false;
        }
    }

    public void createUser(String string, String string2, String string3) throws SQLException, NotConnectedException, AlreadyExistsException {
        LOG.info((Object)("Creating user: " + string));
        if (this.dbManager.isConnected()) {
            ResultSet resultSet = this.dbManager.getResultSet(String.format(USER_SQL, string));
            if (resultSet.next()) {
                throw new AlreadyExistsException();
            }
            this.dbManager.updateDB(String.format(CREATE_USER_SQL, string, this.hashPassword(string2), string3));
            resultSet = this.dbManager.getResultSet(String.format(USER_SQL, string));
            if (resultSet.next()) {
                LOG.info((Object)("Logged in as \"" + string + "\""));
                this.currentUserId = resultSet.getInt("user_id");
            }
        } else {
            LOG.error((Object)"Not connected");
            throw new NotConnectedException();
        }
    }

    public boolean login(String string, String string2) throws SQLException, NotConnectedException {
        LOG.info((Object)("Logging in as: " + string));
        if (this.dbManager.isConnected()) {
            ResultSet resultSet = this.dbManager.getResultSet(String.format(USER_SQL, string));
            if (resultSet.next()) {
                String string3;
                String string4 = resultSet.getString("password");
                if (string4.equals(string3 = this.hashPassword(string2))) {
                    LOG.info((Object)("Logged in as \"" + string + "\""));
                    this.currentUserId = resultSet.getInt("user_id");
                } else {
                    LOG.info((Object)"User name and password do not match.");
                }
            }
            return false;
        }
        LOG.error((Object)"Not connected");
        throw new NotConnectedException();
    }

    public Map<Integer, String> fetchCategories() throws SQLException, NotConnectedException {
        LOG.info((Object)"Fetching categories");
        if (this.dbManager.isConnected()) {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            ResultSet resultSet = this.dbManager.getResultSet(CATEGORY_SQL);
            while (resultSet.next()) {
                hashMap.put(resultSet.getInt("category_id"), resultSet.getString("name"));
            }
            return hashMap;
        }
        LOG.error((Object)"Not connected");
        throw new NotConnectedException();
    }

    public List<ProjectEntity> fetchMyProjectRows() throws NotLoggedInException, NotConnectedException, SQLException {
        if (this.dbManager.isConnected()) {
            if (this.isLoggedIn()) {
                Map<Integer, String> map = this.fetchCategories();
                ArrayList<ProjectEntity> arrayList = new ArrayList<ProjectEntity>();
                ResultSet resultSet = this.dbManager.getResultSet(String.format(MY_PROJECTS_SQL, this.currentUserId));
                while (resultSet.next()) {
                    arrayList.add(new ProjectEntity(resultSet.getInt("project_id"), resultSet.getString("name"), resultSet.getString("description"), "", map.get(resultSet.getInt("category_id"))));
                }
                return arrayList;
            }
            LOG.error((Object)"Not logged in");
            throw new NotLoggedInException();
        }
        LOG.error((Object)"Not connected");
        throw new NotConnectedException();
    }

    public String downloadProjectContent(int n) throws NotConnectedException, NotExistsException, SQLException {
        if (this.dbManager.isConnected()) {
            ResultSet resultSet = this.dbManager.getResultSet(String.format(PROJECT_SQL, n));
            if (resultSet.next()) {
                return resultSet.getString("content");
            }
            throw new NotExistsException("Project with id = " + n + " does not exist.");
        }
        LOG.error((Object)"Not connected");
        throw new NotConnectedException();
    }

    public List<ProjectEntity> fetchProjectRows(String string) {
        return null;
    }

    public boolean isLoggedIn() {
        return this.currentUserId != null;
    }

    public String hashPassword(String string) {
        this.messageDigest.reset();
        byte[] byArray = this.messageDigest.digest(string.getBytes());
        String string2 = "";
        for (byte by : byArray) {
            String string3 = Integer.toHexString(by);
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            string2 = string2 + string3.substring(string3.length() - 2);
        }
        return string2;
    }

    public void dispose() {
        this.dbManager.closeConnection();
    }
}

